package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractDetailEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.pick.bean.ProPickSettingEntity;
import com.ejianc.business.zdsmaterial.pick.vo.*;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.AuditorSetMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorContractDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorContractDetailVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorSetVO;
import com.ejianc.business.zdsmaterial.sub.fee.vo.AuditorUserDetailVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("auditorSetService")
public class AuditorSetServiceImpl extends BaseServiceImpl<AuditorSetMapper, AuditorSetEntity> implements IAuditorSetService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IProjectPoolApi projectPoolApi;
    @Autowired
    private IAuditorContractDetailService contractDetailService;



    @Autowired
    private ISubContractService contractService;
    @Override
    public CommonResponse<AuditorSetVO> saveOrUpdate(AuditorSetVO saveOrUpdateVO) {
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getContractDetailList())){
            contractService.AuditorSetStatus(saveOrUpdateVO);
        }
        AuditorSetEntity entity = BeanMapper.map(saveOrUpdateVO, AuditorSetEntity.class);
        super.saveOrUpdate(entity, false);
        CommonResponse<AuditorSetVO> proPickSettingVOCommonResponse = auditorSetByProjectId(entity.getProjectId());
        return CommonResponse.success("保存或修改单据成功！", proPickSettingVOCommonResponse.getData());
    }

    @Override
    public CommonResponse<Boolean> queryContract(AuditorContractDetailVO detailVO) {
        //一个合同只能在 同一个岗位下只能分配给一个人员。参照展示范围：如果此分包合同已经在左侧岗位+人员已分配，自动隐藏过滤，不能再次分配。
        //查询当前合同在对应的岗位下是否有人员
        //是否有了合同id 岗位id
        QueryWrapper<AuditorContractDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", detailVO.getContractId());
        queryWrapper.eq("station_id", detailVO.getStationId());
        queryWrapper.eq("dr", 0);
        int count = contractDetailService.count(queryWrapper);
        if (count > 0) {
            return CommonResponse.success("该合同在该岗位下已分配人员！", false);
        } else {
            return CommonResponse.success("该合同在该岗位下未分配人员！", true);
        }
    }

    @Override
    public List<Long> queryNotInContractId(AuditorContractDetailVO detailVO) {
        QueryWrapper<AuditorContractDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("station_id", detailVO.getStationId());
        queryWrapper.eq("user_id", detailVO.getStationId());
        queryWrapper.eq("dr", 0);


        return null;
    }

    @Override
    public CommonResponse<AuditorSetVO> auditorSetByProjectId(Long projectId) {
        AuditorSetEntity entity = new AuditorSetEntity();

        QueryWrapper<AuditorSetEntity> queryWrapper = new QueryWrapper();
        queryWrapper.eq("project_id", projectId);
        List<AuditorSetEntity> list = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            entity = super.selectById(list.get(0).getId());
        } else {
            //根据当前项目新增一个
            CommonResponse<JSONArray> projectResp = projectPoolApi.queryProjectPoolById(projectId);
            logger.error("根据项目Id-{}获取项目信息结果，{}", projectId, JSONObject.toJSONString(projectResp, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
            if (!projectResp.isSuccess() || projectResp.getData().size() == 0) {
                //未查询到当前项目信息
                return CommonResponse.error("网络异常,未查询到当前项目信息！");
            }
            ProjectPoolSetVO p = JSONObject.parseObject(JSONObject.toJSONString(projectResp.getData().get(0)), ProjectPoolSetVO.class);
            entity.setProjectId(p.getId());
            entity.setProjectName(p.getName());
            entity.setProjectCode(p.getCode());
            entity.setOrgId(p.getProjectDepartmentId());
            entity.setOrgName(p.getProjectDepartmentName());
            entity.setOrgCode(p.getProjectDepartmentCode());
            entity.setParentOrgId(p.getOrgId());
            entity.setParentOrgName(p.getOrgName());
            entity.setParentOrgCode(p.getOrgCode());
            boolean b = super.saveOrUpdate(entity);

        }
        AuditorSetVO map = BeanMapper.map(entity, AuditorSetVO.class);
        if (CollectionUtils.isNotEmpty(map.getUserDetailList())) {
            List<AuditorUserDetailVO> userDetailList = map.getUserDetailList();
            List<AuditorContractDetailVO> contractList = map.getContractDetailList();
            Map<Long, List<AuditorContractDetailVO>> collect = contractList.stream().collect(Collectors.groupingBy(e -> e.getUserDetailId()));

            for (AuditorUserDetailVO vo : userDetailList) {
                if (CollectionUtils.isNotEmpty(contractList) && collect.containsKey(vo.getRelationId())) {
                    vo.getContractDetailList().addAll(collect.get(vo.getRelationId()));
                }
            }
            map.setContractDetailList(null);

        }
        return CommonResponse.success("查询成功!", map);
    }

    /**
     * 查询合同绑定的审核工程师
     *
     * @param contractId
     * @return
     */
    @Override
    public List<AuditorContractDetailEntity> subContractList(Long contractId) {
        QueryWrapper<AuditorContractDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("station_code", "001");
        List<AuditorContractDetailEntity> list = contractDetailService.list(queryWrapper);
        return list;
    }


}
