package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.asynchandler.QueueUtils;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.BrandEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.ExpenseAccountEntity;
import com.ejianc.business.zdsmaterial.erp.service.IBrandService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IExpenseAccountService;
import com.ejianc.business.zdsmaterial.erp.vo.ExpenseAccountVO;
import com.ejianc.business.zdsmaterial.erp.vo.SyncJobExecRecordsVO;
import com.ejianc.business.zdsmaterial.plan.purchase.service.IPurchasePlanDetailService;
import com.ejianc.business.zdsmaterial.plan.purchase.vo.PurchasePlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.business.zdsmaterial.util.ZDSInterfaceCommonUtil;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/22 17:22
 */
@RestController
@RequestMapping(value = "/expenseAccount")
public class ExpenseAccountController {

    private final String ERP_EXPENSE_ACCOUNT_SYNC_URL = "/cefoc/yql/getFMPayment";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private IExpenseAccountService service;

    @Autowired
    private QueueUtils queueUtils;

    @Autowired
    private IPurchasePlanDetailService purchasePlanDetailService;

    @Autowired
    private IExpenseAccountDetailService detailService;

    @Autowired
    private IBrandService brandService;

    @Value("${spring.cloud.config.profile}")
    private String profile;

    /**
     * @Description 参照
     * @Return void
     */
    @GetMapping(value = "refExpenseAccountData")
    public CommonResponse<IPage<ExpenseAccountVO>> refExpenseAccountData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("orgCode");
        fuzzyFields.add("billCode");
        fuzzyFields.add("payee");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        params.put("allAcceptedFlag", new Parameter(QueryParam.EQ, PlanConstant.INTEGER_NO)); //查询明细未全部入库的
        params.put("status", new Parameter(QueryParam.EQ, "2")); //查询批准的报销单
        if(StringUtils.isNotBlank(condition)) {
            JSONObject paramJson = JSONObject.parseObject(condition);
            if(paramJson.containsKey("projectId")) {
                params.put("projectId", new Parameter(QueryParam.EQ, paramJson.get("projectId")));
            }
        }

        param.getOrderMap().put("createTime", "desc");

        IPage<ExpenseAccountEntity> page = service.queryPage(param,false);
        IPage<ExpenseAccountVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExpenseAccountVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }


    @PostMapping(value = "syncErpExpenseAccount")
    public CommonResponse<String> syncErpExpenseAccount(@RequestBody Map<String, String> params) {
        logger.info("*********************中电四-报销单信息同步任务 开始*********************");
        boolean noDate = null != params && null != params.get("noDate") ? "true".equals(params.get("noDate")) : false;
        String reqDateStr = null;
        String reqResp = null;
        Map<String, Object> param = new HashMap<>();
        JSONObject reqJson = null;
        JSONArray pageData = null;

        String reqUrl = ZDSInterfaceCommonUtil.getErpReqHost() + ERP_EXPENSE_ACCOUNT_SYNC_URL;
        //请求连续失败次数，连续两次请求失败时 任务终止
        Integer reqErrorTimes = null != params && null != params.get("reqErrorTimes") ? Integer.valueOf(params.get("reqErrorTimes")) : 0;

        if(!noDate) {
            //获取从今天往前2天内的数据
            reqDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", new Date());
            String startDateStr = DateFormatUtil.formatDate("yyyy-MM-dd", DateUtils.addDays(new Date(), -2)) + " 00:00:00";
            String endDateStr = reqDateStr + " 23:59:59";
            param.put("BeginDateTime", startDateStr);
            param.put("EndDateTime", endDateStr);
        }
        if(null != params.get("startDate")) {
            param.put("BeginDateTime", params.get("startDate"));
        }
        if(null != params.get("endDate")) {
            param.put("EndDateTime", params.get("endDate"));
        }

        if(null != params.get("projectCode") && StringUtils.isNotBlank(params.get("projectCode"))) {
            CommonResponse<ProjectPoolSetVO> projectResp = projectPoolApi.getOneByCode(params.get("projectCode"));
            if(!projectResp.isSuccess()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息失败！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息失败！");
            }
            if(null == projectResp.getData()) {
                logger.error("同步任务执行失败，根据项目编码-{}查询项目信息为空！", params.get("projectCode"));
                return CommonResponse.error("同步任务执行失败，根据项目编码查询项目信息为空！");
            }
            reqUrl = reqUrl + "?ProjectOID="+projectResp.getData().getSourceId();

            param.remove("BeginDateTime");
            param.remove("EndDateTime");
        }

        try {
            Map<String, String> headers = null;

            headers = ZDSInterfaceCommonUtil.getErpHeaders();
            reqResp = HttpTookit.postByJson(reqUrl, JSONObject.toJSONString(param), headers,
                    ZDSInterfaceCommonUtil.CONN_TIME_OUT, ZDSInterfaceCommonUtil.READ_TIME_OUT);
            reqJson = JSONObject.parseObject(reqResp);

            if ("ok".equals(reqJson.getString("status"))) {
                handleErpExpenseAccountData(reqJson);
            } else {
                logger.error("请求中电四获取报销单结果返回失败：请求地址-{},参数-{},header-{},结果-{}", reqUrl, JSONObject.toJSONString(param), JSONObject.toJSONString(headers), reqResp);
                queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                        new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, null)));
            }

        } catch (Exception e) {
            logger.error("获取中电四报销单信息异常, 请求地址：{}, 请求参数：{},e:", reqUrl, JSONObject.toJSONString(param, SerializerFeature.PrettyFormat),e);

            queueUtils.sendMq(SyncJobExecRecordsVO.QUEUE_NAME+"_"+profile, JSONObject.toJSONString(
                    new SyncJobExecRecordsVO(reqUrl, JSONObject.toJSONString(param), PlanConstant.STRING_YES, reqResp, e.getMessage())));

            reqErrorTimes++;
            if(reqErrorTimes >= 5) {
                return CommonResponse.error("同步中电四报销单信息异常");
            }
            try {
                logger.info("同步中电四报销单信息异常，5s后重试.........,");
                //休息1.5s
                Thread.sleep(5000);
                Map<String, String> reqParam = new HashMap<>();
                reqParam.put("reqErrorTimes", reqErrorTimes+"");
                reqParam.put("noDate", noDate+"");
                return syncErpExpenseAccount(reqParam);
            } catch (Exception e1) {
                logger.error("重启中电四银行支行同步接口异常,", e1);
                return CommonResponse.error("同步中电四银行信息异常");
            }
        }



        logger.info("*********************中电四-报销单信息同步任务 结束*********************");
        return CommonResponse.success("报销单信息同步任务执行成功！");
    }

    private void handleErpExpenseAccountData(JSONObject reqJson) {
        Map<String, ExpenseAccountEntity> sourceMap = new HashMap<>();
        JSONArray paymentList = reqJson.getJSONArray("PaymentList");
        logger.info("待处理主表数据：{}", null != paymentList ? paymentList.size() : 0);
        JSONObject tmp = null;
        ExpenseAccountEntity expenseAccountEntity = null;
        ExpenseAccountDetailEntity tempDetail = null;

        List<ExpenseAccountEntity> saveMainList = new ArrayList<>();
        List<ExpenseAccountEntity> updateMainList = new ArrayList<>();
        List<ExpenseAccountDetailEntity> saveSubList = new ArrayList<>();
        Set<String> projectSids = new HashSet<>();
        Set<String> brandSids = new HashSet<>();

        if(CollectionUtils.isEmpty(paymentList)) {
            logger.info("获取中电四报销单信息完成，本次待处理主表数据为空！");
            return;
        }

        for(Object obj : paymentList) {
            tmp = (JSONObject) obj;
            expenseAccountEntity = new ExpenseAccountEntity();
            expenseAccountEntity.setSourceId(tmp.getString("C_PS_FMPaymentOID").toLowerCase()); //ERP主键
            expenseAccountEntity.setProjectCode(tmp.getString("Account_Project_id")); //项目编码
            expenseAccountEntity.setProjectSid(tmp.getString("Account_Project_Sid")); //项目SID
            expenseAccountEntity.setPayee(tmp.getString("Payee")); //单位名称/收款人
            expenseAccountEntity.setBillCode(tmp.getString("ma_id")); //编码
            expenseAccountEntity.setStatus(tmp.getString("Status")); //审批状态
            expenseAccountEntity.setApprMny(tmp.getBigDecimal("ApprMoney")); //审批金额
            expenseAccountEntity.setAllAcceptedFlag(PlanConstant.STRING_NO); //默认子表明细未全部入库
            projectSids.add(expenseAccountEntity.getProjectSid());

            sourceMap.put(expenseAccountEntity.getSourceId(), expenseAccountEntity);
        }

        JSONArray paymentList_SubD = reqJson.getJSONArray("PaymentList_SubD");
        logger.info("待处理子表数据：{}", null != paymentList_SubD ? paymentList_SubD.size() : 0);
        Set<String> materialSerialNo = new HashSet<>();
        Set<String> sourceDetailIds = new HashSet<>();
        List<ExpenseAccountDetailEntity> tmpDetailList = new ArrayList<>();
        Map<String, ProjectPoolSetVO> projectSourceMap = new HashMap<>();

        if(null != paymentList_SubD) {
            for(Object obj : paymentList_SubD) {
                tmp = (JSONObject) obj;
                tempDetail = new ExpenseAccountDetailEntity();
                if(StringUtils.isBlank(tmp.getString("BrandSid")) || tmp.getBigDecimal("PurchaseAmount").compareTo(BigDecimal.ZERO) == 0) {
                    logger.info("报销单明细品牌或数量为空，跳过入库：{}", tmp.toString());
                    continue;
                }
                if(null == tmp.get("ListMaterialCode") || !tmp.getString("ListMaterialCode").startsWith("pd-")) {
                    logger.info("报销单明细非来源于EL采购计划，跳过入库：{}", tmp.toString());
                    continue;
                }
                tempDetail.setSourceDetailId(tmp.getString("C_PS_FMPayment_SubDOID").toLowerCase()); //ERP子表主键
                tempDetail.setSourceId(tmp.getString("FMPayment_FK").toLowerCase());
                tempDetail.setMemo(tmp.getString("Memo"));
                tempDetail.setSumpoint(tmp.getBigDecimal("sumpoint"));
                tempDetail.setPurchaseNum(tmp.getBigDecimal("PurchaseAmount"));
                tempDetail.setDetailTaxPrice(tmp.getBigDecimal("PurchasePrice")); //申请金额  ERP返回的实际是单价
                tempDetail.setDetailPrice(tmp.getBigDecimal("PurchasePrice"));//申请金额  ERP返回的实际是单价
                tempDetail.setDetailTaxMny(ComputeUtil.safeMultiply(tempDetail.getDetailTaxPrice(), tempDetail.getPurchaseNum()));
                tempDetail.setDetailMny(tempDetail.getDetailTaxMny());
                tempDetail.setMaterialSerialNo(tmp.getString("ListMaterialCode")); //物资流水号
                tempDetail.setBrandName(tmp.getString("Brand"));
                tempDetail.setBrandSid(tmp.getString("BrandSid"));

                brandSids.add(tempDetail.getBrandSid());

                if(!sourceMap.containsKey(tempDetail.getSourceId())) {
                    logger.info("报销单明细非无对应主表信息，跳过入库：{}", tmp.toString());
                    continue;
                }
                sourceMap.get(tempDetail.getSourceId()).getDetailList().add(tempDetail);
                sourceDetailIds.add(tempDetail.getSourceDetailId());
                materialSerialNo.add(tempDetail.getMaterialSerialNo());
            }
        }

        //查询库存中的主表信息
        List<ExpenseAccountEntity> dbList = service.getAllBySourceIds(new ArrayList<>(sourceMap.keySet()));
        List<ExpenseAccountDetailEntity> dbDetailList = detailService.getAllBySourceDetailIds(new ArrayList<>(sourceDetailIds));


        //查询品牌信息
        Map<String, BrandEntity> brandSidMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(brandSids)) {
            List<BrandEntity> dbBrands = brandService.getAllBySourceIds(new ArrayList<>(brandSids));
            if(CollectionUtils.isNotEmpty(dbBrands)) {
                brandSidMap.putAll(dbBrands.stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item)));
            }
        }

        //查询项目信息
        CommonResponse<List<ProjectPoolSetVO>> poolResp = projectPoolApi.getAllBySourceIds(new ArrayList<>(projectSids));
        if (!poolResp.isSuccess()) {
            throw new BusinessException("同步失败，根据ERP项目主键获取匹配项目信息失败！");
        }
        projectSourceMap = poolResp.getData().stream().collect(Collectors.toMap(item -> item.getSourceId(), item -> item));

        Map<String, ExpenseAccountDetailEntity> dbDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(dbDetailList)) {
            dbDetailMap.putAll(dbDetailList.stream().collect(Collectors.toMap(item -> item.getSourceDetailId(), item -> item)));
        }

        Map<String, PurchasePlanDetailVO> planDetailMap = new HashMap<>();
        if(CollectionUtils.isNotEmpty(materialSerialNo)) {
            List<PurchasePlanDetailVO> planDetails = purchasePlanDetailService.findAllByMaterialNos(new ArrayList<>(materialSerialNo));
            planDetailMap = planDetails.stream().collect(Collectors.toMap(item -> item.getMaterialSerialNo(), item -> item));
        }

        PurchasePlanDetailVO tmpPlanDetail = null;

        if(CollectionUtils.isNotEmpty(dbList)) {
            for(ExpenseAccountEntity dbEntity : dbList) {
                expenseAccountEntity = sourceMap.get(dbEntity.getSourceId());
                if(null != expenseAccountEntity) {
                    dbEntity.setStatus(expenseAccountEntity.getStatus());
                    dbEntity.setPayee(expenseAccountEntity.getPayee());
                    dbEntity.setBillCode(expenseAccountEntity.getBillCode());
                    dbEntity.setApprMny(expenseAccountEntity.getApprMny());

                    updateMainList.add(dbEntity);
                    for(ExpenseAccountDetailEntity detail : expenseAccountEntity.getDetailList()) {
                        if(!dbDetailMap.containsKey(detail.getSourceDetailId()) && planDetailMap.containsKey(detail.getMaterialSerialNo())) {
                            detail.setPid(dbEntity.getId());

                            if(brandSidMap.containsKey(detail.getBrandSid())) {
                                detail.setBrandName(brandSidMap.get(detail.getBrandSid()).getBrandName());
                                detail.setBrandId(brandSidMap.get(detail.getBrandSid()).getId());
//                                saveSubList.add(detail);
                            }

                            tmpPlanDetail = planDetailMap.get(detail.getMaterialSerialNo());
                            detail.setMaterialId(tmpPlanDetail.getMaterialId());
                            detail.setMaterialCode(tmpPlanDetail.getMaterialCode());
                            detail.setMaterialName(tmpPlanDetail.getMaterialName());
                            detail.setMaterialTypeId(tmpPlanDetail.getMaterialTypeId());
                            detail.setMaterialTypeName(tmpPlanDetail.getMaterialTypeName());
                            detail.setMaterialTypeCode(tmpPlanDetail.getMaterialTypeCode());
                            detail.setDetailUnitId(tmpPlanDetail.getUnitId());
                            detail.setDetailUnitName(tmpPlanDetail.getUnitName());
                            detail.setPropertyValue(tmpPlanDetail.getPropertyValue());
                            detail.setProductCode(tmpPlanDetail.getProductCode());
                            detail.setAcceptedNum(BigDecimal.ZERO); //初始化已验收量

                            saveSubList.add(detail);
                        }
                    }

                    sourceMap.remove(dbEntity.getSourceId());
                }
            }
        }

        if(!sourceMap.isEmpty()) {
            for(ExpenseAccountEntity e : sourceMap.values()) {
                e.setId(IdWorker.getId());

                boolean saveFlag = false;
                if(projectSourceMap.containsKey(e.getProjectSid())) {
                    e.setProjectCode(projectSourceMap.get(e.getProjectSid()).getCode());
                    e.setProjectName(projectSourceMap.get(e.getProjectSid()).getName());
                    e.setProjectId(projectSourceMap.get(e.getProjectSid()).getId());
                }

                if(CollectionUtils.isNotEmpty(e.getDetailList())) {
                    for(ExpenseAccountDetailEntity detail : e.getDetailList()) {
                        detail.setPid(e.getId());

                        if(!planDetailMap.containsKey(detail.getMaterialSerialNo())) {
                            logger.info("报销单明细【{}】 非来源于EL采购计划，跳过入库~", JSONObject.toJSONString(detail));
                            continue;
                        }
                        tmpPlanDetail = planDetailMap.get(detail.getMaterialSerialNo());
                        detail.setMaterialId(tmpPlanDetail.getMaterialId());
                        detail.setMaterialCode(tmpPlanDetail.getMaterialCode());
                        detail.setMaterialName(tmpPlanDetail.getMaterialName());
                        detail.setMaterialTypeId(tmpPlanDetail.getMaterialTypeId());
                        detail.setMaterialTypeName(tmpPlanDetail.getMaterialTypeName());
                        detail.setMaterialTypeCode(tmpPlanDetail.getMaterialTypeCode());
                        detail.setDetailUnitId(tmpPlanDetail.getUnitId());
                        detail.setDetailUnitName(tmpPlanDetail.getUnitName());
                        detail.setPropertyValue(tmpPlanDetail.getPropertyValue());
                        detail.setProductCode(tmpPlanDetail.getProductCode());
                        detail.setAcceptedNum(BigDecimal.ZERO); //初始化已验收量

                        if(brandSidMap.containsKey(detail.getBrandSid())) {
                            detail.setBrandName(brandSidMap.get(detail.getBrandSid()).getBrandName());
                            detail.setBrandId(brandSidMap.get(detail.getBrandSid()).getId());
                            saveSubList.add(detail);
                        }

                        saveFlag = true;
                    }

                    if(!saveFlag) {
                        logger.info("报销单：{}可保存子表为空，跳过入库~", JSONObject.toJSONString(e));
                    }
                    saveMainList.add(e);
                } else {
                    logger.info("报销单：{}可保存子表为空，跳过入库~", JSONObject.toJSONString(e));
                }
            }
        }

        logger.info("本次保存报销单主表：{}条", saveMainList.size());
        if(CollectionUtils.isNotEmpty(saveMainList)) {
            service.saveOrUpdateBatch(saveMainList, saveMainList.size(), false);
        }

        logger.info("本次更新报销单主表: {}条", updateMainList.size());
        if(CollectionUtils.isNotEmpty(updateMainList)) {
            service.saveOrUpdateBatch(updateMainList, updateMainList.size(), false);
        }

        logger.info("本次保存报销单字表：{}条", saveSubList.size());
        if(CollectionUtils.isNotEmpty(saveSubList)) {
            detailService.saveOrUpdateBatch(saveSubList, saveSubList.size(), false);
        }
    }

}
