package com.ejianc.business.zdsmaterial.plan.conjecture;

import com.ejianc.framework.core.exception.BusinessException;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: caojie
 * @CreateTime:2025-02-10 16:14
 * @Version: 1.0
 */
public enum ConjectureEnum {

    长江云通("CJYT","cJYTHandler", "single"),
    益企联("YQL","yQLHandler", "batch");

    final static Map<String, ConjectureEnum> enumMap = new HashMap<>();

    static {
        for(ConjectureEnum e : values()) {
            enumMap.put(e.getCode(), e);
        }
    }

    private String code;
    private String handlerName;
    private String handleMode;

    ConjectureEnum(String code, String handlerName, String handleMode) {
        this.code = code;
        this.handlerName = handlerName;
        this.handleMode = handleMode;
    }

    public static String getHandlerNameByCode(String code) {
        if(!enumMap.containsKey(code)) {
            throw new BusinessException("错误的处理类代码：" + code);
        }
        return enumMap.get(code).getHandlerName();
    }
    public static String getHandlerModeByCode(String code) {
        if(!enumMap.containsKey(code)) {
            throw new BusinessException("错误的处理类代码：" + code);
        }
        return enumMap.get(code).getHandleMode();
    }

    public String getCode() {
        return code;
    }

    public String getHandlerName() {
        return handlerName;
    }

    public void setHandlerName(String handlerName) {
        this.handlerName = handlerName;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getHandleMode() {
        return handleMode;
    }

    public void setHandleMode(String handleMode) {
        this.handleMode = handleMode;
    }
}
