package com.ejianc.business.zdsmaterial.asynchandler.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.asynchandler.service.IMaPushErpRecordsService;
import com.ejianc.business.zdsmaterial.erp.service.IBrandRelationService;
import com.ejianc.business.zdsmaterial.erp.vo.DataPushErpParam;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * 接受并保存推送ERP数据记录
 *
 * @author CJ
 * @Description:
 * @date 2024/4/24 11:31
 */
@Component
public class DatePushErpListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${spring.cloud.config.profile}")
    private String profile;

    @Autowired
    private IBrandRelationService relationService;

    @Autowired
    private IMaPushErpRecordsService service;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        logger.info("接收到待推送ERP数据记录：{}", mqMessage.getBody());
        try {
            DataPushErpParam param = JSONObject.parseObject(mqMessage.getBody().toString(), DataPushErpParam.class);

            if(null != param.getPushData()) {
                relationService.syncRelationToErp(param);
            }

            if(null != param.getPushCategory()) {
                categoryService.pushToErp(param);
            }
        } catch (Exception e) {
            logger.error("数据推送ERP记录异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{DataPushErpParam.DATA_PUSH_ERP_QUEUE +"_1"+profile};
    }
}
