package com.ejianc.business.zdsmaterial.plan.control.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdscost.api.IBudgetPorjectDetailApi;
import com.ejianc.business.zdscost.vo.BudgetProjectDetailVO;
import com.ejianc.business.zdscost.vo.query.BudgetProjectDetailQueryVO;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.material.bean.MaterialCategoryEntity;
import com.ejianc.business.zdsmaterial.material.bean.MaterialEntity;
import com.ejianc.business.zdsmaterial.material.service.IMaterialCategoryService;
import com.ejianc.business.zdsmaterial.material.service.IMaterialService;
import com.ejianc.business.zdsmaterial.plan.conjecture.bean.MaterialConjectureEntity;
import com.ejianc.business.zdsmaterial.plan.conjecture.constants.ConjectureConstants;
import com.ejianc.business.zdsmaterial.plan.conjecture.service.IMaterialConjectureService;
import com.ejianc.business.zdsmaterial.plan.conjecture.vo.MaterialConjectureVO;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanDetailEntity;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanImportEntity;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanDetailService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanImportService;
import com.ejianc.business.zdsmaterial.plan.control.service.IControlPlanService;
import com.ejianc.business.zdsmaterial.plan.control.vo.ControlPlanDetailVO;
import com.ejianc.business.zdsmaterial.util.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IUnitApi;
import com.ejianc.foundation.share.vo.UnitShareVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资总控计划明细
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("controlPlanDetail")
public class ControlPlanDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IControlPlanService planService;

    @Autowired
    private IControlPlanDetailService service;

    @Autowired
    private IBudgetPorjectDetailApi budgetPorjectDetailApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialService materialService;

    @Autowired
    private IMaterialCategoryService categoryService;

    @Autowired
    private IControlPlanImportService importService;

    @Autowired
    private IMaterialConjectureService materialConjectureService;

    @Autowired
    private IUnitApi unitApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> saveOrUpdate(@RequestBody ControlPlanDetailVO saveOrUpdateVO) {
        ControlPlanDetailEntity entity = BeanMapper.map(saveOrUpdateVO, ControlPlanDetailEntity.class);
//    	if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
//        }
        service.saveOrUpdate(entity, false);
        ControlPlanDetailVO vo = BeanMapper.map(entity, ControlPlanDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ControlPlanDetailVO> queryDetail(Long id) {
        ControlPlanDetailEntity entity = service.selectById(id);
        ControlPlanDetailVO vo = BeanMapper.map(entity, ControlPlanDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ControlPlanDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ControlPlanDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ControlPlanDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ControlPlanDetailEntity> page = service.queryPage(param,false);
        IPage<ControlPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ControlPlanDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ControlPlanDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
    //     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refControlPlanDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ControlPlanDetailVO>> refControlPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                               String condition,
                                                                               String searchObject,
                                                                               String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ControlPlanDetailEntity> page = service.queryPage(param,false);
        IPage<ControlPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ControlPlanDetailVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
    }

    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "ControlPlan-material-import.xlsx", "总控计划清单导入模板");
    }

    @RequestMapping(value = "/downloadBudgetDate")
    @ResponseBody
    public void downloadBudgetDate(Long projectId,String materialPackIds,String materialPackCodes,HttpServletRequest request, HttpServletResponse response){
        if (projectId == null ) {
            throw new BusinessException("参数项目ID[projectId]不能为空！");
        }
        BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
        queryVO.setProjectId(projectId);
        queryVO.setMaterialPackCodes(materialPackCodes);
        queryVO.setPageIndex(1);
        queryVO.setPageSize(-1);
        List<BudgetProjectDetailVO> list = new ArrayList();
        CommonResponse<Page<BudgetProjectDetailVO>> commonResponse = budgetPorjectDetailApi.queryList(queryVO);
        if (commonResponse.isSuccess()){
            list=commonResponse.getData().getRecords();
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("material-budget-import.xlsx", beans, response);
    }

    @PostMapping(value = "/saveImport")
    @ResponseBody
    public CommonResponse<String> saveImport(@RequestBody List<MaterialConjectureVO> saveList, HttpServletRequest req) {
        String authority = req.getHeader("authority");
        //保存入库
        materialConjectureService.saveOrUpdateBatch(BeanMapper.mapList(saveList, MaterialConjectureEntity.class), saveList.size(), false);

        //启动异步识别
        materialConjectureService.startConjecture(saveList.get(0).getIdentificationId(), authority, saveList.get(0).getMode());

        return CommonResponse.success("操作成功,物料识别中！");
    }


    @GetMapping(value = "/getConjectureProgress")
    @ResponseBody
    public CommonResponse<JSONObject> saveImport(@RequestParam String identificationId,
                                                 @RequestParam(required = false) String mateType,
                                                 @RequestParam(required = false) String actualCategoryName,
                                                 @RequestParam(required = false) String actualMaterialCode,
                                                 @RequestParam(required = false) String actualMaterialName,
                                                 @RequestParam(required = false) String actualMaterialSpec,
                                                 @RequestParam(required = false) String actualUnitName,
                                                 @RequestParam(required = false) BigDecimal actualNum) {
        JSONObject resp = new JSONObject();
        List<MaterialConjectureEntity> identifyList = materialConjectureService
                .getAllByIdentifyId(identificationId, null,actualCategoryName,actualMaterialCode,actualMaterialName,actualMaterialSpec,actualUnitName,actualNum);

        resp.put("total", identifyList.size());
        Integer completeMatch = 0, partialMatch = 0, misMatch = 0;

        resp.put("conjecturedNum", identifyList.stream().filter(item -> !"3".equals(item.getMateType())&&!"4".equals(item.getMateType())).count());
        List<MaterialConjectureEntity> respList = new ArrayList<>();
        for(MaterialConjectureEntity m :identifyList) {
            switch (m.getMateType()) {
                case "0": //不匹配
                    misMatch++;
                    break;
                case "1": //部分匹配
                    partialMatch++;
                    break;
                case "2": //完全匹配
                    completeMatch++;
                    break;
                default:;
            }
            if(StringUtils.isBlank(mateType) || "-1".equals(mateType) || (m.getMateType().equals(mateType))) {
                respList.add(m);
            }
        }

        resp.put("completeMatch", completeMatch);
        resp.put("partialMatch", partialMatch);
        resp.put("misMatch", misMatch);
        resp.put("identifyList", CollectionUtils.isNotEmpty(respList) ?
                BeanMapper.mapList(respList, MaterialConjectureVO.class) : new ArrayList<>());

        return CommonResponse.success(resp);
    }

    @PostMapping(value = "/delConjectureDetail")
    @ResponseBody
    public CommonResponse<String> delConjectureByIds(@RequestBody List<Long> detailIds) {
        materialConjectureService.delConjectureByIds(detailIds);
        return CommonResponse.success("操作成功！");
    }

    @PostMapping(value = "/excelImport")
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request ) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());
//                vo.setMaterialTypeName(datas.get(0));
                vo.setImportSeq(datas.get(0)); //序号
                vo.setSourceMaterialName(datas.get(1)); //物料名称
                vo.setSourceUnitName(datas.get(3)); //单位
                vo.setSourceMaterialSpec(datas.get(2)); //描述
                vo.setSourceNum(ComputeUtil.toBigDecimal(datas.get(4))); //数量
                vo.setActualNum(ComputeUtil.toBigDecimal(datas.get(4))); //数量
                if(StringUtils.isBlank(datas.get(1))){
                    vo.setErrorMsg("物料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(2))){
                    vo.setErrorMsg("描述不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("单位不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("数量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());

                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }

            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1,k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));

            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());

                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位与在系统中不存在！");
                    errorList.add(m);
                    continue;
                }
                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    @PostMapping(value = "/excelImportBudgetDate")
    @ResponseBody
    public CommonResponse<JSONObject> excelImportBudgetDate(Long projectId,String materialPackIds,String materialPackCodes,HttpServletRequest request ) {
        if (projectId == null ) {
            throw new BusinessException("参数项目ID[projectId]不能为空！");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        String conjectureId = request.getParameter("identificationId"); //导入序列
        String mode = request.getParameter("mode"); //识别渠道
        if(StringUtils.isBlank(mode)) { //默认长江云通
            mode = ConjectureConstants.CONJECTURE_TYPE_CJTY;
        }
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }

        List<MaterialConjectureVO> successList = new ArrayList<>();
        List<MaterialConjectureVO> processList = new ArrayList<>();
        List<MaterialConjectureVO> errorList = new ArrayList<>();
        Set<String> unitNames = new HashSet<>();

        List<List<String>> result = ExcelReader.readExcel(mf);
        if(result != null && result.size() > 0) {
            if(result.size() > 10000) {
                return CommonResponse.error("数据超过10000条，请分批上传！");
            }
            MaterialConjectureVO vo = null;

            for(int i = 0;i < result.size(); i++) {
                List<String> datas = result.get(i);
                vo = new MaterialConjectureVO();
                vo.setMode(mode);
                vo.setIdentificationId(conjectureId);
                vo.setMateType("4"); //默认待识别
                vo.setConjectureMateType("4"); //默认待识别
                vo.setDelFlag("0");//未作废
                vo.setIgnoreFlag("0");//未忽略
                vo.setLoadState("0");//未加载
                vo.setIdentificationDate(new Date());
                vo.setId(IdWorker.getId());
//                vo.setMaterialTypeName(datas.get(0));
                vo.setImportSeq(datas.get(0)); //序号
                vo.setMaterialPackName(datas.get(1)); //包名称
                vo.setItemCode(datas.get(2)); //清单编码
                vo.setSourceMaterialName(datas.get(3)); //物料名称
                vo.setSourceUnitName(datas.get(5)); //单位
                vo.setSourceMaterialSpec(datas.get(4)); //描述
                vo.setSourceNum(ComputeUtil.toBigDecimal(datas.get(6))); //数量
                vo.setActualNum(ComputeUtil.toBigDecimal(datas.get(6))); //数量
                vo.setBudgetType("1");
//                if(StringUtils.isBlank(datas.get(1))){
//                    vo.setErrorMsg("包名称不能为空！");
//                    errorList.add(vo);
//                    continue;
//                }
//                if(StringUtils.isBlank(datas.get(2))){
//                    vo.setErrorMsg("清单编码不能为空！");
//                    errorList.add(vo);
//                    continue;
//                }
                if(StringUtils.isBlank(datas.get(3))){
                    vo.setErrorMsg("物料名称不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(4))){
                    vo.setErrorMsg("描述不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(5))){
                    vo.setErrorMsg("单位不能为空！");
                    errorList.add(vo);
                    continue;
                }
                if(StringUtils.isBlank(datas.get(6))){
                    vo.setErrorMsg("数量不能为空！");
                    errorList.add(vo);
                    continue;
                }
                unitNames.add(vo.getSourceUnitName());

                vo.setRowState("add");
                processList.add(vo);
            }
        }

        if(CollectionUtils.isNotEmpty(processList)) {
            CommonResponse<List<UnitShareVO>> unitListResp = unitApi.findAllEnabledList(new ArrayList<>(unitNames));
            if(!unitListResp.isSuccess()) {
                logger.error("物料ai导入识别失败，获取单据信息失败,names:{}, 结果：{}", JSONObject.toJSONString(unitNames), JSONObject.toJSONString(unitListResp));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            if(CollectionUtils.isEmpty(unitListResp.getData())) {
                logger.error("物料ai导入识别失败，获取单据信息为空, names:{}", JSONObject.toJSONString(unitNames));
                return CommonResponse.error("操作失败，匹配计量单位信息失败！");
            }
            BudgetProjectDetailQueryVO queryVO = new BudgetProjectDetailQueryVO();
            queryVO.setProjectId(projectId);
            queryVO.setMaterialPackCodes(materialPackCodes);
            queryVO.setPageIndex(1);
            queryVO.setPageSize(-1);
            CommonResponse<Page<BudgetProjectDetailVO>> commonResponse = budgetPorjectDetailApi.queryList(queryVO);
            if (!commonResponse.isSuccess()){
                logger.error("查询切包清单失败失败，结果:{}", JSONObject.toJSONString(commonResponse));
            }

            Map<String, Long> unitNameIdMap = new HashMap<>();
            Map<String, Long> unitAliasNameIdMap = new HashMap<>();
            Map<String, BudgetProjectDetailVO> budegetMap = new HashMap<>();
            unitNameIdMap.putAll(unitListResp.getData().stream().collect(Collectors.toMap(UnitShareVO::getUnitName, UnitShareVO::getId, (k1,k2) -> k1)));
            unitAliasNameIdMap.putAll(unitListResp.getData().stream().filter(item -> StringUtils.isNotBlank(item.getAliasName())).collect(Collectors.toMap(item -> item.getAliasName(), UnitShareVO::getId, (k1,k2) -> k1)));
            if (null !=commonResponse.getData()) {
                budegetMap.putAll(commonResponse.getData().getRecords().stream().collect(Collectors.toMap(item -> item.getMaterialPackName() + item.getItemCode(),
                        Function.identity(), (v1, v2) -> v2)));
            }
            for(MaterialConjectureVO m : processList) {
                m.setActualUnitName(m.getSourceUnitName());
                if(unitNameIdMap.containsKey(m.getSourceUnitName())) {
                    m.setActualUnitId(unitNameIdMap.get(m.getSourceUnitName()));
                }
                for(String key : unitAliasNameIdMap.keySet()) {
                    if(key.contains(","+m.getSourceUnitName()+",")) {
                        m.setActualUnitId(unitAliasNameIdMap.get(key));
                    }
                }

                if(null == m.getActualUnitId()) {
                    m.setErrorMsg("计量单位与在系统中不存在！");
                    errorList.add(m);
                    continue;
                }
                ///
                BudgetProjectDetailVO budgetProjectDetailVO = budegetMap.get(m.getMaterialPackName()+m.getItemCode());
                if (null == budgetProjectDetailVO){
//                    m.setErrorMsg("清单在切包清单中不存在！");
//                    errorList.add(m);
//                    continue;
                } else {
                    m.setItemName(budgetProjectDetailVO.getItemName());
                    m.setMaterialPackId(budgetProjectDetailVO.getMaterialPackId());
                    m.setMaterialPackCode(budgetProjectDetailVO.getMaterialPackCode());
                    m.setBudgetDetailId(budgetProjectDetailVO.getId());
                }
                successList.add(m);
            }
        }

        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("successNum", successList.size());
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * 完全匹配
     * @param vo
     * @return
     */
    private List<ControlPlanDetailVO> getMatchSameList(ControlPlanDetailVO vo) {
        List<ControlPlanDetailVO> matchList = new ArrayList<>();
        QueryWrapper<MaterialEntity> ew = new QueryWrapper<>();
        ew.eq("enabled", 1);// 启用
        ew.eq("category_name", vo.getMaterialTypeName());
        ew.and(iq -> iq.eq("product_code", vo.getDescription()).or().eq("property_show_name", vo.getDescription()));
        List<MaterialEntity> list = materialService.list(ew);
        List<Long> materialTypeIds = list.stream().map(x->x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = planService.getParentMaterialTypeMap(materialTypeIds);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setMatchState(PlanConstant.MATCH_SAME);
            for(MaterialEntity material : list){
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                // 二级分类信息赋值
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if(parentMap.containsKey(material.getCategoryId())){
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }

    /**
     * 历史匹配
     * @param vo
     * @return
     */
    private List<ControlPlanDetailVO> getMatchHistoryList(ControlPlanDetailVO vo) {
        List<ControlPlanDetailVO> matchList = new ArrayList<>();
        QueryWrapper<ControlPlanImportEntity> ew = new QueryWrapper<>();
        ew.eq("material_type_name", vo.getMaterialTypeName());
        ew.eq("description", vo.getDescription());
        List<ControlPlanImportEntity> list = importService.list(ew);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setMatchState(PlanConstant.MATCH_HISTORY);
            matchList = BeanMapper.mapList(list, ControlPlanDetailVO.class);
            for(ControlPlanDetailVO match : matchList){
                match.setRowState("add");
            }
        }
        return matchList;
    }

    /**
     * 模糊匹配
     * @param vo
     * @return
     */
    private List<ControlPlanDetailVO> getMatchLikeList(ControlPlanDetailVO vo) {
        List<ControlPlanDetailVO> matchList = new ArrayList<>();
        QueryWrapper<MaterialEntity> ew = new QueryWrapper<>();
        ew.eq("enabled", 1);// 启用
        ew.eq("category_name", vo.getMaterialTypeName());
        ew.and(iq -> iq.like("product_code", vo.getDescription()).or().like("property_show_name", vo.getDescription()));
        List<MaterialEntity> list = materialService.list(ew);
        List<Long> materialTypeIds = list.stream().map(x->x.getCategoryId()).distinct().collect(Collectors.toList());
        Map<Long, MaterialCategoryEntity> parentMap = planService.getParentMaterialTypeMap(materialTypeIds);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setMatchState(PlanConstant.MATCH_LIKE);
            for(MaterialEntity material : list){
                ControlPlanDetailVO match = new ControlPlanDetailVO();
                match.setId(material.getId());
                match.setMaterialTypeId(material.getCategoryId());
                match.setMaterialTypeName(material.getCategoryName());
                match.setMaterialTypeCode(material.getCategoryCode());
                match.setMaterialId(material.getId());
                match.setMaterialCode(material.getCode());
                match.setMaterialName(material.getName());
                match.setUnitId(material.getUnitId());
                match.setUnitName(material.getUnitName());
                match.setProductCode(material.getProductCode());
                match.setPropertyValue(material.getPropertyShowName());
                // 二级分类信息赋值
                MaterialCategoryEntity parent = new MaterialCategoryEntity();
                if(parentMap.containsKey(material.getCategoryId())){
                    parent = parentMap.get(material.getCategoryId());
                }
                match.setParentMaterialTypeId(parent.getId());
                match.setParentMaterialTypeCode(parent.getCode());
                match.setParentMaterialTypeName(parent.getName());
                match.setRowState("add");
                matchList.add(match);
            }
        }
        return matchList;
    }
}
