package com.ejianc.business.zdsmaterial.plan.purchase.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 采购计划
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_purchase_plan")
public class PurchasePlanEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="org_id")
    private Long orgId; // 单据组织id
    @TableField(value="org_name")
    private String orgName; // 单据组织名称
    @TableField(value="org_code")
    private String orgCode; // 单据组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="engineer_id")
    private Long engineerId; // 主责工程师id
    @TableField(value="engineer_name")
    private String engineerName; // 主责工程师name
    @TableField(value="engineer_code")
    private String engineerCode; // 主责工程师code
    @TableField(value="project_manager_id")
    private Long projectManagerId; // 项目经理id
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理
    @TableField(value="project_manager_code")
    private String projectManagerCode; // 项目经理
    @TableField(value="chief_engineer_id")
    private Long chiefEngineerId; // 项目总工id
    @TableField(value="chief_engineer_name")
    private String chiefEngineerName; // 项目总工name
    @TableField(value="chief_engineer_code")
    private String chiefEngineerCode; // 项目总工code
    @TableField(value="plan_name")
    private String planName; // 计划名称
    @TableField(value="compile_name")
    private String compileName; // 编制人name
    @TableField(value="excess_flag")
    private Integer excessFlag; // 是否存在超量明细 1：是； 0：否 超量审批用
    @TableField(value="excess_bpm_flag")
    private Integer excessBpmFlag; // 是否超量审批 1：是； 0：否 超量审批用
    @TableField(value="new_mat_flag")
    private Integer newMatFlag; // 是否有新增材料编码：0-否，1-是

    @TableField(value="excess_status")
    private Integer excessStatus; //         {"1 仅提示", " 2 超量审批", " 3 不可提交"};

    @TableField(value="push_status")
    private Integer pushStatus; // 推送状态：0-否，1-是
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_type_names")
    private String materialTypeNames; // 材料分类
    @TableField(value="create_user_name")
    private String createUserName;// 编制者名称


    @TableField(value="business_contract_id")
    private String businessContractId; // 商务合同id
    @TableField(value="business_contract_name")
    private String businessContractName; // 商务合同name
    @TableField(value="business_contract_code")
    private String businessContractCode; // 商务合同code

    @TableField(exist=false)
    @SubEntity(serviceName="purchasePlanDetailService" , pidName = "planId")//此处有，默认值pid="pid"
    private List<PurchasePlanDetailEntity> detailList = new ArrayList<>(); // 采购计划详情
    @TableField(value="has_new_property_val")
    private Integer hasNewPropertyVal; // 是否新增属性值：0-否，1-是


    @TableField(value="purchase_worker_id")
    private Long purchaseWorkerId; // 采购工程师
    @TableField(value="purchase_worker_name")
    private String purchaseWorkerName; // 采购工程师

    @TableField(value="job_specialty_id")
    private Long jobSpecialtyId; // 工作专业
    @TableField(value="job_specialty_name")
    private String jobSpecialtyName; // 工作专业
    @TableField(value="job_specialty_code")
    private String jobSpecialtyCode; // 工作专业

    @TableField(value="commit_user_id")
    private Long commitUserId; // 提交人主键
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人编码
    @TableField(value="approve_user_id")
    private Long approveUserId; // 审批人主键
    @TableField(value="approve_user_name")
    private String approveUserName; // 审批人名称
    @TableField(value="approve_user_code")
    private String approveUserCode; // 审批人编码

    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="effect_date")
    private Date effectDate; // 生效日期

    @TableField(value="user_post_name")
    private String userPostName;// 编制者岗位
    @TableField(value="user_depart_name")
    private String userDepartName;// 编制者部门
    @TableField(value="user_org_name")
    private String userOrgName;// 编制者组织
    @TableField(value="engineer_sid")
    private String engineerSid; // 主责工程师sid

    @TableField(value="commit_user_sid")
    private String commitUserSid; // 提交人s主键

    @TableField(value="project_manager_sid")
    private String projectManagerSid; // 项目经理sid
    @TableField(value="chief_engineer_sid")
    private String chiefEngineerSid; // 项目总工sid

    @TableField(value="purchase_worker_sid")
    private String purchaseWorkerSid; // 采购工程师sid

    @TableField(value="approve_user_sid")
    private String approveUserSid; // 审批人sid
    @TableField(value="create_user_id")
    private Long createUserId; // 创建人id
    @TableField(value="create_user_sid")
    private String createUserSid; // 创建人sid
    @TableField(value="project_sid")
    private String projectSid;//项目来源id

    @TableField(value = "budget_ver")
    private String budgetVer; //采购计划所属项目管控方式：0-费用包控制，1-清单管控281905，2-切包管控

    @TableField(value = "pack_id")
    private Long packId; // 费用包id
    @TableField(value = "pack_code")
    private String packCode; // 费用包code
    @TableField(value = "pack_name")
    private String packName; // 费用包name
    @TableField(value = "material_pack_ids")
    private String materialPackIds; // 物资分类ids

    @TableField(value = "cur_identify_id")
    private String curIdentifyId; //当前物料识别标识

    public String getCurIdentifyId() {
        return curIdentifyId;
    }

    public void setCurIdentifyId(String curIdentifyId) {
        this.curIdentifyId = curIdentifyId;
    }

    public String getMaterialPackIds() {
        return materialPackIds;
    }

    public void setMaterialPackIds(String materialPackIds) {
        this.materialPackIds = materialPackIds;
    }

    public Long getPackId() {
        return packId;
    }

    public void setPackId(Long packId) {
        this.packId = packId;
    }

    public String getPackCode() {
        return packCode;
    }

    public void setPackCode(String packCode) {
        this.packCode = packCode;
    }

    public String getPackName() {
        return packName;
    }

    public void setPackName(String packName) {
        this.packName = packName;
    }

    public String getBudgetVer() {
        return budgetVer;
    }

    public void setBudgetVer(String budgetVer) {
        this.budgetVer = budgetVer;
    }

    public Integer getExcessBpmFlag() {
        return excessBpmFlag;
    }

    public void setExcessBpmFlag(Integer excessBpmFlag) {
        this.excessBpmFlag = excessBpmFlag;
    }

    public String getJobSpecialtyCode() {
        return jobSpecialtyCode;
    }

    public void setJobSpecialtyCode(String jobSpecialtyCode) {
        this.jobSpecialtyCode = jobSpecialtyCode;
    }

    public String getProjectSid() {
        return projectSid;
    }

    public void setProjectSid(String projectSid) {
        this.projectSid = projectSid;
    }

    public String getBusinessContractId() {
        return businessContractId;
    }

    public void setBusinessContractId(String businessContractId) {
        this.businessContractId = businessContractId;
    }

    public String getBusinessContractName() {
        return businessContractName;
    }

    public void setBusinessContractName(String businessContractName) {
        this.businessContractName = businessContractName;
    }

    public String getBusinessContractCode() {
        return businessContractCode;
    }

    public void setBusinessContractCode(String businessContractCode) {
        this.businessContractCode = businessContractCode;
    }

    public String getEngineerSid() {
        return engineerSid;
    }

    public void setEngineerSid(String engineerSid) {
        this.engineerSid = engineerSid;
    }

    public String getCommitUserSid() {
        return commitUserSid;
    }

    public void setCommitUserSid(String commitUserSid) {
        this.commitUserSid = commitUserSid;
    }

    public String getProjectManagerSid() {
        return projectManagerSid;
    }

    public void setProjectManagerSid(String projectManagerSid) {
        this.projectManagerSid = projectManagerSid;
    }

    public String getChiefEngineerSid() {
        return chiefEngineerSid;
    }

    public void setChiefEngineerSid(String chiefEngineerSid) {
        this.chiefEngineerSid = chiefEngineerSid;
    }

    public String getPurchaseWorkerSid() {
        return purchaseWorkerSid;
    }

    public void setPurchaseWorkerSid(String purchaseWorkerSid) {
        this.purchaseWorkerSid = purchaseWorkerSid;
    }

    public String getApproveUserSid() {
        return approveUserSid;
    }

    public void setApproveUserSid(String approveUserSid) {
        this.approveUserSid = approveUserSid;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserSid() {
        return createUserSid;
    }

    public void setCreateUserSid(String createUserSid) {
        this.createUserSid = createUserSid;
    }

    public String getUserPostName() {
        return userPostName;
    }

    public void setUserPostName(String userPostName) {
        this.userPostName = userPostName;
    }

    public String getUserDepartName() {
        return userDepartName;
    }

    public void setUserDepartName(String userDepartName) {
        this.userDepartName = userDepartName;
    }

    public String getUserOrgName() {
        return userOrgName;
    }

    public void setUserOrgName(String userOrgName) {
        this.userOrgName = userOrgName;
    }

    public Long getCommitUserId() {
        return commitUserId;
    }

    public void setCommitUserId(Long commitUserId) {
        this.commitUserId = commitUserId;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Long getApproveUserId() {
        return approveUserId;
    }

    public void setApproveUserId(Long approveUserId) {
        this.approveUserId = approveUserId;
    }

    public String getApproveUserName() {
        return approveUserName;
    }

    public void setApproveUserName(String approveUserName) {
        this.approveUserName = approveUserName;
    }

    public String getApproveUserCode() {
        return approveUserCode;
    }

    public void setApproveUserCode(String approveUserCode) {
        this.approveUserCode = approveUserCode;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public Long getPurchaseWorkerId() {
        return purchaseWorkerId;
    }

    public void setPurchaseWorkerId(Long purchaseWorkerId) {
        this.purchaseWorkerId = purchaseWorkerId;
    }

    public String getPurchaseWorkerName() {
        return purchaseWorkerName;
    }

    public void setPurchaseWorkerName(String purchaseWorkerName) {
        this.purchaseWorkerName = purchaseWorkerName;
    }

    public Long getJobSpecialtyId() {
        return jobSpecialtyId;
    }

    public void setJobSpecialtyId(Long jobSpecialtyId) {
        this.jobSpecialtyId = jobSpecialtyId;
    }

    public String getJobSpecialtyName() {
        return jobSpecialtyName;
    }

    public void setJobSpecialtyName(String jobSpecialtyName) {
        this.jobSpecialtyName = jobSpecialtyName;
    }

    public Integer getHasNewPropertyVal() {
        return hasNewPropertyVal;
    }

    public void setHasNewPropertyVal(Integer hasNewPropertyVal) {
        this.hasNewPropertyVal = hasNewPropertyVal;
    }

    public Integer getExcessStatus() {
        return excessStatus;
    }

    public void setExcessStatus(Integer excessStatus) {
        this.excessStatus = excessStatus;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEngineerId() {
        return engineerId;
    }

    public void setEngineerId(Long engineerId) {
        this.engineerId = engineerId;
    }
    public String getEngineerName() {
        return engineerName;
    }

    public void setEngineerName(String engineerName) {
        this.engineerName = engineerName;
    }
    public String getEngineerCode() {
        return engineerCode;
    }

    public void setEngineerCode(String engineerCode) {
        this.engineerCode = engineerCode;
    }
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }
    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }
    public String getProjectManagerCode() {
        return projectManagerCode;
    }

    public void setProjectManagerCode(String projectManagerCode) {
        this.projectManagerCode = projectManagerCode;
    }
    public Long getChiefEngineerId() {
        return chiefEngineerId;
    }

    public void setChiefEngineerId(Long chiefEngineerId) {
        this.chiefEngineerId = chiefEngineerId;
    }
    public String getChiefEngineerName() {
        return chiefEngineerName;
    }

    public void setChiefEngineerName(String chiefEngineerName) {
        this.chiefEngineerName = chiefEngineerName;
    }
    public String getChiefEngineerCode() {
        return chiefEngineerCode;
    }

    public void setChiefEngineerCode(String chiefEngineerCode) {
        this.chiefEngineerCode = chiefEngineerCode;
    }
    public String getPlanName() {
        return planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }
    public String getCompileName() {
        return compileName;
    }

    public void setCompileName(String compileName) {
        this.compileName = compileName;
    }
    public Integer getExcessFlag() {
        return excessFlag;
    }

    public void setExcessFlag(Integer excessFlag) {
        this.excessFlag = excessFlag;
    }

    public Integer getNewMatFlag() {
        return newMatFlag;
    }

    public void setNewMatFlag(Integer newMatFlag) {
        this.newMatFlag = newMatFlag;
    }

    public Integer getPushStatus() {
        return pushStatus;
    }

    public void setPushStatus(Integer pushStatus) {
        this.pushStatus = pushStatus;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    public List<PurchasePlanDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<PurchasePlanDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
