package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.erp.bean.SubContractEntity;
import com.ejianc.business.zdsmaterial.erp.service.ISubContractService;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.SubFeeApplyMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.business.zdsmaterial.util.BillLockUtil;
import com.ejianc.business.zdsmaterial.util.CommonUtils;
import com.ejianc.business.zdsmaterial.util.DateUtil;
import com.ejianc.business.zdsmaterial.util.MsgSendUtil;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import feign.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包费用申请实体
 *
 * @author generator
 *
 */
@Service("subFeeApplyService")
public class SubFeeApplyServiceImpl extends BaseServiceImpl<SubFeeApplyMapper, SubFeeApplyEntity> implements ISubFeeApplyService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_TYPE = PlanConstant.SUB_FEE_APPLY_BILL_TYPE;
    private static final String BILL_NAME = "分包费用申请";
    private static final String supSignFileSourceType = "signature";
    private static final String PUSH_BILL_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subFeeApply/saveSyncBill";
    private static final String BILL_WITER_BACK_SERVER_URL = "/ejc-zdssupbusiness-web/openapi/subFeeApply/supSignSync";

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private ISubContractService contractService;

    @Autowired
    private ISubLinkerApi linkerApi;

    @Autowired
    private MsgSendUtil msgSendUtil;

    @Autowired
    private SubFeeApplyMapper mapper;

    @Autowired
    private IEmployeeApi employeeApi;

    @Override
    public Long pushBillToSupCenter(SubFeeApplyEntity entity) {
        Long sourceId = null;
        try {
            //对单据进行加锁
            BillLockUtil.getLock(BILL_TYPE, entity.getId());

            Map<String, String> paramMap = new HashMap<>();
            SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
            paramMap.put("transData", JSONObject.toJSONString(vo));
            paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(new HashMap<>()));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, null, null);
            Map<String, Map<String, InputStream>> files = new HashMap<>();
            if (fileResp.isSuccess()) {
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put(fileKey, file);
                    });
                }
            } else {
                logger.error("获取单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }
            logger.info("向供方-{}推送单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));
            //推送单据到指定的供方
            CommonResponse<String> syncResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(
                    PUSH_BILL_SERVER_URL, paramMap, String.valueOf(entity.getSupplierId()), files);
            if (syncResp.isSuccess()) {
                CommonResponse<String> resp = JSONObject.parseObject(syncResp.getData(), CommonResponse.class);
                if (resp.isSuccess()) {
                    sourceId = Long.valueOf(resp.getData());
                } else {
                    logger.error("供方id-{}处理推送单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), resp.getMsg());
                    throw new BusinessException(resp.getMsg());
                }
            } else {
                logger.error("发送请求推送单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncResp.getMsg());
            }
        } catch (Exception e) {
            logger.error("推送单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
            throw new BusinessException(e.getMessage());
        } finally {
            //释放单据锁
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        return sourceId;
    }

    @Override
    public Long saveSyncBill(HttpServletRequest request) {
        logger.info("进入保存接口>>>>>>>>>>>>>>>>>>>>>>>>");
        String authority = request.getHeader("authority");
        String transData = request.getParameter("transData");
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);
        logger.info("接收到数据transData：{}，nameSourceTypeMapping：{}", transData, nameSourceTypeMapping);
        SubFeeApplyVO vo = JSONObject.parseObject(transData, SubFeeApplyVO.class);
        if (vo == null || vo.getId() == null) {
            throw new BusinessException("单据信息为空！");
        }
        // 非生效且非已驳回单据
        QueryParam param = new QueryParam();
        param.getParams().put("sourceId", new Parameter(QueryParam.EQ, vo.getId()));
        param.getParams().put("billState", new Parameter(QueryParam.NOT_IN, "1,3"));
        param.getParams().put("applyType", new Parameter(QueryParam.NE, String.valueOf(PlanConstant.APPLY_TYPE_BACK)));
        List<SubFeeApplyEntity> list = super.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            logger.info("存在相同sourceID的数据，原数据:{}", JSONObject.toJSONString(list));
//            throw new BusinessException("领料出库单已在存在！");
        }

//        List<SubFeeApplyDetailVO> saveList = vo.getDetailList().stream().filter(x->!"del".equals(x.getRowState())).collect(Collectors.toList());
//        if(CollectionUtils.isEmpty(saveList)){
//            throw new BusinessException("处置清单不能为空!");
//        }

        // 校验是否有在申请中单据
        this.validateApplying(vo);
        // 校验本期完工金额
        this.validateApplyMny(vo);

        SubFeeApplyEntity saveEntity = BeanMapper.map(vo, SubFeeApplyEntity.class);
        saveEntity.setSourceId(saveEntity.getId());
        saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        saveEntity.setApplyType(String.valueOf(PlanConstant.APPLY_TYPE_UN_PROJECT));

        //查询审核人信息,讲审核人(合同的录入人)作为单据的创建人
        EmployeeVO craetor = null;
        if(null != saveEntity.getAuditWorkerId()) {
            CommonResponse<EmployeeVO> creatorResp = employeeApi.getById(saveEntity.getAuditWorkerId());
            if(!creatorResp.isSuccess()) {
                logger.error("查询分包费用申请人-{}信息失败,{}", saveEntity.getAuditWorkerId(), JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询费用审核人信息失败!");
            }

            if(null == creatorResp.getData()) {
                logger.error("查询分包费用申请人-{}信息为空,{}", saveEntity.getAuditWorkerId(), JSONObject.toJSONString(creatorResp, SerializerFeature.PrettyFormat));
                throw new BusinessException("操作失败,查询费用审核人信息失败!");
            }
            craetor = creatorResp.getData();
        }
        CommonUtils.clearInvalidData(saveEntity);// 初始化数据
        saveEntity.setCreateUserId(craetor.getId());
        saveEntity.setCreateUserCode(craetor.getCode());

        for(SubFeeApplyDetailEntity detail : saveEntity.getDetailList()){
            detail.setSourceId(detail.getApplyId());
            detail.setSourceDetailId(detail.getId());
            CommonUtils.clearInvalidData(detail);// 初始化数据
            detail.setCreateUserCode(craetor.getCode());
        }

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", saveEntity.getSourceId(), ejcCloudSystemCode.getMsg());
        }
        //设置当前系统ID
        saveEntity.setSystemId(ejcCloudSystemCode.getData());

        //保存单据中附件并获取到上传后附件的Id
        Map<String, List<Long>> attachIdsMap = FileUtil.getInstance()
                .handleReqFile((MultipartHttpServletRequest) request, mp, BILL_TYPE, authority, null);
        List<Long> attchIdsList = new ArrayList<>();
        for (List<Long> attachIds : attachIdsMap.values()) {
            if (CollectionUtils.isNotEmpty(attachIds)) {
                attchIdsList.addAll(attachIds);
            }
        }
        saveEntity.setAttachIds(attchIdsList);

        super.saveOrUpdate(saveEntity, false);
        // 发送邮件
        this.sendEmail(saveEntity);
        logger.info("保存接口结束<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
        return saveEntity.getId();
    }

    /**
     * 发送邮件
     * @param entity
     */
    private void sendEmail(SubFeeApplyEntity entity) {
        if(null == entity.getCompileId()){
            return;
        }
        StringBuilder content = new StringBuilder();
        content.append("【" + entity.getBillCode() + "】，【" + entity.getProjectName() + "】，【");
        content.append(entity.getContractName() + "】，【" + entity.getSupplierName() + "】提交了费用申请，请您审核！");
        StringBuilder subject = new StringBuilder();
        subject.append("【工程量审核】，【" + entity.getBillCode() + "】，【" + DateUtil.formatSeconds(new Date()) + "】需要您审核！");
        String pcUrl = "ejc-zdsmaterial-frontend/#/subCostApply?id=" + entity.getId() + "&userid=" + entity.getCompileId() + "&tenantId=" + entity.getTenantId();
        msgSendUtil.sendEmail(new String[]{String.valueOf(entity.getCompileId())}, "工程量审核", subject.toString(), content.toString(), null, pcUrl);
    }

    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        logger.info("接收到数据parameters：{}", JSONObject.toJSONString(request.getParameterMap()));
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        String applyType = request.getParameter("applyType");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        SubFeeApplyEntity entity = super.selectById(billId);
        //设置项目方签字信息
        entity.setSupOperateTime(supOperateTime);
        entity.setSupOperatorName(supOperatorName);
        entity.setSupOperatorPhone(supOperatorPhone);
        entity.setSupOperatorUserCode(supOperatorUserCode);
        entity.setApplyType(applyType);
        try {
            //对单据进行加锁
            BillLockUtil.getLock(BILL_TYPE, entity.getId());

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, entity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            entity.setAttachIds(attchIdsList);
            //更新单据
            super.saveOrUpdate(entity, false);
//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }
        } catch (Exception e) {
            logger.error("单据id-{}更新状态回写异常，", entity.getId(), e);
            return "单据更新状态回写失败！";
        } finally {
            //释放单据锁
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        return null;
    }

    @Override
    public String updateApplyType(SubFeeApplyVO vo) {
        UserContext user = sessionManager.getUserContext();
        //查询当前用户信息
        logger.info("用户{}对单据id-{}进行更新状态操作！", user.getUserName(), vo.getId());
        SubFeeApplyEntity entity = super.selectById(vo.getId());
        //将当前操作人信息记录在单据中
        entity.setSupOperateTime(new Date());
        entity.setSupOperatorPhone(user.getUserMobile());
        entity.setSupOperatorName(user.getUserName());
        entity.setSupOperatorUserCode(user.getUserCode());
        entity.setApplyType(vo.getApplyType());
        // 分包联系人转为供方系统主键
        Long partyContactsId = null;
        // 已驳回的单据设为自由态
        if(PlanConstant.APPLY_TYPE_BACK.equals(Integer.valueOf(entity.getApplyType()))){
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            if (null != entity.getPartyContactsId()) {
                CommonResponse<LinkerVO> linker = linkerApi.getOneById(entity.getPartyContactsId());
                if (linker.isSuccess() && null != linker.getData()) {
                    partyContactsId = linker.getData().getSupUserId();
                }
            }
        }
        try {
            //对单据进行加锁
            BillLockUtil.getLock(BILL_TYPE, entity.getId());

            Map<String, Map<String, InputStream>> files = new HashMap<>();
            Map<String, String> nameSourceTypeMapping = new HashMap<>();

            // 已报审，将工程量清单签字版发送给供方
            if(PlanConstant.APPLY_TYPE_COMMIT.equals(vo.getApplyType())){
                // 查询当前单据的签字文件
                CommonResponse<List<AttachmentVO>> attachsResp = attachmentApi.queryListBySourceId(vo.getId(), BILL_TYPE, supSignFileSourceType, null);
                if(!attachsResp.isSuccess()) {
                    logger.error("查询id-{}单据类型-{}当前签字文件-{},信息失败， {}", vo.getId(), BILL_TYPE, supSignFileSourceType, attachsResp.getMsg());
                    return "查询签字文件信息失败!";
                }
                if(CollectionUtils.isEmpty(attachsResp.getData())) {
                    logger.info("查询id-{}单据类型-{}当前签字文件-{}为空", vo.getId(), BILL_TYPE, supSignFileSourceType);
                    return "没找到匹配的签字文件";
                }
                AttachmentVO supSignFile = attachsResp.getData().stream().findFirst().orElse(new AttachmentVO());
                //查询用户签字文件流
                Response fileResp = attachmentApi.downloadFileById(supSignFile.getId());
                Map<String, InputStream> signFile = new HashMap<>();
                if(supSignFile.getId() != null){
                    signFile.put(supSignFile.getFileName(), fileResp.body().asInputStream());
                    files.put(supSignFile.getFileName(), signFile);
                    nameSourceTypeMapping.put(supSignFile.getFileName(), supSignFile.getSourceType());
                }
            }

            // 回写参数
            Map<String, String> params = new HashMap<>();
            params.put("nameSourceTypeMapping", JSONObject.toJSONString(nameSourceTypeMapping));
            params.put("billId", String.valueOf(entity.getSourceId()));
            params.put("supOperatorName", entity.getSupOperatorName());
            params.put("supOperatorPhone", entity.getSupOperatorPhone());
            params.put("supOperatorUserCode", entity.getSupOperatorUserCode());
            params.put("supOperateTime", String.valueOf(entity.getSupOperateTime().getTime()));
            params.put("applyType", entity.getApplyType());
            params.put("partyContactsId", CommonUtils.createString(partyContactsId));

            //回写单据签字状态
            logger.info("单据-{}id-{}更新状态，通知单据推送方systemId-{},参数-{}", BILL_NAME, entity.getId(), entity.getSystemId(), JSONObject.toJSONString(params));
            CommonResponse<String> backResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(BILL_WITER_BACK_SERVER_URL, params, entity.getSupplierId().toString(), files);
            logger.error("单据-{}更新状态回写发送请求结果，{}", BILL_NAME, JSONObject.toJSONString(backResp));
            if(!backResp.isSuccess()) {
                logger.error("单据-{}id-{}更新状态回写发送请求失败，{}", BILL_NAME, entity.getId(), backResp.getMsg());
                return BILL_NAME + "更新状态回写发送请求失败";
            }
            if(PlanConstant.noPower.equals(backResp.getData())){
                logger.error("发送请求URL-{}给系统-{}失败, {}", BILL_WITER_BACK_SERVER_URL, entity.getSystemId(), backResp.getData());
                return backResp.getData();
            }
            CommonResponse<String> operateResp = JSONObject.parseObject(backResp.getData(), CommonResponse.class);
            if(!operateResp.isSuccess()) {
                logger.error("单据-{}id-{}更新状态回调处理失败，{}", BILL_NAME, entity.getId(), operateResp.getMsg());
                return "更新状态回调处理失败";
            }

            //更新单据
            super.saveOrUpdate(entity, false);
        } catch (Exception e) {
            logger.error("单据-{}id-{}更新状态异常，", BILL_NAME, entity.getId(), e);
            return "操作失败！";
        } finally {
            BillLockUtil.releaseLock(BILL_TYPE, entity.getId());
        }
        return null;
    }

    @Override
    public Boolean validateApplying(SubFeeApplyVO vo) {
        List<SubContractEntity> contList = contractService.getAllBySourceIds(new ArrayList<>(Arrays.asList(vo.getSourceContractId())));
        Boolean flag = contList.stream().anyMatch(x->PlanConstant.INTEGER_YES.equals(x.getIsApply()));
        if(flag){
            throw new BusinessException("该合同在ERP系统中存在申请中分包费用，不允许再次发起申请!");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        param.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        param.getParams().put("applyType", new Parameter(QueryParam.NOT_IN, "0,4,6"));// 非在申请中状态
        List<SubFeeApplyEntity> list = super.queryList(param);
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> billCodes = list.stream().map(SubFeeApplyEntity::getBillCode).collect(Collectors.toSet());
            throw new BusinessException("该合同在PM系统中存在申请中分包费用单【" + StringUtils.join(billCodes, ",") + "】，不允许再次发起申请!");
        }
        return true;
    }

    @Override
    public Boolean validateApplyMny(SubFeeApplyVO vo) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<SubFeeApplyEntity> list = super.queryList(param);
        BigDecimal lastMny = BigDecimal.ZERO;// 本期前累计申请金额
        if (CollectionUtils.isNotEmpty(list)) {
            lastMny = list.stream().map(x->x.getApplyMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        }
        BigDecimal sumMny = ComputeUtil.safeAdd(lastMny, vo.getApplyMny());
        if(ComputeUtil.isNotEmpty(vo.getSettleSumMoney())){
            if(ComputeUtil.isGreaterThan(sumMny, vo.getSettleSumMoney())){
                throw new BusinessException("截止本期累计申请金额大于累计结算金额，不允许发起申请!");
            }
        } else {
            BigDecimal contMny = ComputeUtil.safeAdd(vo.getContractMoney(), vo.getFuJiaMoney());
            if(ComputeUtil.isGreaterThan(sumMny, contMny)){
                throw new BusinessException("截止本期累计申请金额大于主合同+附加合同金额，不允许发起申请!");
            }
        }
//        BigDecimal sum = ComputeUtil.safeAdd(vo.getCorporateMny(), vo.getMigrantMny());
//        if(ComputeUtil.nullToZero(sum).compareTo(ComputeUtil.nullToZero(vo.getApplyMny())) != 0){
//            throw new BusinessException("对公付款与农民工专户付款的和不等于本期申请金额，不允许发起申请!");
//        }
        return true;
    }

    @Override
    public int pageCount(Map<String, Object> queryParam) {
        return mapper.pageCount(queryParam);
    }

    @Override
    public List<JSONObject> pageList(Map<String, Object> queryParam) {
        return mapper.pageList(queryParam);
    }

    @Override
    public BigDecimal thisYearApplyMny(Long linkerId, String linkerSid, Long supplierId) {
        return mapper.thisYearApplyMny(linkerId, linkerSid, supplierId);
    }

}
