/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.mapper.SubFeeApplyDetailMapper;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyDetailService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="subFeeApplyDetailService")
public class SubFeeApplyDetailServiceImpl
extends BaseServiceImpl<SubFeeApplyDetailMapper, SubFeeApplyDetailEntity>
implements ISubFeeApplyDetailService {
    @Autowired
    private ISubFeeApplyService applyService;

    @Override
    public Map<Long, SubFeeApplyDetailVO> getApproveDetailMap(List<Long> infoIds) {
        if (CollectionUtils.isEmpty(infoIds)) {
            return new HashMap<Long, SubFeeApplyDetailVO>();
        }
        QueryParam param = new QueryParam();
        param.getParams().put("infoId", new Parameter("in", infoIds));
        List list = super.queryList(param);
        List ids = list.stream().map(x -> x.getApplyId()).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(ids)) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter("in", ids));
            queryParam.getParams().put("applyType", new Parameter("eq", (Object)PlanConstant.APPLY_TYPE_APPROVE));
            List applyList = this.applyService.queryList(queryParam);
            List applyIds = applyList.stream().map(x -> x.getId()).distinct().collect(Collectors.toList());
            ids.retainAll(applyIds);
        }
        if (CollectionUtils.isEmpty(list = list.stream().filter(x -> ids.contains(x.getApplyId())).collect(Collectors.toList()))) {
            return new HashMap<Long, SubFeeApplyDetailVO>();
        }
        HashMap<Long, SubFeeApplyDetailVO> map = new HashMap<Long, SubFeeApplyDetailVO>();
        for (SubFeeApplyDetailEntity entity : list) {
            SubFeeApplyDetailVO vo = new SubFeeApplyDetailVO();
            if (map.containsKey(entity.getInfoId())) {
                vo = (SubFeeApplyDetailVO)map.get(entity.getInfoId());
            }
            vo.setInfoId(entity.getInfoId());
            vo.setLastNum(ComputeUtil.safeAdd((BigDecimal)vo.getLastNum(), (BigDecimal)entity.getNum()));
            vo.setLastMny(ComputeUtil.safeAdd((BigDecimal)vo.getLastMny(), (BigDecimal)entity.getMny()));
            vo.setLastTaxMny(ComputeUtil.safeAdd((BigDecimal)vo.getLastTaxMny(), (BigDecimal)entity.getTaxMny()));
            map.put(entity.getInfoId(), vo);
        }
        return map;
    }

    @Override
    public Map<Long, List<SubFeeApplyDetailEntity>> getAllBySettleIds(List<Long> pIds) {
        Map<Long, List<SubFeeApplyDetailEntity>> resp = new HashMap<Long, List<SubFeeApplyDetailEntity>>();
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"apply_id", pIds);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        List dbList = super.list((Wrapper)query);
        if (CollectionUtils.isNotEmpty((Collection)dbList)) {
            resp = dbList.stream().collect(Collectors.groupingBy(SubFeeApplyDetailEntity::getApplyId));
        }
        return resp;
    }
}

