package com.ejianc.business.zdsmaterial.erp.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptDetailEntity;
import com.ejianc.business.zdsmaterial.accept.bean.AcceptEntity;
import com.ejianc.business.zdsmaterial.erp.bean.DeliveryDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.bean.OrderEntity;
import com.ejianc.business.zdsmaterial.erp.mapper.OrderDetailMapper;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.service.IOrderService;
import com.ejianc.business.zdsmaterial.material.vo.OrderQueryVo;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 订单明细
 * 
 * @author generator
 * 
 */
@Service("orderDetailService")
public class OrderDetailServiceImpl extends BaseServiceImpl<OrderDetailMapper, OrderDetailEntity> implements IOrderDetailService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Lazy
    @Autowired
    private IOrderService orderService;
    @Autowired
    private OrderDetailMapper mapper;
    @Override
    public List<OrderDetailEntity> getAllByOrderId(Long id) {
        QueryWrapper<OrderDetailEntity> query = new QueryWrapper<>();
        query.eq("order_id", id);
        return super.list(query);
    }

    @Override
    public Map<Long, BigDecimal> queryHandleAcceptNum(List<Long> ids) {
        QueryWrapper<OrderDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id", ids);
        List<OrderDetailEntity> list = super.list(queryWrapper);
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(OrderDetailEntity::getId, OrderDetailEntity::getHandAcceptNum));
        return collect;
    }

    @Override
    public void returnAcceptedNum(List<DeliveryDetailEntity> list,boolean addFlag){
        Map<Long, BigDecimal> collect = list.stream().collect(Collectors.toMap(DeliveryDetailEntity::getSourceDetailId,
                DeliveryDetailEntity::getCheckNum));
        QueryWrapper<OrderDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id",collect.keySet());
        List<OrderDetailEntity> orderDetailEntities = super.list(queryWrapper);
        for (OrderDetailEntity detail:orderDetailEntities){
            if (collect.containsKey(detail.getId())){
                BigDecimal acceptedNum = detail.getAcceptedNum();
                BigDecimal decimal;
                if (addFlag){
                    decimal = ComputeUtil.safeAdd(acceptedNum, collect.get(detail.getId()));
                }else {
                    decimal = ComputeUtil.safeSub(acceptedNum, collect.get(detail.getId()));
                }
                detail.setAcceptedNum(decimal);
            }
        }
        super.saveOrUpdateBatch(orderDetailEntities);


    }

    @Override
    public void returnDeliveryNum(Map<Long, BigDecimal> returnOrderMap, boolean addFlag) {
        QueryWrapper<OrderDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id",returnOrderMap.keySet());
        List<OrderDetailEntity> orderDetailEntities = super.list(queryWrapper);
        BigDecimal deliveryTaxMny = BigDecimal.ZERO;
        BigDecimal deliveryMny = BigDecimal.ZERO;
        Long orderId = null;
        for (OrderDetailEntity detail:orderDetailEntities){
            if (null==orderId){
                orderId = detail.getOrderId();
            }
            if (returnOrderMap.containsKey(detail.getId())){
                BigDecimal deliveredNum = detail.getDeliveredNum();
                BigDecimal decimal ;
                if (addFlag){
                    decimal = ComputeUtil.safeSub(deliveredNum, returnOrderMap.get(detail.getId()));
                }else {
                    decimal = ComputeUtil.safeAdd(deliveredNum, returnOrderMap.get(detail.getId()));
                }
                BigDecimal taxMny = ComputeUtil.safeMultiply(decimal, detail.getDetailTaxPrice());
                BigDecimal mny = ComputeUtil.safeMultiply(decimal, detail.getDetailPrice());
                deliveryTaxMny = ComputeUtil.safeAdd(deliveryTaxMny,taxMny);
                deliveryMny = ComputeUtil.safeAdd(deliveryMny,mny);
                detail.setDeliveredNum(decimal);
            }
        }
        UpdateWrapper<OrderEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("id",orderId);
        updateWrapper.set("delivered_tax_mny",deliveryTaxMny);
        updateWrapper.set("delivered_mny",deliveryMny);
        orderService.update(updateWrapper);
        super.saveOrUpdateBatch(orderDetailEntities);
    }

    @Override
    public void returnHandAcceptNum(AcceptEntity entity, boolean addFlag){
        Map<Long, List<AcceptDetailEntity>> detailNumMapNew = new HashMap<>();
        for (AcceptDetailEntity detail : entity.getDetailList()) {
            if(!detailNumMapNew.containsKey(detail.getSourceDetailId())) {
                detailNumMapNew.put(detail.getSourceDetailId(), new ArrayList<>());
            }
            detailNumMapNew.get(detail.getSourceDetailId()).add(detail);
        }
        QueryWrapper<OrderDetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.in("id",detailNumMapNew.keySet());
        List<OrderDetailEntity> orderDetailEntities = super.list(queryWrapper);


        for (OrderDetailEntity detail:orderDetailEntities){
            if (detailNumMapNew.containsKey(detail.getId())){
                BigDecimal checkNum = BigDecimal.ZERO;
                for(AcceptDetailEntity accDetail : detailNumMapNew.get(detail.getId())) {
                    if("del".equals(accDetail.getRowState())) {
                        checkNum = ComputeUtil.safeSub(checkNum, accDetail.getCheckNum());
                    } else {
                        checkNum = ComputeUtil.safeAdd(checkNum, accDetail.getCheckNum());
                    }
                }
                BigDecimal handAcceptNum = detail.getHandAcceptNum();
                if (addFlag) {
                    handAcceptNum = ComputeUtil.safeAdd(handAcceptNum, checkNum);
                } else {
                    handAcceptNum = ComputeUtil.safeSub(handAcceptNum, checkNum);
                }
                detail.setHandAcceptNum(handAcceptNum);
            }
        }
        super.saveOrUpdateBatch(orderDetailEntities);
    }

    @Override
    public List<PurchaseAnalysisVo> countNum(Map<String, Object> params) {
        return mapper.countNum(params);
    }

    @Override
    public List<OrderQueryVo> orderList(Map<String, Object> params) {
        return mapper.orderList(params);
    }

    @Override
    public List<Map<String, Object>> getMaterialOrderNums(Long projectId, List<Long> materialIds) {
        return mapper.getMaterialOrderNums(projectId, materialIds);
    }

    @Override
    @Async(value = "maContextCommonTask")
    public void cancelByOrderIds(List<Long> orderIds) {
        //合同子表作废
        UpdateWrapper<OrderDetailEntity> update = new UpdateWrapper<>();
        update.in("order_id", orderIds);
        update.eq("dr", BaseVO.DR_UNDELETE);
        update.set("dr", 1);
        update.set("update_time", new Date());
        super.update(update);
    }

}
