package com.ejianc.business.zdsmaterial.sub.fee.service.impl;

import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.cons.PlanConstant;
import com.ejianc.business.zdsmaterial.cons.enums.BillPushStatusEnum;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorContractDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorSetEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.AuditorUserDetailEntity;
import com.ejianc.business.zdsmaterial.sub.fee.bean.SubFeeApplyEntity;
import com.ejianc.business.zdsmaterial.sub.fee.service.IAuditorSetService;
import com.ejianc.business.zdsmaterial.sub.fee.service.ISubFeeApplyService;
import com.ejianc.business.zdsmaterial.sub.fee.vo.SubFeeApplyVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service("subFeeApply") 
public class SubFeeApplyBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubFeeApplyService service;

	@Autowired
	private SessionManager sessionManager;

	@Autowired
	private IAuditorSetService auditorService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		SubFeeApplyEntity entity = service.selectById(billId);
		SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
		// 校验是否有在申请中单据
		service.validateApplying(vo);
		// 校验本期完工金额
		service.validateApplyMny(vo);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		SubFeeApplyEntity entity = service.selectById(billId);
		if(PlanConstant.SOURCE_TYPE_SUPPLIER.equals(entity.getSourceType())){
			SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
			vo.setApplyType(PlanConstant.APPLY_TYPE_COMMIT.toString());// 已报审
			String msg = service.updateApplyType(vo);
			if(StringUtils.isNotBlank(msg)) {
				return CommonResponse.error(msg);
			}
		} else {
			entity.setApplyType(PlanConstant.APPLY_TYPE_COMMIT.toString());// 已报审
			service.saveOrUpdate(entity);
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SubFeeApplyEntity entity = service.selectById(billId);
		SubFeeApplyVO vo = BeanMapper.map(entity, SubFeeApplyVO.class);
		// 校验是否有在申请中单据
		service.validateApplying(vo);
		// 校验本期完工金额
		service.validateApplyMny(vo);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		SubFeeApplyEntity entity = service.selectById(billId);

		UserContext user = sessionManager.getUserContext();
		entity.setSupOperateTime(new Date());
		entity.setSupOperatorPhone(user.getUserMobile());
		entity.setSupOperatorName(user.getUserName());
		entity.setSupOperatorUserCode(user.getUserCode());
		entity.setApplyType(PlanConstant.APPLY_TYPE_APPROVE.toString());// 审批通过

		Long sourceId = service.pushBillToSupCenter(entity);
		if(sourceId == null){
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}else{
			entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}
		entity.setSourceId(sourceId);
		service.updateById(entity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不允许弃审！");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 审批--获取当前节点的审批人---从服务中选择
	 *
	 * @param billId 单据id
	 * @param billTypeCode 单据类型编码
	 * @param sign 节点标志
	 * @param other	其他参数（为了预防后面添加参数）
	 * @return
	 */
	public CommonResponse<JSONArray> queryApproveUser(Long billId, String billTypeCode, String sign, Map<String, Object> other){
		logger.info("获取当前节点的审批人api开始参数：------billId：" + billId + "，sign:" + sign);
		JSONArray array = new JSONArray();
		SubFeeApplyEntity entity = service.selectById(billId);
		QueryParam param = new QueryParam();
		param.getParams().put("projectId", new Parameter(QueryParam.EQ, entity.getProjectId()));
		List<AuditorSetEntity> list = auditorService.queryList(param);
		if(CollectionUtils.isEmpty(list)) {
			return CommonResponse.success(array);
		}
		AuditorSetEntity auditor = auditorService.selectById(list.get(0).getId());
		List<AuditorContractDetailEntity> contList = auditor.getContractDetailList();
		List<AuditorUserDetailEntity> userList = auditor.getUserDetailList();
		List<Long> userDetailIds = contList.stream().filter(x->x.getContractId().equals(entity.getContractId())).map(x->x.getUserDetailId()).collect(Collectors.toList());
		List<AuditorUserDetailEntity> result = userList.stream().filter(x->userDetailIds.contains(x.getRelationId()) && x.getStationName().equals(sign)).collect(Collectors.toList());

		for(AuditorUserDetailEntity user : result){
			JSONObject obj = new JSONObject();
			obj.put("userId", user.getUserId());
			obj.put("userName", user.getUserName());
			array.add(obj);
		}
		logger.info("获取当前节点的审批人结果：{}", array.toString());
		return CommonResponse.success(array);
	};

}
