package com.ejianc.business.zdsmaterial.erp.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.erp.bean.OrderDetailEntity;
import com.ejianc.business.zdsmaterial.erp.service.IOrderDetailService;
import com.ejianc.business.zdsmaterial.erp.vo.OrderDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2023/12/7 10:10
 */
@RestController
@RequestMapping(value = "/orderDetail/")
public class OrderDetailController {

    @Autowired
    private IOrderDetailService service;

    /**
     * @Description 参照
     * @Return void
     */
    @GetMapping(value = "/orderDetailDataRef")
    public CommonResponse<IPage<OrderDetailVO>> orderDetailDataRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                   String condition,
                                                                   String searchObject,
                                                                   String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialTypeName");
        fuzzyFields.add("detailUnitName");
        fuzzyFields.add("propertyValue");
        fuzzyFields.add("productCode");

        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);

        Map<String, Parameter> params = param.getParams();
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        if(StringUtils.isNotEmpty(condition)){
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("orderId")) {
                params.put("orderId", new Parameter(QueryParam.EQ, _con.getLong("orderId")));
            }
        }
        //查询未验收量量大于零的
        params.put("", new Parameter(QueryParam.SQL, "detail_num > (ifnull(delivered_num,0) + ifnull(hand_accept_num,0))"));
        IPage<OrderDetailEntity> page = service.queryPage(param,false);
        IPage<OrderDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderDetailVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
    }

}
