package com.ejianc.business.zdsmaterial.material.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.bean.PurchaseAnalysisEntity;
import com.ejianc.business.zdsmaterial.material.mapper.PurchaseAnalysisMapper;
import com.ejianc.business.zdsmaterial.material.service.IPurchaseAnalysisService;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author CJ
 * @Description:
 * @date 2024/10/12 16:20
 */
@Service(value = "purchaseAnalysisService")
public class PurchaseAnalysisServiceImpl extends BaseServiceImpl<PurchaseAnalysisMapper, PurchaseAnalysisEntity> implements IPurchaseAnalysisService {

    @Autowired
    private PurchaseAnalysisMapper mapper;

    @Override
    public void reloadMaterialData() {
        mapper.clearTableData();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String todayStr = sdf.format(new Date());
        mapper.createMaterialDataView(todayStr);
    }

    @Override
    public List<PurchaseAnalysisVo> getList(Map<String, Object> params) {
        return mapper.getList(params);
    }

    @Override
    public JSONObject getPurchaseMny(Map<String, Object> params) {
        return mapper.getPurchaseMny(params);
    }
}
