package com.ejianc.business.zdsmaterial.out.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsmaterial.out.bean.DisposeDetailEntity;
import com.ejianc.business.zdsmaterial.out.mapper.DisposeDetailMapper;
import com.ejianc.business.zdsmaterial.out.service.IDisposeDetailService;
import com.ejianc.business.zdsmaterial.out.vo.DisposeDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 处置申请明细表
 * 
 * @author generator
 * 
 */
@Service("disposeDetailService")
public class DisposeDetailServiceImpl extends BaseServiceImpl<DisposeDetailMapper, DisposeDetailEntity> implements IDisposeDetailService{

    @Override
    public List<DisposeDetailVO> getMaterialDetail(QueryWrapper queryWrapper) {
        return baseMapper.getMaterialDetail(queryWrapper);
    }

    @Override
    public List<DisposeDetailVO> getDisposeDetail(String ids, QueryWrapper queryWrapper) {
        return baseMapper.getDisposeDetail(ids, queryWrapper);
    }

    @Override
    public List<DisposeDetailVO> getDisposeDetails(String ids,Long id) {
        return baseMapper.getDisposeDetails(ids,id);
    }

    @Override
    public Map<Long, List<DisposeDetailEntity>> getAllBySettleIds(List<Long> pIds) {
        Map<Long, List<DisposeDetailEntity>> resp = new HashMap<>();
        QueryWrapper<DisposeDetailEntity> query = new QueryWrapper<>();
        query.in("dispose_id", pIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<DisposeDetailEntity> dbList = super.list(query);

        if(CollectionUtils.isNotEmpty(dbList)) {
            resp = dbList.stream().collect(Collectors.groupingBy(DisposeDetailEntity::getDisposeId));
        }

        return resp;
    }

    @Override
    public List<Long> getDispostIdsByCategoryIds(List<Long> childCategoryIds) {
        if(CollectionUtils.isEmpty(childCategoryIds)) {
            return new ArrayList<>();
        }
        QueryWrapper<DisposeDetailEntity> query = new QueryWrapper<>();
        query.select("distinct dispose_id");
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.in("material_type_id", childCategoryIds);

        return super.listObjs(query, item -> Long.valueOf(item.toString()));
    }
}
