package com.ejianc.business.zdsmaterial.plan.control.mapper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.zdsmaterial.material.vo.PurchaseAnalysisVo;
import com.ejianc.business.zdsmaterial.plan.control.bean.ControlPlanSumDetailEntity;
import com.ejianc.business.zdsmaterial.plan.purchase.bean.PurchasePlanDetailEntity;
import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 物资总控计划汇总明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface ControlPlanSumDetailMapper extends BaseCrudMapper<ControlPlanSumDetailEntity> {

    List<PurchasePlanDetailEntity> queryMaterialList(@Param("materialIds") List<Long> materialIds, @Param("projectId")Long projectId);
    List<ControlPlanSumDetailEntity> queryMaterialListBySum(@Param("materialIds") List<Long> materialIds, @Param("projectId")Long projectId);

    List<PurchaseAnalysisVo> getList(Map<String, Object> params);
    long count(Map<String, Object> params);
    List<PurchaseAnalysisVo> countChangeNum(Map<String, Object> params);

    List<JSONObject> querySubByPlanIds(@Param(value = "planIds") List<Long> planIds, @Param(value = "projectIds") List<Long> projectIds);

}
