package com.ejianc.business.zdsmaterial.sub.settle.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.zdsmaterial.cons.enums.ZDSCommonBillTypeEnums;
import com.ejianc.business.zdsmaterial.sub.settle.bean.SubSettleEntity;
import com.ejianc.business.zdsmaterial.sub.settle.service.ISubSettleService;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleFileVO;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleTemplateVO;
import com.ejianc.business.zdsmaterial.sub.settle.vo.SubSettleVO;
import com.ejianc.business.zdssupplier.sub.api.ISubLinkerApi;
import com.ejianc.business.zdssupplier.sub.api.ISubManagerApi;
import com.ejianc.business.zdssupplier.sub.vo.LinkerVO;
import com.ejianc.business.zdssupplier.sub.vo.SupplierManagerVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.http.HttpClientUtils;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.constants.ReferConstant;
import com.ejianc.support.idworker.util.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 分包结算管理
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subSettle")
@Api(value = "分包结算管理", tags = {"分包结算管理"})
public class SubSettleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SUB_SETTLE";//此处需要根据实际修改

    @Autowired
    private ISubSettleService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAttachmentApi attachmentApi;

    private final Long DEFAULT_TMPLE_FILE = 852598949071032396L;

    private final String templateSourceType = "subTemplateFile";

    @Autowired
    private ISubLinkerApi subLinkerApi;

    @Autowired
    private ISubManagerApi subManagerApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private EnvironmentTools environmentTools;


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubSettleVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SubSettleVO saveOrUpdateVO) {

    	if(null == saveOrUpdateVO.getId()) {
            if(CollectionUtils.isNotEmpty(saveOrUpdateVO.getSubSettleTemplateList())) {
                for(SubSettleTemplateVO item : saveOrUpdateVO.getSubSettleTemplateList()) {
                    if(DEFAULT_TMPLE_FILE.equals(item.getAttachmentId())) {
                        if(null == item.getId()) {
                            item.setId(IdWorker.getId());
                        }
                        //文件拷贝
                        CommonResponse<AttachmentVO> attachResp = attachmentApi.copyFile(DEFAULT_TMPLE_FILE.toString(), item.getId().toString(), ZDSCommonBillTypeEnums.SUBSTTLEFILE, templateSourceType, false);
                        if(!attachResp.isSuccess()) {
                            return CommonResponse.error("文件保存失败!");
                        }
                        List<Long> attachIds = new ArrayList<>();
                        attachIds.add(attachResp.getData().getId());
                        item.setAttachIds(attachIds);
                    }
                }
            }
        }

        SubSettleEntity entity = BeanMapper.map(saveOrUpdateVO, SubSettleEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        entity.setCreateUserId(sessionManager.getUserContext().getUserId());
        if(null == entity.getSubLinkId()) {
            return CommonResponse.error("操作失败，乙方联系人信息为空!");
        }

        //若乙方联系人供方用户Id为空，则查询 补充
        if(null != entity.getSubLinkId()) {
            CommonResponse<LinkerVO> linkerResp = subLinkerApi.getOneById(entity.getSubLinkId());
            if(!linkerResp.isSuccess()) {
                logger.error("结算单保存失败，查询乙方联系人id-{}信息失败-{}", entity.getSubLinkId(), JSONObject.toJSONString(linkerResp));
                return CommonResponse.error("操作失败，查询乙方联系人信息失败！");
            }
            if(null == linkerResp.getData()) {
                logger.error("结算单保存失败，查询乙方联系人id-{}信息为空-{}", entity.getSubLinkId(), JSONObject.toJSONString(linkerResp));
                return CommonResponse.error("操作失败，未查询匹配的乙方联系人信息！");
            }
            if(null == linkerResp.getData().getSupUserId()) {
                return CommonResponse.error("操作失败，乙方联系人未开通协同账号，请开通联系人协同账号！");
            }
            entity.setSupSubLinkId(linkerResp.getData().getSupUserId());
        }
        //若乙方项目经理供方用户Id为空，则查询 补充
        if(null != entity.getSubManagerId()) {
            CommonResponse<SupplierManagerVO> mResp = subManagerApi.getById(entity.getSubManagerId().toString());
            if(!mResp.isSuccess()) {
                logger.error("结算单保存失败，查询乙方联系人id-{}信息失败-{}", entity.getSubManagerId(), JSONObject.toJSONString(mResp));
                return CommonResponse.error("操作失败，查询乙方项目经理信息失败！");
            }
            if(null == mResp.getData()) {
                logger.error("结算单保存失败，查询乙方联系人id-{}信息为空-{}", entity.getSubManagerId(), JSONObject.toJSONString(mResp));
                return CommonResponse.error("操作失败，未查询匹配的乙方项目经理信息！");
            }
            if(null == mResp.getData().getSupUserId()) {
                logger.error("结算单：乙方项目经理id-{}未开通协同账号", entity.getSubManagerId());
            } else {
                entity.setSupSubManagerId(mResp.getData().getSupUserId());
            }
        }

    	service.saveOrUpdate(entity, false);
    	SubSettleVO vo = BeanMapper.map(entity, SubSettleVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubSettleVO> queryDetail(@RequestParam Long id) {
    	SubSettleEntity entity = service.selectById(id);
    	SubSettleVO vo = BeanMapper.map(entity, SubSettleVO.class);

        //查询文件
        if(CollectionUtils.isNotEmpty(vo.getSubSettleFileList())) {
            List<Long> fileIds =vo.getSubSettleFileList().stream().filter(item ->null != item.getAttachmentId())
                    .map(item -> item.getAttachmentId()).collect(Collectors.toList());
            Map<Long, AttachmentVO> attachmentVOMap = new HashMap<>();
            if(CollectionUtils.isNotEmpty(fileIds)) {
                CommonResponse<List<AttachmentVO>> attchResp = attachmentApi.queryAllByIds(fileIds);
                if(!attchResp.isSuccess()) {
                    return CommonResponse.error("获取附件信息失败");
                }
                for(AttachmentVO item : attchResp.getData()) {
                    attachmentVOMap.put(item.getId(), item);
                }
            }
            for(SubSettleFileVO file : vo.getSubSettleFileList()) {
                if(!attachmentVOMap.containsKey(file.getAttachmentId())) {
                    file.setAttachmentId(null);
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    private void initContext(Long userId) {
        String initContextUrl = environmentTools.getBaseHost() + "ejc-idm-web/user/context/getBytenantid?tenantId=999999";
        initContextUrl = initContextUrl + "&userId="+userId.toString();
        String responseStr = HttpClientUtils.getInstance().getSync(initContextUrl);

        CommonResponse<JSONObject> userContextResponse = JSON.parseObject(responseStr, CommonResponse.class);
        try {
            if(userContextResponse.isSuccess()) {
                JSONObject userContext =userContextResponse.getData().getJSONObject("userContext");
                StringBuilder authtoken = new StringBuilder();
                if(null != userContext) {
                    authtoken.append("userType=").append(userContext.get("userType"))
                            .append(";userCode=").append(userContext.get("userCode"))
                            .append(";orgId=").append(userContext.get("orgId"))
                            .append(";tenantid=").append(userContext.get("tenantid"))
                            .append(";token=").append(userContext.get("token"))
                            .append(";u_logints=").append(userContext.get("u_logints"))
                            .append(";u_usercode=").append(userContext.get("u_usercode"))
                            .append(";userId=").append(userContext.get("userId"));
                }
                if(authtoken.length() > 0) {
                    InvocationInfoProxy.setExtendAttribute("authority", authtoken.toString());
                    InvocationInfoProxy.setParameter(ReferConstant.HEAD_authority, authtoken.toString());
                }
                if(null != userContext) {
                    InvocationInfoProxy.setTenantid(userContext.getLong("tenantid"));
                    InvocationInfoProxy.setUserid(userContext.getLong("userId"));
                    InvocationInfoProxy.setUsercode(userContext.getString("userCode"));
                    InvocationInfoProxy.setOrgId(userContext.getLong("orgId"));
                }
            }
        } catch (Exception e) {
            logger.error("初始化异步任务上下文异常：",e);
        }

    }

    @ApiOperation("查询详情")
    @RequestMapping(value = "/noAuthDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubSettleVO> noAuthDetail(@RequestParam Long id) {
        SubSettleEntity entity = service.selectById(id);
        SubSettleVO vo = BeanMapper.map(entity, SubSettleVO.class);

        //查询人员信息
        initContext(vo.getMatWorkerId());
        CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(vo.getMatWorkerId());
        if (!userByUserId.isSuccess()){
            logger.info("查询采购工程师网络信息异常",userByUserId.getMsg());
            throw new BusinessException("查询采购工程师信息失败!");
        }

        vo.setMatWorkerCode(userByUserId.getData().getUserCode());

        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("审核通过/驳回接口")
    @RequestMapping(value = "/updateApproveStatus", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubSettleVO> updateApproveStatus(@RequestParam Long id,@RequestParam Integer fillStatus,@RequestParam(required = false) String rejectCause) {
        String s = service.updateApproveStatus(id,fillStatus,rejectCause);
        return CommonResponse.success(s);
    }
    /**
     * 供方提交接收附件接口
     * @param request
     * @return
     */
    @PostMapping(value = "subSettleCommitSyncBill")
    public CommonResponse<String> subSettleCommitSyncBill(HttpServletRequest request) {
        return service.subSettleCommitSyncBill(request);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubSettleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (SubSettleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(SubSettleVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubSettleVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagementName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("subLinkName");
        fuzzyFields.add("priceType");
        fuzzyFields.add("specialtyType");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SubSettleEntity> page = service.queryPage(param,false);
        IPage<SubSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubSettleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectManagementName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subContractCode");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("subLinkName");
        fuzzyFields.add("priceType");
        fuzzyFields.add("specialtyType");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }

        List<SubSettleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<SubSettleVO> subSettleVOList = BeanMapper.mapList(list, SubSettleVO.class);
        for (SubSettleVO subSettleVO : subSettleVOList) {

            if (subSettleVO.getFillStatus() == 1){
//                填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
                subSettleVO.setFillStatusName("待分包上传资料");
            }
            if (subSettleVO.getFillStatus() == 2){
//                填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
                subSettleVO.setFillStatusName("已上传资料");
            }
            if (subSettleVO.getFillStatus() == 3){
//                填报状态,1-待分包上传资料,2-已上传资料,3-审核通过
                subSettleVO.setFillStatusName("审核通过");
            }
        }
        beans.put("records", subSettleVOList);
        ExcelExport.getInstance().export("SubSettle-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refSubSettleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubSettleVO>> refSubSettleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubSettleEntity> page = service.queryPage(param,false);
        IPage<SubSettleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubSettleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
