/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.handler;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.bean.FlowEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.service.handler.IStoreManageHandler;
import com.ejianc.business.zdsstore.util.StoreLockUtil;
import com.ejianc.business.zdsstore.util.StoreManageUtil;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.business.zdsstore.vo.SurplusUpdateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TurnInStoreHandler
implements IStoreManageHandler {
    @Autowired
    IFlowService flowService;
    @Autowired
    ISurplusService surplusService;
    @Autowired
    IStoreService storeService;

    @Override
    public CommonResponse<StoreManageVO> handle(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        InOutTypeEnum inOutTypeEnum = storeManageVO.getInOutTypeEnum();
        List flowVOList = storeManageVO.getFlowVOList();
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)false);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        try {
            flowVOList.forEach(flowVO -> {
                flowVO.setOutNum(BigDecimal.ZERO);
                flowVO.setOutLockNum(BigDecimal.ZERO);
                flowVO.setSurplusNum(flowVO.getNum());
                flowVO.setNetMny(flowVO.getMny());
                flowVO.setNetTaxMny(flowVO.getTaxMny());
                flowVO.setShareMny(BigDecimal.ZERO);
                flowVO.setShareTaxMny(BigDecimal.ZERO);
                flowVO.setOutNetMny(BigDecimal.ZERO);
                flowVO.setOutNetTaxMny(BigDecimal.ZERO);
                if (InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93.equals((Object)inOutTypeEnum)) {
                    flowVO.setPurchasePrice(flowVO.getPrice());
                    flowVO.setPurchaseTaxPrice(flowVO.getTaxPrice());
                    flowVO.setEstimatePrice(flowVO.getPrice());
                    flowVO.setEstimateTaxPrice(flowVO.getTaxPrice());
                }
            });
            List flowEntities = BeanMapper.mapList((Iterable)flowVOList, FlowEntity.class);
            boolean b = this.flowService.saveOrUpdateBatch(flowEntities);
            if (b) {
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.success((Object)storeManageVO);
    }

    @Override
    public CommonResponse<StoreManageVO> handleRollback(StoreManageVO storeManageVO) {
        Long storeId = storeManageVO.getStoreId();
        Long sourceId = storeManageVO.getSourceId();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"source_id", (Object)sourceId);
        queryWrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
        List instoreList = this.flowService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)instoreList)) {
            return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u5165\u5e93\u5355\u6d41\u6c34\u4fe1\u606f\uff01");
        }
        List flowVOList = BeanMapper.mapList((Iterable)instoreList, FlowVO.class);
        SurplusUpdateVO surplusUpdateVO = StoreManageUtil.getSurplusUpdateVO((Long)storeId, (List)flowVOList, (boolean)true);
        Boolean lock = StoreLockUtil.getLock((Long)storeId);
        if (!lock.booleanValue()) {
            throw new BusinessException("\u83b7\u53d6\u4ed3\u5e93\u9501\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        CommonResponse<JSONObject> res = null;
        try {
            res = this.flowService.validateTurnIsUseOutFlag(sourceId, storeId);
            if (res.isSuccess()) {
                SurplusUpdateVO surplusUpdateVORet = this.surplusService.updateStoreSurplus(surplusUpdateVO, true, true);
                storeManageVO.setSurplusVOList(surplusUpdateVORet.getSurplusVOList());
                List delListIds = flowVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                this.flowService.removeByIds(delListIds);
                CommonResponse commonResponse = CommonResponse.success((Object)storeManageVO);
                return commonResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\uff01");
        }
        finally {
            if (lock.booleanValue()) {
                StoreLockUtil.releaseLock((Long)storeId);
            }
        }
        return CommonResponse.error((String)res.getMsg());
    }
}

