/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zdsstore.bean.AllotInDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotInEntity;
import com.ejianc.business.zdsstore.bean.AllotOutDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.NoticeEnum;
import com.ejianc.business.zdsstore.service.AllotInMessageService;
import com.ejianc.business.zdsstore.service.IAllotInService;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotInVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="allotOut")
public class AllotOutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAllotOutService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IAllotInService allotInService;
    @Autowired
    private AllotInMessageService allotInMessageService;
    private static final String BILL_CODE = "ALLOT_IN";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    StoreManageService storeManageService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        block7: {
            Jedis jedis = this.jedisPool.getResource();
            boolean locked = false;
            locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn", (int)1000);
            this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
            try {
                if (locked) {
                    break block7;
                }
                CommonResponse commonResponse = CommonResponse.success((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                return commonResponse;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locked) {
                    RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(billId), (String)"generateAllotIn");
                }
                jedis.close();
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        AllotOutEntity entity;
        List<AllotOutDetailEntity> allotOutDetailList;
        AllotOutEntity allotOutEntity = (AllotOutEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) {
            List<AllotOutDetailEntity> allotOutDetailList2 = allotOutEntity.getAllotOutDetailList();
            for (AllotOutDetailEntity a : allotOutDetailList2) {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setStoreId(a.getDetailStoreId());
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u8c03\u62e8\u51fa\u5e93);
                storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
                storeManageVO.setSourceId(allotOutEntity.getId());
                this.logger.debug("\u8c03\u62e8\u51fa\u5e93 afterApprovalProcessor \u8c03\u7528\u5e93\u5b58 inOutStore \u53c2\u6570\uff1a\u2014\u2014\u2014\u2014" + JSONObject.toJSONString((Object)storeManageVO));
                this.storeManageService.inOutStore(storeManageVO);
            }
        }
        if (!Objects.isNull((Object)allotOutEntity)) {
            AllotInEntity allot;
            if (allotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))) {
                LambdaUpdateWrapper allotOutWrapper = new LambdaUpdateWrapper();
                allotOutWrapper.eq(BaseEntity::getId, (Object)billId);
                allotOutWrapper.set(AllotOutEntity::getReceiveState, (Object)Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
                allotOutWrapper.set(AllotOutEntity::getReturnReason, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPersonId, null);
                allotOutWrapper.set(AllotOutEntity::getReceiverPerson, null);
                this.service.update((Wrapper)allotOutWrapper);
            }
            AllotInEntity allotInEntity = new AllotInEntity();
            allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
            Integer allocatType = allotOutEntity.getAllocatType();
            Integer allocatOutType = allotOutEntity.getAllocatOutType();
            if (allocatOutType == 1) {
                allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
                allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
                allotInEntity.setOutProjectCode(allotOutEntity.getProjectCode());
            } else {
                allotInEntity.setOutStoreOrgId(allotOutEntity.getOutStoreOrgId());
                allotInEntity.setOutStoreOrgName(allotOutEntity.getOutStoreOrgName());
                allotInEntity.setOutStoreOrgCode(allotOutEntity.getOutStoreOrgCode());
            }
            allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
            allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
            allotInEntity.setAllocatInType(allotOutEntity.getAllocatOutType());
            allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
            allotInEntity.setProjectId(allotOutEntity.getInProjectId());
            allotInEntity.setProjectName(allotOutEntity.getInProjectName());
            allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
            allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
            allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
            allotInEntity.setOrgId(allotOutEntity.getInOrgId());
            allotInEntity.setOrgCode(allotOutEntity.getInOrgCode());
            allotInEntity.setOrgName(allotOutEntity.getInOrgName());
            allotInEntity.setAllotOutId(allotOutEntity.getId());
            allotInEntity.setOutMny(allotOutEntity.getOutMny());
            allotInEntity.setOutDate(allotOutEntity.getOutDate());
            allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
            allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
            allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
            allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
            allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
            allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
            allotInEntity.setMemo(allotOutEntity.getMemo());
            allotInEntity.setCompanyName(allotOutEntity.getCompanyName());
            allotInEntity.setInCompanyName(allotOutEntity.getInCompanyName());
            allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
            allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
            long id = IdWorker.getId();
            if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())) {
                List allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
                allotInDetailEntitys.forEach(item -> {
                    item.setId(null);
                    item.setAllocatId(id);
                    item.setDetailStoreId(null);
                    item.setDetailStoreName(null);
                });
                allotInEntity.setAllotInDetailList(allotInDetailEntitys);
                this.logger.info("\u5b50\u8868\u4fe1\u606f\uff1a" + allotInDetailEntitys.toString());
            }
            AllotInVO vo = (AllotInVO)BeanMapper.map((Object)((Object)allotInEntity), AllotInVO.class);
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)vo);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            allotInEntity.setBillCode((String)billCode.getData());
            allotInEntity.setId(id);
            boolean b = this.allotInService.saveOrUpdate((Object)allotInEntity, false);
            if (b && (allot = (AllotInEntity)((Object)this.allotInService.selectById(Long.valueOf(id)))) != null && allot.getNotifyReceiverId() != null) {
                String[] notifyReceive = new String[]{String.valueOf(allot.getNotifyReceiverId())};
                this.allotInMessageService.sendMsg(allot, notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
            }
        }
        if (CollectionUtils.isNotEmpty(allotOutDetailList = (entity = (AllotOutEntity)((Object)this.service.selectById(billId))).getAllotOutDetailList())) {
            BigDecimal sumAllotDiffMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffMny()).map(AllotOutDetailEntity::getAllotDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumAllotDiffTaxMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffTaxMny()).map(AllotOutDetailEntity::getAllotDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
            updateWrapper.set(AllotOutEntity::getSumAllotDiffMny, (Object)sumAllotDiffMny);
            updateWrapper.set(AllotOutEntity::getSumAllotDiffTaxMny, (Object)sumAllotDiffTaxMny);
            this.service.update((Wrapper)updateWrapper);
            this.logger.info("sumAllotDiffMny---" + sumAllotDiffMny);
            this.logger.info("sumAllotDiffTaxMny---" + sumAllotDiffTaxMny);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u8be5\u5355\u636e\u4e0d\u652f\u6301\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

