package com.ejianc.business.zdsstore.controller.api;

import com.ejianc.business.zdsstore.bean.StoreEntity;
import com.ejianc.business.zdsstore.service.IStoreService;
import com.ejianc.business.zdsstore.vo.StoreVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/api/store/")
@Api(value = "仓库API接口", tags = {"仓库API接口"})
public class StoreApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStoreService service;

    @ApiOperation("查询对应类型的仓库")
    @RequestMapping(value = "/queryStoreByProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<StoreVO> queryStoreByProject(@RequestParam Long projectId, @RequestParam Integer attrFlag){
        StoreEntity storeEntity = service.autoByProjectId(projectId,attrFlag);
        return CommonResponse.success("查询成功",BeanMapper.map(storeEntity,StoreVO.class));
    }

    @ApiOperation("查询最近云仓及本下云仓")
    @RequestMapping(value = "/queryCloudStoreByOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<StoreVO>> queryCloudStoreByOrg(@RequestParam Long orgId){
        return CommonResponse.success("查询成功", service.queryCloudStoreByOrg(orgId));
    }

}
