package com.ejianc.business.zdsstore.service.impl;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.zdsstore.bean.AllotInDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotInEntity;
import com.ejianc.business.zdsstore.bean.AllotOutDetailEntity;
import com.ejianc.business.zdsstore.bean.AllotOutEntity;
import com.ejianc.business.zdsstore.consts.AllocationState;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.NoticeEnum;
import com.ejianc.business.zdsstore.service.AllotInMessageService;
import com.ejianc.business.zdsstore.service.IAllotInService;
import com.ejianc.business.zdsstore.service.IAllotOutService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.AllotInVO;
import com.ejianc.business.zdsstore.vo.AllotOutVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

@Service("allotOut") 
public class AllotOutBpmServiceImpl implements ICommonBusinessService {


	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IAllotOutService service;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IAllotInService allotInService;
	@Autowired
	private AllotInMessageService allotInMessageService;
	private static final String BILL_CODE = "ALLOT_IN";//此处需要根据实际修改
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private JedisPool jedisPool;
	@Autowired
	StoreManageService storeManageService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//加锁防止生成多个调拨入库 提交前进行
		Jedis jedis = jedisPool.getResource();
		boolean locked = false;
		locked = RedisTool.tryLock(jedis, String.valueOf(billId), "generateAllotIn", 1000);
		logger.info("判断单据单据锁结果------"+locked);
		try{
			if (locked){

			}
			else{
				return CommonResponse.success("出现并发操作,请稍后重试！");
			}
		}catch (Exception e){
			e.printStackTrace();
		} finally {
			if(locked) {
				RedisTool.releaseLock(jedis, String.valueOf(billId), "generateAllotIn");
			}
			jedis.close();
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.error("该单据不支持弃审和撤回");
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
				//更新流水
				AllotOutEntity allotOutEntity = service.selectById(billId);
				if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
					List<AllotOutDetailEntity> allotOutDetailList = allotOutEntity.getAllotOutDetailList();
					for (AllotOutDetailEntity a :allotOutDetailList){
						StoreManageVO storeManageVO = new StoreManageVO();
						storeManageVO.setStoreId(a.getDetailStoreId());
						storeManageVO.setInOutTypeEnum(InOutTypeEnum.调拨出库);
						storeManageVO.setOutEffectiveON(true);
						storeManageVO.setSourceId(a.getId());
						logger.debug("调拨出库 afterApprovalProcessor 调用库存 inOutStore 参数：————"+ JSONObject.toJSONString(storeManageVO));
						storeManageService.inOutStore(storeManageVO);
					}
				}
				if (!Objects.isNull(allotOutEntity)){
					//再次提交 收料状态设置带收清空退回原因
					if (allotOutEntity.getReceiveState().equals(Integer.parseInt(AllocationState.REJECT.getCode()))){
						LambdaUpdateWrapper<AllotOutEntity> allotOutWrapper = new LambdaUpdateWrapper<>();
						allotOutWrapper.eq(AllotOutEntity::getId, billId);
						allotOutWrapper.set(AllotOutEntity::getReceiveState, Integer.parseInt(AllocationState.TO_RECEIVING.getCode()));
						allotOutWrapper.set(AllotOutEntity::getReturnReason,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPersonId,null);
						allotOutWrapper.set(AllotOutEntity::getReceiverPerson,null);
						service.update(allotOutWrapper);
					}
					//生成调拨入库
					AllotInEntity allotInEntity = new AllotInEntity();
					allotInEntity.setAllocatType(allotOutEntity.getAllocatType());
					//区分大区 和项目

					Integer allocatType = allotOutEntity.getAllocatType();
					Integer allocatOutType = allotOutEntity.getAllocatOutType();
					if (allocatOutType==1){
						allotInEntity.setOutProjectId(allotOutEntity.getProjectId());
						allotInEntity.setOutProjectName(allotOutEntity.getProjectName());
						allotInEntity.setOutProjectCode(allotOutEntity.getProjectCode());
					}else {
						allotInEntity.setOutStoreOrgId(allotOutEntity.getOutStoreOrgId());
						allotInEntity.setOutStoreOrgName(allotOutEntity.getOutStoreOrgName());
						allotInEntity.setOutStoreOrgCode(allotOutEntity.getOutStoreOrgCode());
					}

					allotInEntity.setOutOrgId(allotOutEntity.getOrgId());
					allotInEntity.setOutOrgName(allotOutEntity.getOrgName());
					//入库信息
					allotInEntity.setAllocatInType(allotOutEntity.getAllocatOutType());
					allotInEntity.setOutTaxMny(allotOutEntity.getOutTaxMny());
					allotInEntity.setProjectId(allotOutEntity.getInProjectId());
					allotInEntity.setProjectName(allotOutEntity.getInProjectName());
					allotInEntity.setParentOrgId(allotOutEntity.getInParentOrgId());
					allotInEntity.setParentOrgName(allotOutEntity.getInParentOrgName());
					allotInEntity.setParentOrgCode(allotOutEntity.getInParentOrgCode());
					allotInEntity.setOrgId(allotOutEntity.getInOrgId());
					allotInEntity.setOrgCode(allotOutEntity.getInOrgCode());
					allotInEntity.setOrgName(allotOutEntity.getInOrgName());
					allotInEntity.setAllotOutId(allotOutEntity.getId());
					allotInEntity.setOutMny(allotOutEntity.getOutMny());
					allotInEntity.setOutDate(allotOutEntity.getOutDate());
					allotInEntity.setEmployeeId(allotOutEntity.getEmployeeId());
					allotInEntity.setEmployeeName(allotOutEntity.getEmployeeName());
					allotInEntity.setDepartmentId(allotOutEntity.getDepartmentId());
					allotInEntity.setDepartmentName(allotOutEntity.getDepartmentName());
					allotInEntity.setNotifyReceiverId(allotOutEntity.getReceiverId());
					allotInEntity.setReceiverName(allotOutEntity.getReceiverName());
					allotInEntity.setMemo(allotOutEntity.getMemo());
					allotInEntity.setCompanyName(allotOutEntity.getCompanyName());
					allotInEntity.setInCompanyName(allotOutEntity.getInCompanyName());
					allotInEntity.setMaterialNames(allotOutEntity.getMaterialNames());
					allotInEntity.setReceiveState(Integer.valueOf(AllocationState.TO_RECEIVING.getCode()));
					long id = IdWorker.getId();
					if (CollectionUtils.isNotEmpty(allotOutEntity.getAllotOutDetailList())){
						List<AllotInDetailEntity> allotInDetailEntitys = BeanMapper.mapList(allotOutEntity.getAllotOutDetailList(), AllotInDetailEntity.class);
						allotInDetailEntitys.forEach(item->{
							item.setId(null);
							item.setAllocatId(id);
							item.setDetailStoreId(null);
							item.setDetailStoreName(null);
						});
						allotInEntity.setAllotInDetailList(allotInDetailEntitys);
						logger.info("子表信息："+allotInDetailEntitys.toString());
					}
					AllotInVO vo = BeanMapper.map(allotInEntity, AllotInVO.class);
					BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						allotInEntity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
					}else{
						throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
					}
					allotInEntity.setId(id);
					boolean b = allotInService.saveOrUpdate(allotInEntity,false);
					if (b){
						AllotInEntity allot = allotInService.selectById(id);
						if ((allot!=null) && (allot.getNotifyReceiverId()!=null)){
							//通知收料人收料
							String[] notifyReceive = {String.valueOf(allot.getNotifyReceiverId())};
							allotInMessageService.sendMsg(allot,notifyReceive, NoticeEnum.ALLOTIN_ENROLL);
						}
					}
				}
		AllotOutEntity entity = service.selectById(billId);
		List<AllotOutDetailEntity> allotOutDetailList = entity.getAllotOutDetailList();
		if (CollectionUtils.isNotEmpty(allotOutDetailList)){
			BigDecimal sumAllotDiffMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffMny()).map(AllotOutDetailEntity::getAllotDiffMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			BigDecimal sumAllotDiffTaxMny = allotOutDetailList.stream().filter(item -> null != item.getAllotDiffTaxMny()).map(AllotOutDetailEntity::getAllotDiffTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
			LambdaUpdateWrapper<AllotOutEntity> updateWrapper = new LambdaUpdateWrapper<>();
			updateWrapper.in(AllotOutEntity::getId, entity.getId());
			updateWrapper.set(AllotOutEntity::getSumAllotDiffMny, sumAllotDiffMny);
			updateWrapper.set(AllotOutEntity::getSumAllotDiffTaxMny, sumAllotDiffTaxMny);
			service.update(updateWrapper);
			logger.info("sumAllotDiffMny---"+sumAllotDiffMny);
			logger.info("sumAllotDiffTaxMny---"+sumAllotDiffTaxMny);
		}
		return CommonResponse.success();
	}


	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.error("该单据不支持弃审和撤回");
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
