/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.controller.api;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.business.zdsstore.service.IFlowService;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.service.ISurplusService;
import com.ejianc.business.zdsstore.vo.FlowVO;
import com.ejianc.business.zdsstore.vo.InOutVO;
import com.ejianc.business.zdsstore.vo.SurplusVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/storeFlow/"})
@Api(value="\u4ed3\u5e93\u6d41\u6c34\u516c\u5171API\u63a5\u53e3", tags={"\u4ed3\u5e93\u6d41\u6c34\u516c\u5171API\u63a5\u53e3"})
public class StoreFlowApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    IFlowService flowService;
    @Autowired
    private IInOutService inOutService;
    @Autowired
    private ISurplusService surplusService;

    @ApiOperation(value="\u67e5\u8be2\u6d41\u6c34")
    @RequestMapping(value={"/getFlowList"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<List<FlowVO>> getFlowList(@RequestBody QueryParam queryParam) {
        List flowEntityList = this.flowService.queryList(queryParam);
        List flowVOS = BeanMapper.mapList((Iterable)flowEntityList, FlowVO.class);
        return CommonResponse.success((Object)flowVOS);
    }

    @RequestMapping(value={"/getInOutVOList"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<List<InOutVO>> getInOutVOList(@RequestBody QueryParam queryParam) {
        List inOutEntities = this.inOutService.queryList(queryParam);
        List inOutVOS = BeanMapper.mapList((Iterable)inOutEntities, InOutVO.class);
        return CommonResponse.success((Object)inOutVOS);
    }

    @RequestMapping(value={"/getNewPrice"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<List<FlowVO>> getNewPrice(@RequestBody List<FlowVO> flowVOS) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (FlowVO flowVO : flowVOS) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"store_id", (Object)flowVO.getStoreId());
            wrapper.eq((Object)"material_id", (Object)flowVO.getMaterialId());
            wrapper.eq((Object)"brand_id", (Object)flowVO.getBrandId());
            wrapper.eq((Object)"in_out_flag", (Object)StoreCommonConsts.IN_OUT_TYPE_IN);
            wrapper.orderByDesc((Object)"source_bill_date");
            wrapper.last("limit 0,1");
            List flowEntities = this.flowService.list((Wrapper)wrapper);
            if (!CollectionUtils.isNotEmpty((Collection)flowEntities)) continue;
            result.add(BeanMapper.map(flowEntities.get(0), FlowVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6700\u65b0\u5355\u4ef7\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/getNewSurplusNum"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<List<SurplusVO>> getNewSurplusNum(@RequestBody List<SurplusVO> surplusVOS) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.and(q -> {
            for (SurplusVO f : surplusVOS) {
                q.or(iq -> (QueryWrapper)((QueryWrapper)((QueryWrapper)iq.eq((Object)"store_id", (Object)f.getStoreId())).eq((Object)"brand_id", (Object)f.getBrandId())).eq((Object)"material_id", (Object)f.getMaterialId()));
            }
            return q;
        });
        List list = this.surplusService.list((Wrapper)queryWrapper);
        List result = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = BeanMapper.mapList((Iterable)list, SurplusVO.class);
            for (SurplusVO surplusVO : result) {
                surplusVO.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusVO.getSurplusTaxMny(), (BigDecimal)surplusVO.getSurplusNum()));
                surplusVO.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusVO.getSurplusMny(), (BigDecimal)surplusVO.getSurplusNum()));
                surplusVO.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusVO.getSurplusNum(), (BigDecimal)surplusVO.getIdleNum()));
            }
        }
        return CommonResponse.success((String)"\u6279\u91cf\u83b7\u53d6\u6700\u65b0\u7684\u5e93\u5b58\u4f59\u91cf\u6210\u529f\uff01", result);
    }

    @RequestMapping(value={"/refSurplusData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<SurplusVO>> refSurplusData(@RequestParam(value="storeId") Long storeId) {
        QueryParam param = new QueryParam();
        param.getParams().put("storeId", new Parameter("eq", (Object)storeId));
        param.getParams().put("surplusNum", new Parameter("sql", (Object)"(IFNULL(surplus_num,0)-IFNULL(idle_num,0))>0"));
        param.getOrderMap().clear();
        param.getOrderMap().put("abs(ifnull(surplus_num,0)-ifnull(idle_num,0))", "desc");
        List list = this.surplusService.queryList(param, false);
        List surplusVOS = BeanMapper.mapList((Iterable)list, SurplusVO.class);
        surplusVOS.forEach(t -> {
            t.setSurplusHasOutLockNum(ComputeUtil.safeAdd((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getOutLockNum()));
            t.setSurplusMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusMny(), (BigDecimal)t.getOutLockMny()));
            t.setSurplusTaxMny(ComputeUtil.safeAdd((BigDecimal)t.getSurplusTaxMny(), (BigDecimal)t.getOutLockTaxMny()));
            t.setSurplusNum(ComputeUtil.safeSub((BigDecimal)t.getSurplusNum(), (BigDecimal)t.getIdleNum()));
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)surplusVOS);
    }
}

