/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zdsstore.service.impl;

import com.ejianc.business.zdsstore.bean.PickReturnEntity;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.enums.ProsubSignStatusEnum;
import com.ejianc.business.zdsstore.service.ICheckService;
import com.ejianc.business.zdsstore.service.IPickReturnService;
import com.ejianc.business.zdsstore.service.StoreManageService;
import com.ejianc.business.zdsstore.vo.PickReturnDetailVO;
import com.ejianc.business.zdsstore.vo.PickReturnVO;
import com.ejianc.business.zdsstore.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="pickReturn")
public class PickReturnBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPickReturnService pickReturnService;
    @Autowired
    private StoreManageService storeManageService;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IBillTypeApi billTypeApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
        if (pickReturnVO != null && pickReturnVO.getPickReturnDetailList().size() > 0) {
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                List detailVOS = (List)detailMap.get(storeId);
                pickReturnVO.setPickReturnDetailList(detailVOS);
                StoreManageVO storeManageVO = pickReturnVO.getStoreManageVO(pickReturnVO, storeId);
                this.storeManageService.inOutStore(storeManageVO);
            });
        }
        this.logger.info("\u63a8\u9001\u4f9b\u65b9---");
        if (entity.getPickType() == 1) {
            String s = this.pickReturnService.pushPickReturnBill(entity);
            if (StringUtils.isNotBlank((CharSequence)s)) {
                throw new BusinessException(s);
            }
            entity.setConfirmStatus(ProsubSignStatusEnum.\u5df2\u786e\u8ba4.getCode());
            this.pickReturnService.saveOrUpdate((Object)entity);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        String msg;
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        if (entity.getSourceType() != null && ProsubSignStatusEnum.\u4f9b\u65b9\u7533\u8bf7.getCode().equals(entity.getSourceType())) {
            return CommonResponse.error((String)"\u6765\u6e90\u4f9b\u65b9\u7533\u8bf7\u7684\u5355\u636e,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de\uff01");
        }
        this.logger.info("\u9000\u5e93\u5f03\u5ba1\u6821\u9a8c------------------------------\u5355\u636e\u7c7b\u578b:" + billTypeCode);
        CommonResponse commonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + commonResponse.isSuccess() + "----" + commonResponse.getMsg());
        boolean success = commonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u5f52\u96c6\u5355\u4f7f\u7528,\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de\uff01");
        }
        if (entity != null && ProsubSignStatusEnum.\u5df2\u7b7e\u5b57.getCode().equals(entity.getSignStatus())) {
            return CommonResponse.error((String)"\u4f9b\u65b9\u5df2\u7b7e\u5b57\u7684\u9000\u5e93\u5355\u65e0\u6cd5\u64a4\u56de\uff01");
        }
        if (entity.getPickType() == 1 && StringUtils.isNotBlank((CharSequence)(msg = this.pickReturnService.deletePickReturnBill(entity)))) {
            return CommonResponse.error((String)msg);
        }
        if (entity != null) {
            commonResponse = this.checkService.checkByDate(entity.getStoreId(), DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)entity.getInstoreDate()));
            return commonResponse;
        }
        return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u4ed3\u5e93\u76d8\u70b9,\u4f7f\u7528\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        String s;
        PickReturnEntity entity = (PickReturnEntity)((Object)this.pickReturnService.selectById(billId));
        if (entity != null && entity.getPickReturnDetailList().size() > 0) {
            PickReturnVO pickReturnVO = (PickReturnVO)BeanMapper.map((Object)((Object)entity), PickReturnVO.class);
            Map<Long, List<PickReturnDetailVO>> detailMap = pickReturnVO.getPickReturnDetailList().stream().collect(Collectors.groupingBy(PickReturnDetailVO::getStoreId));
            detailMap.forEach((storeId, value) -> {
                StoreManageVO storeManageVO = new StoreManageVO();
                storeManageVO.setSourceId(entity.getId());
                storeManageVO.setStoreId(storeId);
                storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u9886\u6599\u9000\u5e93);
                this.storeManageService.inOutStoreRollback(storeManageVO);
            });
        }
        if (StringUtils.isNotBlank((CharSequence)(s = this.pickReturnService.deletePickReturnBill(entity)))) {
            throw new BusinessException(s);
        }
        return CommonResponse.success();
    }
}

