package com.ejianc.business.zdsstore.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zdsstore.consts.InOutTypeEnum;
import com.ejianc.business.zdsstore.consts.StoreCommonConsts;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.zdsstore.bean.InOutEntity;
import com.ejianc.business.zdsstore.service.IInOutService;
import com.ejianc.business.zdsstore.vo.InOutVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 仓库出入库关系表
 *
 * @author generator
 */
@Controller
@RequestMapping("inOut")
@Api(value = "仓库出入库关系表", tags = {"仓库出入库关系表"})
public class InOutController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IInOutService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<InOutVO> saveOrUpdate(@ApiParam(name = "saveOrUpdateVO", required = true) @RequestBody InOutVO saveOrUpdateVO) {
        InOutEntity entity = BeanMapper.map(saveOrUpdateVO, InOutEntity.class);
        service.saveOrUpdate(entity, false);
        InOutVO vo = BeanMapper.map(entity, InOutVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InOutVO> queryDetail(@RequestParam Long id) {
        InOutEntity entity = service.selectById(id);
        InOutVO vo = BeanMapper.map(entity, InOutVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InOutVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (InOutVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(InOutVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<InOutVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("outBillCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        IPage<InOutEntity> page = service.queryPage(param, false);
        IPage<InOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), InOutVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<InOutEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("InOut-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refInOutData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<InOutVO>> refInOutData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                       String condition,
                                                       String searchObject,
                                                       String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("inBillCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("brandName");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("outBillCode");
        fuzzyFields.add("materialCategoryName");
        param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, StoreCommonConsts.YES));
        param.getParams().put("inOutType",new Parameter(QueryParam.IN, Arrays.asList(InOutTypeEnum.领料出库.getInOutType(),InOutTypeEnum.直入直出出库.getInOutType())));
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.containsKey("projectId")){
                param.getParams().put("outProjectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.containsKey("contractId")){
                param.getParams().put("pickContractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
            if(_con.containsKey("outDate")){
                param.getParams().put("outDate", new Parameter(QueryParam.LE, _con.get("outDate")));
            }
            if(_con.containsKey("pickType")){
                param.getParams().put("pickType", new Parameter(QueryParam.EQ, _con.get("pickType")));
            }
            if(_con.containsKey("inOutType")){
                param.getParams().put("inOutType", new Parameter(QueryParam.EQ, _con.get("inOutType")));
            }
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        //剩余数量大于0的显示
        wrapper.apply("(out_num - return_store_num) > 0");
        Page<InOutEntity> page = new Page<>(param.getPageIndex(), param.getPageSize());
        IPage <InOutEntity> listPage = service.queryInOutPageList(page, wrapper);
        //IPage <InOutEntity> listPage = service.page(page, wrapper);
        IPage<InOutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<InOutVO> inOutVOS = BeanMapper.mapList(listPage.getRecords(), InOutVO.class);
        //计算剩余可退数量
        inOutVOS.forEach(item->{
            item.setSurplusReturnStoreNum(ComputeUtil.safeSub(item.getOutNum(),item.getReturnStoreNum()));
        });
        pageData.setRecords(inOutVOS);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
