package com.ejianc.business.keyan.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;


/**
 * 专利权
 * 
 * @author generator
 * 
 */
public class KeyanPatentVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long unitId; // 所属单位id
    private String unitName; // 所属单位名称
    private String patentName; // 专利名称
    private String industryField; // 所属行业领域
    private String patentClassify; // 专利类别
    private String patentNum; // 专利号
    private String certificateNo; // 证书号
    private String patentee; // 专利权人
    private String patentDesigner; // 发明设计人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date patentApplicationDate; // 成立时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date patentAuthorizationAnnouncementDate; // 授权公告日
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date patentTerminationDate; // 专利权终止日
    private String acquisitionMethod; // 取得方式
    private String rightsLimitation; // 权利限制
    private String remarks; // 备注

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getBillState() {
        return billState;
    }

    public void setBillState(Long billState) {
        this.billState = billState;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public String getPatentName() {
        return patentName;
    }

    public void setPatentName(String patentName) {
        this.patentName = patentName;
    }
    public String getIndustryField() {
        return industryField;
    }

    public void setIndustryField(String industryField) {
        this.industryField = industryField;
    }
    public String getPatentClassify() {
        return patentClassify;
    }

    public void setPatentClassify(String patentClassify) {
        this.patentClassify = patentClassify;
    }
    public String getPatentNum() {
        return patentNum;
    }

    public void setPatentNum(String patentNum) {
        this.patentNum = patentNum;
    }
    public String getCertificateNo() {
        return certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }
    public String getPatentee() {
        return patentee;
    }

    public void setPatentee(String patentee) {
        this.patentee = patentee;
    }
    public String getPatentDesigner() {
        return patentDesigner;
    }

    public void setPatentDesigner(String patentDesigner) {
        this.patentDesigner = patentDesigner;
    }
    public Date getPatentApplicationDate() {
        return patentApplicationDate;
    }

    public void setPatentApplicationDate(Date patentApplicationDate) {
        this.patentApplicationDate = patentApplicationDate;
    }
    public Date getPatentAuthorizationAnnouncementDate() {
        return patentAuthorizationAnnouncementDate;
    }

    public void setPatentAuthorizationAnnouncementDate(Date patentAuthorizationAnnouncementDate) {
        this.patentAuthorizationAnnouncementDate = patentAuthorizationAnnouncementDate;
    }
    public Date getPatentTerminationDate() {
        return patentTerminationDate;
    }

    public void setPatentTerminationDate(Date patentTerminationDate) {
        this.patentTerminationDate = patentTerminationDate;
    }
    public String getAcquisitionMethod() {
        return acquisitionMethod;
    }

    public void setAcquisitionMethod(String acquisitionMethod) {
        this.acquisitionMethod = acquisitionMethod;
    }
    public String getRightsLimitation() {
        return rightsLimitation;
    }

    public void setRightsLimitation(String rightsLimitation) {
        this.rightsLimitation = rightsLimitation;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    
}
