package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanMonographEntity;
import com.ejianc.business.sq.keyan.bean.KeyanProjectEntity;
import com.ejianc.business.sq.keyan.service.IKeyanMonographService;
import com.ejianc.business.sq.keyan.vo.KeyanMonographVO;
import com.ejianc.business.sq.keyan.vo.KeyanProjectVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 专著
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/monograph")
public class KeyanMonographController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxKeyanMonograph";//此处需要根据实际修改

    @Autowired
    private IKeyanMonographService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanMonographVO> saveOrUpdate(@RequestBody KeyanMonographVO saveOrUpdateVO) {
    	KeyanMonographEntity entity = BeanMapper.map(saveOrUpdateVO, KeyanMonographEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	KeyanMonographVO vo = BeanMapper.map(entity, KeyanMonographVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanMonographVO> queryDetail(Long id) {
    	KeyanMonographEntity entity = service.selectById(id);
    	KeyanMonographVO vo = BeanMapper.map(entity, KeyanMonographVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanMonographVO> vos) {
        service.removeByIds(vos.stream().map(KeyanMonographVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KeyanMonographVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<KeyanMonographEntity> page = service.queryPage(param,false);
        IPage<KeyanMonographVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanMonographVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downTemplateUrl")
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "sq/keyanMonograph-import.xlsx", "专著模板");
    }
    /**
     * @Description excel导入数据检验
     */
    @RequestMapping(value = "/importCheckData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();

        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<>();
        fileds.addAll(Arrays.asList("unitName","monographName","publicationTime","author","countryInOut","authorRank","publisherName",
                "category","isbnNo","cipNo","totalWordsNumber","remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<>();
        filedsName.addAll(Arrays.asList("所属单位","著作名称","出版时间","作者","国内/外","本单位作者位次","出版社名称","类别",
                "ISBN号","CIP数据号","总字数","备注"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        Map<String, JSONObject> filedsConfig = new HashMap<>();
        JSONObject unitNameConfig = new JSONObject();
        unitNameConfig.put("org", "org");
        JSONObject unitNameMath = new JSONObject();
        unitNameMath.put("unitId", "id");
        unitNameConfig.put("fieldMath", unitNameMath);
        filedsConfig.put("unitName", unitNameConfig);
        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanMonographVO");
        importUtil.setServiceName("keyanMonographService");
        List<String> requiredFields = new ArrayList<>();//必填字段
        requiredFields.addAll(Arrays.asList("unitName","monographName","publicationTime","author","countryInOut"));
        importUtil.setRequiredFields(requiredFields);
//        List<String> uniqueneFields = new ArrayList<>();//唯一性字段
//        uniqueneFields.addAll(Arrays.asList("projectName"));
//        importUtil.setUniqueneFields(uniqueneFields);
        importUtil.setiOrgApi(iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success("保存或修改单据成功！",json);
    }

    /**
     * @Description importDataSave 导入批量新增
     */
    @RequestMapping(value = "/importDataSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanMonographVO> vos) {
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid(),vos.size());
        if(billCode.isSuccess() && billCode.getData().size() == vos.size()){
            List<KeyanMonographEntity> entitys = new ArrayList<>();
            for(int i=0; i<vos.size(); i++){
                KeyanMonographEntity entity = BeanMapper.map(vos.get(i), KeyanMonographEntity.class);
                entity.setBillCode(billCode.getData().get(i));
                entitys.add(entity);
            }
            service.saveOrUpdateBatch(entitys, entitys.size(), false);
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return CommonResponse.success("导入成功！");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("unitId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<KeyanMonographEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("keyanMonograph-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKeyanMonographData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KeyanMonographVO>> refKeyanMonographData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KeyanMonographEntity> page = service.queryPage(param,false);
        IPage<KeyanMonographVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanMonographVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
