package com.ejianc.business.sq.keyan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.time.*;
import java.util.Date;


/**
 * 高新技术企业
 * 
 * @author generator
 * 
 */
public class KeyanHighNewTechnologyEnterpriseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private String certificateNo; // 证书编号
    private Long unitId; // 高新技术企业id
    private String unitName; // 高新技术企业名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date recognitionTime; // 认定时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date firstRecognitionTime; // 首次认定时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date deadlineTime; // 截至日期
    private String remarks; // 备注
    private Integer remainingDays; // 距离到期剩余天数

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getCertificateNo() {
        return certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Date getRecognitionTime() {
        return recognitionTime;
    }

    public void setRecognitionTime(Date recognitionTime) {
        this.recognitionTime = recognitionTime;
    }
    public Date getFirstRecognitionTime() {
        return firstRecognitionTime;
    }

    public void setFirstRecognitionTime(Date firstRecognitionTime) {
        this.firstRecognitionTime = firstRecognitionTime;
    }
    public Date getDeadlineTime() {
        return deadlineTime;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getRemainingDays() {
        Integer days = remainingDays;
        if(deadlineTime!=null){
            // 定义日期时间格式
            // 定义日期时间格式
            LocalDate today = LocalDate.now();
            // 将字符串转换为Date
            Instant parsedDate = today.atStartOfDay(ZoneId.systemDefault()).toInstant();
            LocalDateTime dateTime1 = LocalDateTime.ofInstant(parsedDate, ZoneId.systemDefault()); // 将Instant对象转换为LocalDateTime对象
            LocalDateTime dateTime2 = LocalDateTime.ofInstant(deadlineTime.toInstant(), ZoneId.systemDefault()); // 将Instant对象转换为LocalDateTime对象
            // 计算差异
            Duration duration = Duration.between(dateTime1, dateTime2);
            // 输出结果
            days = Math.toIntExact(duration.toDays()) +1; // 相差的天数
        }
        return days;
    }

    public void setRemainingDays(Integer remainingDays) {
        this.remainingDays = remainingDays;
    }
}
