package com.ejianc.business.sq.operate.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanPatentEntity;
import com.ejianc.business.sq.keyan.vo.KeyanPatentVO;
import com.ejianc.business.sq.operate.bean.OperateDataReviewFilingeEntity;
import com.ejianc.business.sq.operate.service.IOperateDataReviewFilingeService;
import com.ejianc.business.sq.operate.vo.OperateDataReviewFilingeVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 资料审核备案
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/operate/dataReviewFilinge")
public class OperateDataReviewFilingeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "zydxOperateDataReviewFilinge";//此处需要根据实际修改

    @Autowired
    private IOperateDataReviewFilingeService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OperateDataReviewFilingeVO> saveOrUpdate(@RequestBody OperateDataReviewFilingeVO saveOrUpdateVO) {
    	OperateDataReviewFilingeEntity entity = BeanMapper.map(saveOrUpdateVO, OperateDataReviewFilingeEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	OperateDataReviewFilingeVO vo = BeanMapper.map(entity, OperateDataReviewFilingeVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OperateDataReviewFilingeVO> queryDetail(Long id) {
    	OperateDataReviewFilingeEntity entity = service.selectById(id);
    	OperateDataReviewFilingeVO vo = BeanMapper.map(entity, OperateDataReviewFilingeVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OperateDataReviewFilingeVO> vos) {
        service.removeByIds(vos.stream().map(OperateDataReviewFilingeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OperateDataReviewFilingeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OperateDataReviewFilingeEntity> page = service.queryPage(param,false);
        IPage<OperateDataReviewFilingeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OperateDataReviewFilingeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downTemplateUrl")
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "operate/operateDataReviewFilinge-import.xlsx", "资料审核备案模板");
    }
    /**
     * @Description excel导入数据检验
     */
    @RequestMapping(value = "/importCheckData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();

        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<>();
        fileds.addAll(Arrays.asList("whetherRelatedProject","projectName","businessType","fileName","sealType","number",
                "agentUserName","remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<>();
        filedsName.addAll(Arrays.asList("是否关联项目","项目","业务类型","文件名称","盖章种类","份数","经办人","备注"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        Map<String, JSONObject> filedsConfig = new HashMap<>();
        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("marketProject", "marketProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", "id");
        projectNameMath.put("projectDepartmentId", "projectDepartmentId");
        projectNameMath.put("orgId", "orgId");
        projectNameMath.put("orgName", "orgName");
        projectNameMath.put("projectCode", "code");
        projectNameMath.put("projectType", "type");
        projectNameMath.put("projectManager", "projectManagerName");

        projectNameConfig.put("fieldMath", projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);
        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanPatentVO");
        importUtil.setServiceName("operateDataReviewFilingeService");
        List<String> requiredFields = new ArrayList<>();//必填字段
        requiredFields.addAll(Arrays.asList("whetherRelatedProject","businessType","fileName","sealType","number","agentUserName"));
        importUtil.setRequiredFields(requiredFields);
//        List<String> uniqueneFields = new ArrayList<>();//唯一性字段
//        uniqueneFields.addAll(Arrays.asList("projectName"));
//        importUtil.setUniqueneFields(uniqueneFields);
        importUtil.setiOrgApi(iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success("保存或修改单据成功！",json);
    }

    /**
     * @Description importDataSave 导入批量新增
     */
    @RequestMapping(value = "/importDataSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanPatentVO> vos) {
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid(),vos.size());
        if(billCode.isSuccess() && billCode.getData().size() == vos.size()){
            List<OperateDataReviewFilingeEntity> entitys = new ArrayList<>();
            for(int i=0; i<vos.size(); i++){
                OperateDataReviewFilingeEntity entity = BeanMapper.map(vos.get(i), OperateDataReviewFilingeEntity.class);
                entity.setBillCode(billCode.getData().get(i));
                entitys.add(entity);
            }
            service.saveOrUpdateBatch(entitys, entitys.size(), false);
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return CommonResponse.success("导入成功！");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OperateDataReviewFilingeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("operate/operateDataReviewFilinge-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refOperateDataReviewFilingeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OperateDataReviewFilingeVO>> refOperateDataReviewFilingeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OperateDataReviewFilingeEntity> page = service.queryPage(param,false);
        IPage<OperateDataReviewFilingeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OperateDataReviewFilingeVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
