package com.ejianc.business.sq.keyan.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.sq.keyan.bean.KeyanMilestoneDetailsEntity;
import com.ejianc.business.sq.keyan.bean.KeyanMilestoneEntity;
import com.ejianc.business.sq.keyan.service.IKeyanMilestoneDetailsService;
import com.ejianc.business.sq.keyan.service.IKeyanMilestoneService;
import com.ejianc.business.sq.keyan.service.IKeyanProjectService;
import com.ejianc.business.sq.keyan.vo.KeyanMilestoneDetailsVO;
import com.ejianc.business.sq.keyan.vo.KeyanMilestoneVO;
import com.ejianc.business.util.ImportCommonUtil;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 里程碑
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("sq/keyan/milestone")
public class KeyanMilestoneController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IKeyanProjectService keyanProjectService;

    private static final String BILL_CODE = "zydxKeyanMilestone";//此处需要根据实际修改

    @Autowired
    private IKeyanMilestoneService service;
    @Autowired
    private IKeyanMilestoneDetailsService milestoneDetailsService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<KeyanMilestoneVO> saveOrUpdate(@RequestBody KeyanMilestoneVO saveOrUpdateVO) {
    	KeyanMilestoneEntity entity = BeanMapper.map(saveOrUpdateVO, KeyanMilestoneEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        String milestoneName = ""; // 里程碑名称集集合
        if(saveOrUpdateVO.getMilestoneDetailsList()!=null && saveOrUpdateVO.getMilestoneDetailsList().size()>0){
            for(KeyanMilestoneDetailsVO detailsVO : saveOrUpdateVO.getMilestoneDetailsList()){
                if(StringUtils.isBlank(detailsVO.getRowState()) ||
                        (StringUtils.isNotBlank(detailsVO.getRowState()) && !"del".equals(detailsVO.getRowState()))){
                    if(milestoneName.length()>0){
                        milestoneName += (","+detailsVO.getMilestoneName());
                    }else{
                        milestoneName += (detailsVO.getMilestoneName());
                    }
                }
            }
        }
        entity.setMilestoneName(milestoneName);
    	service.saveOrUpdate(entity, false);
    	KeyanMilestoneVO vo = BeanMapper.map(entity, KeyanMilestoneVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<KeyanMilestoneVO> queryDetail(Long id) {
    	KeyanMilestoneEntity entity = service.selectById(id);
    	KeyanMilestoneVO vo = BeanMapper.map(entity, KeyanMilestoneVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<KeyanMilestoneVO> vos) {
        service.removeByIds(vos.stream().map(KeyanMilestoneVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<KeyanMilestoneVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("establishmentUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<KeyanMilestoneEntity> page = service.queryPage(param,false);
        IPage<KeyanMilestoneVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanMilestoneVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downTemplateUrl")
    @ResponseBody
    public void downloadUnitPrice(HttpServletRequest request, HttpServletResponse response){
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "sq/keyanMilestone-import.xlsx", "其他模板");
    }
    /**
     * @Description excel导入数据检验
     */
    @RequestMapping(value = "/importCheckData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> importCheckData(HttpServletRequest request, HttpServletResponse response) {
        ImportCommonUtil importUtil = new ImportCommonUtil();

        importUtil.setDataStartLine(2);
        LinkedList<String> fileds = new LinkedList<>();
        fileds.addAll(Arrays.asList("projectName","establishmentUserName","establishmentDate","milestoneName","remarks"));
        importUtil.setFileds(fileds);
        LinkedList<String> filedsName = new LinkedList<>();
        filedsName.addAll(Arrays.asList("项目名称","编制人","编制时间","里程碑名称","备注"));
        importUtil.setFiledsName(filedsName);
        importUtil.setRequest(request);
        Map<String, JSONObject> filedsConfig = new HashMap<>();

        JSONObject projectNameConfig = new JSONObject();
        projectNameConfig.put("keyanProject", "keyanProject");
        JSONObject projectNameMath = new JSONObject();
        projectNameMath.put("projectId", "id");
        projectNameMath.put("unitId", "bearUnitId");
        projectNameMath.put("unitName", "bearUnitName");
        projectNameConfig.put("fieldMath", projectNameMath);
        filedsConfig.put("projectName", projectNameConfig);

        JSONObject establishmentUserNameConfig = new JSONObject();
        establishmentUserNameConfig.put("user", "user");
        JSONObject establishmentUserNameMath = new JSONObject();
        establishmentUserNameMath.put("establishmentUserId", "id");
        establishmentUserNameConfig.put("fieldMath", establishmentUserNameMath);
        filedsConfig.put("establishmentUserName", establishmentUserNameConfig);
        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息

        importUtil.setFiledsConfig(filedsConfig);//字段关联性配置信息
        importUtil.setVoName("com.ejianc.business.sq.keyan.vo.KeyanMilestoneVO");
        importUtil.setServiceName("keyanMilestoneService");
        List<String> requiredFields = new ArrayList<>();//必填字段
        requiredFields.addAll(Arrays.asList("projectName","establishmentUserName","establishmentDate"));
        importUtil.setRequiredFields(requiredFields);
//        List<String> uniqueneFields = new ArrayList<>();//唯一性字段
//        uniqueneFields.addAll(Arrays.asList("projectName"));
//        importUtil.setUniqueneFields(uniqueneFields);
        importUtil.setKeyanProjectService(keyanProjectService);
        importUtil.setEmployeeApi(employeeApi);
        importUtil.setiOrgApi(iOrgApi);
        JSONObject json = importUtil.importCheckData();
        return CommonResponse.success("保存或修改单据成功！",json);
    }

    /**
     * @Description importDataSave 导入批量新增
     */
    @RequestMapping(value = "/importDataSave", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> importDataSave(@RequestBody List<KeyanMilestoneVO> vos) {
        CommonResponse<List<String>> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid(),vos.size());
        if(billCode.isSuccess() && billCode.getData().size() == vos.size()){
            List<KeyanMilestoneEntity> entitys = new ArrayList<>();
            List<KeyanMilestoneDetailsEntity> milestoneDetailsList = new ArrayList<>();
            for(int i=0; i<vos.size(); i++){
                KeyanMilestoneEntity entity = BeanMapper.map(vos.get(i), KeyanMilestoneEntity.class);
                entity.setBillCode(billCode.getData().get(i));
                Long id = IdWorker.getId();
                if(StringUtils.isNotBlank(entity.getMilestoneName())){
                    String[] milestoneName = entity.getMilestoneName().split(",");
                    for(String name : milestoneName){
                        KeyanMilestoneDetailsEntity d = new KeyanMilestoneDetailsEntity();
                        d.setMilestoneName(name);
                        d.setPid(id);
                        d.setRowState("add");
                        milestoneDetailsList.add(d);
                    }
                }
                entity.setId(id);
                entitys.add(entity);
            }
            service.saveOrUpdateBatch(entitys, entitys.size(), false);
            if(milestoneDetailsList!=null && milestoneDetailsList.size()>0){
                milestoneDetailsService.saveOrUpdateBatch(milestoneDetailsList, milestoneDetailsList.size(), false);
            }
        }else{
            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
        }
        return CommonResponse.success("导入成功！");
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("unitName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("establishmentUserName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            commonOrgIds.add(org.getId());
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("unitId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<KeyanMilestoneEntity> list = service.queryList(param);
        List<KeyanMilestoneVO> result = new ArrayList<>();
        if(list!=null && list.size()>0){
            result = BeanMapper.mapList(list, KeyanMilestoneVO.class);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", result);
        ExcelExport.getInstance().exportWithTrans("sq/keyanMilestone-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refKeyanMilestoneData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<KeyanMilestoneVO>> refKeyanMilestoneData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<KeyanMilestoneEntity> page = service.queryPage(param,false);
        IPage<KeyanMilestoneVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), KeyanMilestoneVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
