/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class KeyanHighNewTechnologyEnterpriseVO
extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Integer billState;
    private String billCode;
    private String certificateNo;
    private Long unitId;
    private String unitName;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date recognitionTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date firstRecognitionTime;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date deadlineTime;
    private String remarks;
    private Integer remainingDays;
    private String errorMsg;

    public String getBillCode() {
        return this.billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return this.billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getCertificateNo() {
        return this.certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return this.unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public Date getRecognitionTime() {
        return this.recognitionTime;
    }

    public void setRecognitionTime(Date recognitionTime) {
        this.recognitionTime = recognitionTime;
    }

    public Date getFirstRecognitionTime() {
        return this.firstRecognitionTime;
    }

    public void setFirstRecognitionTime(Date firstRecognitionTime) {
        this.firstRecognitionTime = firstRecognitionTime;
    }

    public Date getDeadlineTime() {
        return this.deadlineTime;
    }

    public void setDeadlineTime(Date deadlineTime) {
        this.deadlineTime = deadlineTime;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getRemainingDays() {
        Integer days = this.remainingDays;
        if (this.deadlineTime != null) {
            LocalDate today = LocalDate.now();
            Instant parsedDate = today.atStartOfDay(ZoneId.systemDefault()).toInstant();
            LocalDateTime dateTime1 = LocalDateTime.ofInstant(parsedDate, ZoneId.systemDefault());
            LocalDateTime dateTime2 = LocalDateTime.ofInstant(this.deadlineTime.toInstant(), ZoneId.systemDefault());
            Duration duration = Duration.between(dateTime1, dateTime2);
            days = Math.toIntExact(duration.toDays()) + 1;
        }
        return days;
    }

    public void setRemainingDays(Integer remainingDays) {
        this.remainingDays = remainingDays;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

