/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.sq.keyan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

public class KeyanPatentVO
extends BaseVO {
    private static final long serialVersionUID = 1L;
    private Integer billState;
    private String billCode;
    private Long unitId;
    private String unitName;
    private String patentName;
    private String industryField;
    private String patentClassify;
    private String patentNum;
    private String certificateNo;
    private String patentee;
    private String patentDesigner;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date patentApplicationDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date patentAuthorizationAnnouncementDate;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date patentTerminationDate;
    private String acquisitionMethod;
    private Integer terminateRemainingDays;
    private String rightsLimitation;
    private String remarks;
    private String errorMsg;

    public String getBillCode() {
        return this.billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return this.billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getUnitId() {
        return this.unitId;
    }

    @ReferDeserialTransfer
    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public String getPatentName() {
        return this.patentName;
    }

    public void setPatentName(String patentName) {
        this.patentName = patentName;
    }

    public String getIndustryField() {
        return this.industryField;
    }

    public void setIndustryField(String industryField) {
        this.industryField = industryField;
    }

    public String getPatentClassify() {
        return this.patentClassify;
    }

    public void setPatentClassify(String patentClassify) {
        this.patentClassify = patentClassify;
    }

    public String getPatentNum() {
        return this.patentNum;
    }

    public void setPatentNum(String patentNum) {
        this.patentNum = patentNum;
    }

    public String getCertificateNo() {
        return this.certificateNo;
    }

    public void setCertificateNo(String certificateNo) {
        this.certificateNo = certificateNo;
    }

    public String getPatentee() {
        return this.patentee;
    }

    public void setPatentee(String patentee) {
        this.patentee = patentee;
    }

    public String getPatentDesigner() {
        return this.patentDesigner;
    }

    public void setPatentDesigner(String patentDesigner) {
        this.patentDesigner = patentDesigner;
    }

    public Date getPatentApplicationDate() {
        return this.patentApplicationDate;
    }

    public void setPatentApplicationDate(Date patentApplicationDate) {
        this.patentApplicationDate = patentApplicationDate;
    }

    public Date getPatentAuthorizationAnnouncementDate() {
        return this.patentAuthorizationAnnouncementDate;
    }

    public void setPatentAuthorizationAnnouncementDate(Date patentAuthorizationAnnouncementDate) {
        this.patentAuthorizationAnnouncementDate = patentAuthorizationAnnouncementDate;
    }

    public Date getPatentTerminationDate() {
        return this.patentTerminationDate;
    }

    public void setPatentTerminationDate(Date patentTerminationDate) {
        this.patentTerminationDate = patentTerminationDate;
    }

    public String getAcquisitionMethod() {
        return this.acquisitionMethod;
    }

    public void setAcquisitionMethod(String acquisitionMethod) {
        this.acquisitionMethod = acquisitionMethod;
    }

    public String getRightsLimitation() {
        return this.rightsLimitation;
    }

    public void setRightsLimitation(String rightsLimitation) {
        this.rightsLimitation = rightsLimitation;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Integer getTerminateRemainingDays() {
        Integer days = this.terminateRemainingDays;
        if (this.patentTerminationDate != null) {
            LocalDate today = LocalDate.now();
            Instant parsedDate = today.atStartOfDay(ZoneId.systemDefault()).toInstant();
            LocalDateTime dateTime1 = LocalDateTime.ofInstant(parsedDate, ZoneId.systemDefault());
            LocalDateTime dateTime2 = LocalDateTime.ofInstant(this.patentTerminationDate.toInstant(), ZoneId.systemDefault());
            Duration duration = Duration.between(dateTime1, dateTime2);
            days = Math.toIntExact(duration.toDays());
        }
        return days;
    }

    public void setTerminateRemainingDays(Integer terminateRemainingDays) {
        this.terminateRemainingDays = terminateRemainingDays;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

