package com.ejianc.business.prjdocs.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.prjdocs.bean.PrjCompletionAssessmentEntity;
import com.ejianc.business.prjdocs.bean.PrjCompletionAssessmentItemEntity;
import com.ejianc.business.prjdocs.mapper.PrjCompletionAssessmentMapper;
import com.ejianc.business.prjdocs.service.IPrjCompletionAssessmentItemService;
import com.ejianc.business.prjdocs.service.IPrjCompletionAssessmentService;
import com.ejianc.business.prjdocs.vo.PrjCompletionAssessmentItemVO;
import com.ejianc.business.prjdocs.vo.PrjCompletionAssessmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * 项目完工考核
 * 
 * @author generator
 * 
 */
@Service("prjCompletionAssessmentService")
public class PrjCompletionAssessmentServiceImpl extends BaseServiceImpl<PrjCompletionAssessmentMapper, PrjCompletionAssessmentEntity> implements IPrjCompletionAssessmentService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPrjCompletionAssessmentItemService itemService;

    private static final String BILL_CODE = "zydxCompletionAssessment";//此处需要根据实际修改

    private static void sortIntMethod(List<PrjCompletionAssessmentItemVO> list){
        Collections.sort(list, new Comparator(){
            @Override
            public int compare(Object o1, Object o2) {
                ObjectMapper objectMapper = new ObjectMapper();
                PrjCompletionAssessmentItemVO o1Detail = objectMapper.convertValue(o1, PrjCompletionAssessmentItemVO.class);
                PrjCompletionAssessmentItemVO o2Detail = objectMapper.convertValue(o2, PrjCompletionAssessmentItemVO.class);
                String[] strs1 = o1Detail.getItemCode().split("\\.");
                String[] strs2 = o2Detail.getItemCode().split("\\.");
                int length = strs1.length > strs2.length ? strs1.length : strs2.length;
                for (int i = 0; i < length; i++) {
                    int num1 = 0;
                    int num2 = 0;
                    try {
                        num1 = Integer.parseInt(strs1[i]);
                        num2 = Integer.parseInt(strs2[i]);
                    } catch (Exception e) {

                    }
                    if (num1 < num2)
                        return -1;
                    if (num1 > num2)
                        return 1;
                }
                return 0;
            }
        });
    }
    @Override
    public PrjCompletionAssessmentVO saveData(PrjCompletionAssessmentVO saveOrUpdateVO) {
        PrjCompletionAssessmentEntity entity = BeanMapper.map(saveOrUpdateVO, PrjCompletionAssessmentEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        this.saveOrUpdate(entity, false);
        PrjCompletionAssessmentVO vo = BeanMapper.map(entity, PrjCompletionAssessmentVO.class);
        if (CollectionUtils.isNotEmpty(vo.getItemList())) {
            sortIntMethod(vo.getItemList());
        }
        return vo;
    }

    @Override
    public PrjCompletionAssessmentVO queryDetail(Long id) {
        PrjCompletionAssessmentEntity entity = this.selectById(id);
        PrjCompletionAssessmentVO vo = BeanMapper.map(entity, PrjCompletionAssessmentVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("assessmentId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("itemCode", "asc");
        List<PrjCompletionAssessmentItemEntity> detailEntityList = itemService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            List<PrjCompletionAssessmentItemVO> resultMapList = BeanMapper.mapList(detailEntityList, PrjCompletionAssessmentItemVO.class);
            sortIntMethod(resultMapList);
            vo.setItemList(resultMapList);
        }
        return vo;
    }
}
