package com.ejianc.business.sq.keyan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.sq.keyan.vo.KeyanWorkSureUserVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工时确认
 * 
 * @author generator
 * 
 */
public class KeyanWorkSureVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Integer billState; // 单据审批状态
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long unitId; // 所属单位id
    private String unitName; // 所属单位名称
    private Long fillUserId; // 填报人id
    private String fillUserName; // 填报人
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fillDate; // 填报时间
    private String remarks; // 备注

    private String errorMsg; // 导入错误信息
    private List<KeyanWorkSureUserVO> userList = new ArrayList<>(); // 工时明细人员

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="zydx-keyan-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getFillUserId() {
        return fillUserId;
    }

    @ReferDeserialTransfer
    public void setFillUserId(Long fillUserId) {
        this.fillUserId = fillUserId;
    }
    public String getFillUserName() {
        return fillUserName;
    }

    public void setFillUserName(String fillUserName) {
        this.fillUserName = fillUserName;
    }
    public Date getFillDate() {
        return fillDate;
    }

    public void setFillDate(Date fillDate) {
        this.fillDate = fillDate;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public List<KeyanWorkSureUserVO> getUserList() {
        return userList;
    }

    public void setUserList(List<KeyanWorkSureUserVO> userList) {
        this.userList = userList;
    }

    public String getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}
