/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateApproveEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.enums.ChangeStateEnum;
import com.ejianc.business.zjkjcost.reserve.mapper.AllocateMapper;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateChangeService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateHistoryService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateApproveVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateChangeVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateDetailVO;
import com.ejianc.business.zjkjcost.reserve.vo.AllocateVO;
import com.ejianc.business.zjkjcost.reserve.vo.PersonalApproveVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="allocateService")
public class AllocateServiceImpl
extends BaseServiceImpl<AllocateMapper, AllocateEntity>
implements IAllocateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IPersonalApproveService personalApproveService;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private IAllocateHistoryService allocateHistoryService;
    @Autowired
    private IAllocateChangeService allocateChangeService;
    @Autowired
    private IAllocateDetailService allocateDetailService;
    @Autowired
    private AllocateMapper allocateMapper;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "FXYLJFP_CODE";

    @Override
    public AllocateVO saveOrUpdate(AllocateVO saveOrUpdateVO) {
        List list;
        AllocateEntity entity;
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            saveOrUpdateVO.setParentOrgName(orgVO.getName());
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
            saveOrUpdateVO.setOrgName(orgVO.getName());
        }
        List detailList = saveOrUpdateVO.getDetailList();
        ArrayList<AllocateApproveEntity> allocateApproveList = new ArrayList<AllocateApproveEntity>();
        Map<Long, AllocateApproveVO> collect = saveOrUpdateVO.getApproveList().stream().collect(Collectors.toMap(BaseVO::getId, detail -> detail, (v1, v2) -> v2));
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (AllocateDetailVO detailVO : detailList) {
                List approveVOS = detailVO.getAllocateApproveVOS();
                if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)approveVOS)) continue;
                for (AllocateApproveVO approveVO : approveVOS) {
                    if ("del" != detailVO.getRowState()) {
                        if (detailVO.getId() == null) {
                            long id = IdWorker.getId();
                            detailVO.setId(Long.valueOf(id));
                        }
                    } else {
                        if (null == approveVO.getId()) continue;
                        approveVO.setRowState("del");
                    }
                    if (collect.containsKey(approveVO.getId())) {
                        collect.remove(approveVO.getId());
                    }
                    approveVO.setAllocateDetailId(detailVO.getId());
                    AllocateApproveEntity allocateApproveEntity = (AllocateApproveEntity)((Object)BeanMapper.map((Object)approveVO, AllocateApproveEntity.class));
                    allocateApproveList.add(allocateApproveEntity);
                }
            }
        }
        if (MapUtils.isNotEmpty(collect)) {
            collect.values().forEach(c -> {
                c.setRowState("del");
                allocateApproveList.add((AllocateApproveEntity)((Object)BeanMapper.map((Object)c, AllocateApproveEntity.class)));
            });
        }
        if ((entity = (AllocateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AllocateEntity.class))).getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        if (null != saveOrUpdateVO.getId()) {
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)lambda)))) {
            throw new BusinessException("\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\u9879\u76ee\u90e8\u4eba\u5458\u98ce\u9669\u91d1\u9884\u7559\u5206\u914d\u8868\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        entity.setBaseShouldReserveMny(entity.getShouldReserveMny());
        entity.setBaseActualReserveMny(entity.getActualReserveMny());
        entity.setBaseReserveRatio(entity.getReserveRatio());
        entity.setChangeState(ChangeStateEnum.\u672a\u53d8\u66f4.getCode());
        entity.setApproveList(allocateApproveList);
        super.saveOrUpdate((Object)entity, false);
        AllocateVO allocateVO = this.queryDetail(entity.getId());
        return allocateVO;
    }

    @Override
    public Map<String, Object> getProjectUser(Long projectId, Long orgId, Long id) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Boolean flag = false;
        List entities = new ArrayList();
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(AllocateEntity::getProjectId, (Object)projectId);
        if (null != id) {
            lambda.ne(BaseEntity::getId, (Object)id);
        }
        if (CollectionUtils.isNotEmpty(entities = super.list((Wrapper)lambda))) {
            flag = true;
        }
        map.put("flag", flag);
        CommonResponse employeeList = this.userApi.getEmployeeList(orgId);
        ArrayList<AllocateDetailVO> detailVOS = new ArrayList<AllocateDetailVO>();
        if (employeeList.isSuccess()) {
            List data = (List)employeeList.getData();
            if (null != data && CollectionUtils.isNotEmpty((Collection)data)) {
                for (Map datum : data) {
                    if (datum.isEmpty()) continue;
                    AllocateDetailVO detailVO = new AllocateDetailVO();
                    if (null == datum.get("userId")) continue;
                    detailVO.setPersonnelId(Long.valueOf(String.valueOf(datum.get("userId"))));
                    detailVO.setPersonnelName(String.valueOf(datum.get("userName")));
                    detailVOS.add(detailVO);
                }
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u90e8\u4eba\u5458\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + employeeList.getMsg());
        }
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            List collect = detailVOS.stream().map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list = this.personalApproveService.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO : detailVOS) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if (!detailVO.getPersonnelId().equals(approve.getApplicantId())) continue;
                        if (StringUtils.isNotBlank((String)detailVO.getFhzdltIds())) {
                            detailVO.setFhzdltIds(detailVO.getFhzdltIds() + "," + approve.getId());
                        } else {
                            detailVO.setFhzdltIds(String.valueOf(approve.getId()));
                        }
                        AllocateApproveVO map1 = new AllocateApproveVO();
                        map1.setSourceId(approve.getId());
                        map1.setSourceCode(approve.getBillCode());
                        map1.setPersonnelId(approve.getApplicantId());
                        map1.setPersonnelName(approve.getApplicantName());
                        map1.setSourceType(approve.getApplyClauseType());
                        map1.setRowState("add");
                        List allocateApproveVOS = detailVO.getAllocateApproveVOS();
                        allocateApproveVOS.add(map1);
                    }
                }
            }
        }
        map.put("detailVOS", detailVOS);
        return map;
    }

    @Override
    public AllocateVO queryDetail(Long id) {
        AllocateEntity entity = (AllocateEntity)((Object)super.selectById((Serializable)id));
        AllocateVO vo = (AllocateVO)BeanMapper.map((Object)((Object)entity), AllocateVO.class);
        List<AllocateChangeVO> bgHistory = this.allocateMapper.getBGHistory(vo.getId());
        vo.setChangeList(bgHistory);
        List detailVOS = vo.getDetailList();
        List<AllocateApproveEntity> allocateApproveList = entity.getApproveList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allocateApproveList)) {
            List allocateApproveVOList = BeanMapper.mapList(allocateApproveList, AllocateApproveVO.class);
            Map<Long, List<AllocateApproveVO>> bidderMap = allocateApproveVOList.stream().collect(Collectors.groupingBy(AllocateApproveVO::getAllocateDetailId));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)detailVOS)) {
                for (AllocateDetailVO detailVO : detailVOS) {
                    List<AllocateApproveVO> approveVOS = bidderMap.get(detailVO.getId());
                    if (!com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(approveVOS)) continue;
                    detailVO.setAllocateApproveVOS(approveVOS);
                }
                vo.setDetailList(detailVOS);
            }
        }
        return vo;
    }

    @Override
    public Map<String, Object> queryDetailFHZD(Long personnelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String fhzdltIds = null;
        ArrayList<AllocateApproveVO> allocateApproveVOS = new ArrayList<AllocateApproveVO>();
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(PersonalApproveEntity::getApplicantId, (Object)personnelId);
        lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
        List list = this.personalApproveService.list((Wrapper)lambdachange);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
            for (PersonalApproveVO approve : approveVOS) {
                fhzdltIds = null != fhzdltIds ? fhzdltIds + "," + approve.getId() : String.valueOf(approve.getId());
                AllocateApproveVO map1 = new AllocateApproveVO();
                map1.setSourceId(approve.getId());
                map1.setSourceCode(approve.getBillCode());
                map1.setPersonnelId(approve.getApplicantId());
                map1.setPersonnelName(approve.getApplicantName());
                map1.setSourceType(approve.getApplyClauseType());
                map1.setRowState("add");
                allocateApproveVOS.add(map1);
            }
        }
        map.put("personnelId", personnelId);
        map.put("fhzdltIds", fhzdltIds);
        map.put("allocateApproveVOS", allocateApproveVOS);
        return map;
    }

    @Override
    public Object excelImportMaterial(HttpServletRequest request, HttpServletResponse response) {
        AllocateDetailVO detailVO;
        Long orgId = Long.valueOf(request.getParameter("orgId"));
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<AllocateDetailVO> successList = new ArrayList<AllocateDetailVO>();
        ArrayList<AllocateDetailVO> errorList = new ArrayList<AllocateDetailVO>();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            Object extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        CommonResponse employeeList = this.userApi.getEmployeeList(orgId);
        HashMap<String, Long> userIdMap = new HashMap<String, Long>();
        if (employeeList.isSuccess()) {
            List data = (List)employeeList.getData();
            if (null != data && CollectionUtils.isNotEmpty((Collection)data)) {
                for (Map datum : data) {
                    if (datum.isEmpty()) continue;
                    detailVO = new AllocateDetailVO();
                    if (null == datum.get("userId") || null == datum.get("userName")) continue;
                    userIdMap.put(String.valueOf(datum.get("userName")), Long.valueOf(String.valueOf(datum.get("userId"))));
                }
            }
        } else {
            throw new BusinessException("\u67e5\u8be2\u9879\u76ee\u90e8\u4eba\u5458\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + employeeList.getMsg());
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                detailVO = new AllocateDetailVO();
                detailVO.setId(Long.valueOf(IdWorker.getId()));
                if (StringUtils.isBlank((String)((String)datas.get(0)))) {
                    detailVO.setErrorMsg("\u59d3\u540d\u4e3a\u7a7a\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setPersonnelName((String)datas.get(0));
                Long personnelId = (Long)userIdMap.get(datas.get(0));
                if (null == personnelId) {
                    detailVO.setErrorMsg("\u8be5\u4eba\u5458\u4e0d\u5728\u5f53\u524d\u9879\u76ee\u4e0b\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setPersonnelId(personnelId);
                detailVO.setPostName((String)datas.get(1));
                try {
                    String detailRatio = (String)datas.get(2);
                    detailVO.setDetailRatio(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)detailRatio) ? new BigDecimal(detailRatio) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u98ce\u9669\u91d1\u6bd4\u4f8b\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String shouldDetailMny = (String)datas.get(3);
                    if (StringUtils.isBlank((String)shouldDetailMny)) {
                        detailVO.setErrorMsg("\u5e94\u9884\u7559\u98ce\u9669\u91d1\u4e3a\u7a7a\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setShouldDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)shouldDetailMny) ? new BigDecimal(shouldDetailMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5e94\u9884\u7559\u98ce\u9669\u91d1\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                try {
                    String actualDetailMny = (String)datas.get(4);
                    if (StringUtils.isBlank((String)actualDetailMny)) {
                        detailVO.setErrorMsg("\u5b9e\u9645\u9884\u7559\u98ce\u9669\u91d1\u4e3a\u7a7a\uff01");
                        errorList.add(detailVO);
                        continue;
                    }
                    detailVO.setActualDetailMny(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)actualDetailMny) ? new BigDecimal(actualDetailMny) : null);
                }
                catch (Exception e) {
                    detailVO.setErrorMsg("\u5b9e\u9645\u9884\u7559\u98ce\u9669\u91d1\u683c\u5f0f\u9519\u8bef\uff01");
                    errorList.add(detailVO);
                    continue;
                }
                detailVO.setFileIds("");
                detailVO.setRowState("add");
                detailVO.setBillCode(String.valueOf(new Date().getTime()));
                detailVO.setMemo((String)datas.get(5));
                successList.add(detailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(successList)) {
            List collect = successList.stream().filter(t -> t.getPersonnelId() != null).map(t -> t.getPersonnelId()).collect(Collectors.toList());
            LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
            lambdachange.in(PersonalApproveEntity::getApplicantId, collect);
            lambdachange.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
            lambdachange.in(PersonalApproveEntity::getBillState, new Object[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()});
            List list = this.personalApproveService.list((Wrapper)lambdachange);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                List approveVOS = BeanMapper.mapList((Iterable)list, PersonalApproveVO.class);
                for (AllocateDetailVO detailVO2 : successList) {
                    for (PersonalApproveVO approve : approveVOS) {
                        if (null == detailVO2.getPersonnelId() || !detailVO2.getPersonnelId().equals(approve.getApplicantId())) continue;
                        if (StringUtils.isNotBlank((String)detailVO2.getFhzdltIds())) {
                            detailVO2.setFhzdltIds(detailVO2.getFhzdltIds() + "," + approve.getId());
                        } else {
                            detailVO2.setFhzdltIds(String.valueOf(approve.getId()));
                        }
                        AllocateApproveVO map1 = new AllocateApproveVO();
                        map1.setSourceId(approve.getId());
                        map1.setSourceCode(approve.getBillCode());
                        map1.setPersonnelId(approve.getApplicantId());
                        map1.setPersonnelName(approve.getApplicantName());
                        map1.setSourceType(approve.getApplyClauseType());
                        map1.setRowState("add");
                        List allocateApproveVOS = detailVO2.getAllocateApproveVOS();
                        allocateApproveVOS.add(map1);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return json;
    }

    @Override
    public Boolean citeCheck(Long id) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.like(AllocateDetailEntity::getFhzdltIds, (Object)String.valueOf(id));
        lambda.eq(BaseEntity::getDr, (Object)BaseVO.DR_UNDELETE);
        List list = this.allocateDetailService.list((Wrapper)lambda);
        this.logger.info("\u6821\u9a8c\u6570\u636e----{}", (Object)JSONObject.toJSONString((Object)list));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return false;
        }
        return true;
    }
}

