package com.ejianc.business.zjkjcost.optimization.service.impl;

import com.ejianc.business.zjkjcost.optimization.bean.OptimizationRewardEntity;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyFlagEnum;
import com.ejianc.business.zjkjcost.optimization.enums.OccupyTypeEnum;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationTopicService;
import com.ejianc.business.zjkjcost.optimization.vo.OptimizationRewardVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.zjkjcost.optimization.mapper.OptimizationRewardMapper;
import com.ejianc.business.zjkjcost.optimization.bean.OptimizationRewardEntity;
import com.ejianc.business.zjkjcost.optimization.service.IOptimizationRewardService;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 项目优化-项目优化奖励申请
 * 
 * @author generator
 * 
 */
@Service("optimizationRewardService")
public class OptimizationRewardServiceImpl extends BaseServiceImpl<OptimizationRewardMapper, OptimizationRewardEntity> implements IOptimizationRewardService{
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOptimizationTopicService topicService;


    private static final String BILL_CODE = "OPTIMIZATION_REWARD_CODE";//此处需要根据实际修改

    /**
     * 保存数据
     *
     * @param saveOrUpdateVO 需要保存的数据
     * @return 保存后数据
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public OptimizationRewardVO saveData(OptimizationRewardVO saveOrUpdateVO) {
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());

            }
        }
        if (StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
                saveOrUpdateVO.setOrgName(orgVO.getName());

            }
        }
        OptimizationRewardEntity entity = BeanMapper.map(saveOrUpdateVO, OptimizationRewardEntity.class);
        boolean flag = this.checkOnly(entity.getTopicId(), entity.getId());
        if (flag) {
            throw new BusinessException("该项目优化立项申报已经被引用，不允许新增");
        }
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam
                    .build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean ocuFlag = true;
        // 释放原来的项目立项申报
        if (entity.getId() != null) {
            OptimizationRewardEntity oldEntity = super.selectById(entity.getId());
            // 减少数据库操作
            if (oldEntity.getTopicId().equals(entity.getTopicId())) {
                ocuFlag = false;
            }
            if (ocuFlag) {
                topicService.updateOccupyFlagByTopicId(oldEntity.getTopicId(),
                        OccupyFlagEnum.未占用.getCode(), OccupyTypeEnum.项目优化奖励申请.getCode());
            }
        }
        // 重新占用
        if (ocuFlag) {
            topicService.updateOccupyFlagByTopicId(entity.getTopicId(),
                    OccupyFlagEnum.已占用.getCode(), OccupyTypeEnum.项目优化奖励申请.getCode());
        }
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OptimizationRewardVO.class);
    }

    /**
     * 删除数据
     *
     * @param vos 需要删除的数据id
     */
    @Override
    public void deleteData(List<OptimizationRewardVO> vos) {
        if (CollectionUtils.isEmpty(vos)) return;
        List<Long> ids = vos.stream().map(OptimizationRewardVO::getId).collect(Collectors.toList());
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<OptimizationRewardEntity> list = super.queryList(queryParam, false);
        // 未查询到数据代表不需要删除
        if (CollectionUtils.isEmpty(list)) return;
        List<Long> topicIdList = list.stream().map(OptimizationRewardEntity::getTopicId)
                .collect(Collectors.toList());
        topicService.updateOccupyFlagByTopicIds(topicIdList, OccupyFlagEnum.未占用.getCode(), OccupyTypeEnum.项目优化奖励申请
                .getCode());
        super.removeByIds(ids, true);
    }

    /**
     * 一个项目申报下只能有一个项目优化效益计算(true 有数据，false，没有数据)
     *
     * @param topicId 项目申报id
     * @param id      本单据id
     * @return 校验结果：true 校验不通过！ false：校验通过
     */
    @Override
    public boolean checkOnly(Long topicId, Long id) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("topicId", new Parameter(QueryParam.EQ, topicId));
        if (id != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, id));
        }
        List<OptimizationRewardEntity> list = super.queryList(queryParam, false);
        // 存在校验不通过，返回true，不存在返回false
        return CollectionUtils.isNotEmpty(list);
    }
}
