package com.ejianc.business.zjkjcost.reserve.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateDetailEntity;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.bean.PersonalApproveEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateDetailService;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;

import com.ejianc.business.zjkjcost.reserve.service.IPersonalApproveService;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;

import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.List;

@Service("personalApprove")
public class PersonalApproveBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IPersonalApproveService service;

    @Autowired
    private IPersonalApproveService personalApproveService;

    @Autowired
    private IAllocateService allocateService;

    @Autowired
    private IAllocateDetailService iAllocateDetailService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
//        //审批完之后根据项目，申请人去查个人风险金的表，将总经理的应返还金额返回
//        BigDecimal generalRemortgageMny = new BigDecimal("0.00");
//        PersonalApproveEntity personalApproveEntity1 = personalApproveService.selectById(billId);
//        Long projectId = personalApproveEntity1.getProjectId();
//        Long applicantId = personalApproveEntity1.getApplicantId();//申请人
//        String applyClauseType = personalApproveEntity1.getApplyClause();//申请事项
//        QueryWrapper<PersonalApproveEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.eq("project_id", projectId);
//        queryWrapper.eq("applicant_id", applicantId);
//        queryWrapper.eq("dr", 0);
//        queryWrapper.in("bill_state", 1,3);
//        List<PersonalApproveEntity> list = personalApproveService.list(queryWrapper);
//        for (PersonalApproveEntity personalApproveEntity : list) {
//            if(billId.equals(personalApproveEntity.getId())){
//                generalRemortgageMny = personalApproveEntity.getGeneralRemortgageMny();//总经理审批金额
//            }
//
//        }
//
//        //查询项目部人员风险金预留分配表
//        QueryWrapper<AllocateEntity> queryWrapper1 = new QueryWrapper<>();
//        queryWrapper1.eq("project_id", projectId);
//        //queryWrapper.eq("applicant_id",applicantId);
//        queryWrapper1.eq("dr", 0);
//        queryWrapper1.eq("bill_state", 1);
//        List<AllocateEntity> list1 = allocateService.list(queryWrapper1);
//        if (list1.size() > 0 && list1 != null) {
//            java.lang.Long mid = list1.get(0).getId();
//            AllocateEntity allocateEntities = allocateService.selectById(mid);
//            List<AllocateDetailEntity> detailList = allocateEntities.getDetailList();
//            for (AllocateDetailEntity allocateDetail : detailList) {
//                Long personnelId = allocateDetail.getPersonnelId();
//                if (personnelId !=null && personnelId.equals(applicantId)){
//                    if ("返还".equals(applyClauseType)) {
//                        allocateDetail.setReturnMortgageMny(generalRemortgageMny); //返还的总经理审批金额
//                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
//                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
//                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
//                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
//                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
//                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
//                        //应预留风险金余额
//                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
//                        //实际预留风险金余额
//                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
//                    } else if ("转抵".equals(applyClauseType)){
//                        allocateDetail.setMortgageMny(generalRemortgageMny); //转抵的总经理审批金额
//                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
//                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
//                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
//                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
//                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
//                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
//                        //应预留风险金余额
//                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
//                        //实际预留风险金余额
//                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
//                    }else{
//                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
//                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
//                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
//                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
//                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
//                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
//                        //应预留风险金余额
//                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
//                        //实际预留风险金余额
//                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
//                    }
//                }
//            }
//            iAllocateDetailService.saveOrUpdateBatch(detailList);
//        }
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //审批完之后根据项目，申请人去查个人风险金的表，将总经理的应返还金额返回
        BigDecimal generalRemortgageMny = new BigDecimal("0.00");
        PersonalApproveEntity personalApproveEntity1 = personalApproveService.selectById(billId);
        Long projectId = personalApproveEntity1.getProjectId();
        Long applicantId = personalApproveEntity1.getApplicantId();//申请人
        String applyClauseType = personalApproveEntity1.getApplyClause();//申请事项
        String billCode = personalApproveEntity1.getBillCode();
        QueryWrapper<PersonalApproveEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.eq("applicant_id", applicantId);
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 1,3);
        List<PersonalApproveEntity> list = personalApproveService.list(queryWrapper);
        for (PersonalApproveEntity personalApproveEntity : list) {
            generalRemortgageMny = personalApproveEntity.getGeneralRemortgageMny();//总经理审批金额
        }

        //查询项目部人员风险金预留分配表
        QueryWrapper<AllocateEntity> queryWrapper1 = new QueryWrapper<>();
        queryWrapper1.eq("project_id", projectId);
        //queryWrapper.eq("applicant_id",applicantId);
        queryWrapper1.eq("dr", 0);
        queryWrapper1.eq("bill_state", 1);
        List<AllocateEntity> list1 = allocateService.list(queryWrapper1);
        if (list1.size() > 0 && list1 != null) {
            java.lang.Long mid = list1.get(0).getId();
            AllocateEntity allocateEntities = allocateService.selectById(mid);
            List<AllocateDetailEntity> detailList = allocateEntities.getDetailList();
            for (AllocateDetailEntity allocateDetail : detailList) {
                Long personnelId = allocateDetail.getPersonnelId();
                if (personnelId !=null && personnelId.equals(applicantId)){
                    if ("返还".equals(applyClauseType)) {
                        //如果已经发生过返还，累加
                        if(allocateDetail.getReturnMortgageMny() != null){
                            allocateDetail.setReturnMortgageMny(generalRemortgageMny.add(allocateDetail.getReturnMortgageMny()));//返还的总经理审批金额
                        }
                        else{
                            allocateDetail.setReturnMortgageMny(generalRemortgageMny); //返还的总经理审批金额
                        }
                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                        //应预留风险金余额
                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                        //实际预留风险金余额
                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                        //返还，转抵编号合集
                        if(allocateDetail.getFhzdltIds() != null){
                            allocateDetail.setFhzdltIds(","+billCode);
                        }
                    } else if ("转抵".equals(applyClauseType)){
                        if(allocateDetail.getMortgageMny() != null){
                            allocateDetail.setMortgageMny(generalRemortgageMny.add(allocateDetail.getMortgageMny()));//返还的总经理审批金额
                        }else{
                            allocateDetail.setMortgageMny(generalRemortgageMny);//返还的总经理审批金额
                        }
                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                        //应预留风险金余额
                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                        //实际预留风险金余额
                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                        //返还，转抵编号合集
                        if(allocateDetail.getFhzdltIds() != null){
                            allocateDetail.setFhzdltIds(","+billCode);
                        }
                    }else{
                        BigDecimal shouldDetailMny = allocateDetail.getShouldDetailMny() != null ? allocateDetail.getShouldDetailMny() : new BigDecimal(0);//应预留风险金（元）
                        BigDecimal actualDetailMny = allocateDetail.getActualDetailMny() != null ? allocateDetail.getActualDetailMny() : new BigDecimal(0);//实际预留风险金（元）
                        BigDecimal returnMortgageMnies = allocateDetail.getReturnMortgageMny() != null ? allocateDetail.getReturnMortgageMny() : new BigDecimal(0);//返还金额
                        BigDecimal shouldSubtracts = shouldDetailMny.subtract(returnMortgageMnies);//应预留风险金（元）-返还金额
                        BigDecimal actualAubtract = actualDetailMny.subtract(returnMortgageMnies);//实际预留风险金（元）-返还金额
                        BigDecimal mortgageMnies = allocateDetail.getMortgageMny() != null ? allocateDetail.getMortgageMny() : new BigDecimal(0);//转抵金额
                        //应预留风险金余额
                        allocateDetail.setShouldBalanceMny(shouldSubtracts.subtract(mortgageMnies));
                        //实际预留风险金余额
                        allocateDetail.setActualBalanceMny(actualAubtract.subtract(mortgageMnies));
                    }
                }
            }
            iAllocateDetailService.saveOrUpdateBatch(detailList);
        }

        return CommonResponse.success();
    }


    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
        logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
        }
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
