/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.zjkjcost.manage.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.zjkjcost.manage.bean.BookEntity;
import com.ejianc.business.zjkjcost.manage.service.IBookService;
import com.ejianc.business.zjkjcost.reserve.bean.AllocateEntity;
import com.ejianc.business.zjkjcost.reserve.service.IAllocateService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="book")
public class BookBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBookService bookService;
    @Autowired
    private IAllocateService allocateService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        BookEntity bookEntity = (BookEntity)((Object)this.bookService.selectById(billId));
        List allocateEntities = this.allocateService.list((Wrapper)new QueryWrapper().eq((Object)"project_id", (Object)bookEntity.getProjectId()));
        for (AllocateEntity entity : allocateEntities) {
            entity.setShouldReserveMny(ComputeUtil.safeMultiply((BigDecimal)bookEntity.getRiskFund(), (BigDecimal)new BigDecimal(10000)));
        }
        this.allocateService.saveBatch(allocateEntities);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        return CommonResponse.success();
    }
}

