package com.ejianc.business.fill.vo;

import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.plan.vo.ExecPlanVO;
import com.ejianc.business.plan.vo.TotalPlanDetailVO;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 年度计划
 * 
 * @author generator
 * 
 */
public class WarnProjectVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long planId; // 总计划主键
    private Long projectManager;// 项目经理
    private String projectManagerName;// 项目经理名称
    private String mobilePhone;// 联系电话

    private Integer projectLight; // 项目完成时间预警
    private BigDecimal projectDays; // 项目完成时间滞后天数

    private Integer isMonthPlan; //是否存在月计划
    private Integer monthLight; // 当月进度预警
    private BigDecimal monthDays; // 当月进度滞后天数

    private List<ExecPlanDetailVO> contractLightList = new ArrayList<>();

    private ExecPlanVO execPlan; //执行计划中的总计划

    private BigDecimal contractSurplusDays; //合同剩余天数
    private Integer contractLight; //最近里程碑节点亮灯
    private BigDecimal sumWarn; // 里程碑节点报警次数
    private BigDecimal diffValue; // 偏差值

    /**
     * 项目状态：1-未开工, 2-在建，3-完成
     */
    private String projectStatus;

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(Long projectManager) {
        this.projectManager = projectManager;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public String getMobilePhone() {
        return mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public Integer getProjectLight() {
        return projectLight;
    }

    public void setProjectLight(Integer projectLight) {
        this.projectLight = projectLight;
    }

    public BigDecimal getProjectDays() {
        return projectDays;
    }

    public void setProjectDays(BigDecimal projectDays) {
        this.projectDays = projectDays;
    }

    public Integer getMonthLight() {
        return monthLight;
    }

    public void setMonthLight(Integer monthLight) {
        this.monthLight = monthLight;
    }

    public BigDecimal getMonthDays() {
        return monthDays;
    }

    public void setMonthDays(BigDecimal monthDays) {
        this.monthDays = monthDays;
    }

    public List<ExecPlanDetailVO> getContractLightList() {
        return contractLightList;
    }

    public void setContractLightList(List<ExecPlanDetailVO> contractLightList) {
        this.contractLightList = contractLightList;
    }

    public ExecPlanVO getExecPlan() {
        return execPlan;
    }

    public void setExecPlan(ExecPlanVO execPlan) {
        this.execPlan = execPlan;
    }

    public BigDecimal getContractSurplusDays() {
        return contractSurplusDays;
    }

    public void setContractSurplusDays(BigDecimal contractSurplusDays) {
        this.contractSurplusDays = contractSurplusDays;
    }

    public Integer getContractLight() {
        return contractLight;
    }

    public void setContractLight(Integer contractLight) {
        this.contractLight = contractLight;
    }

    public BigDecimal getSumWarn() {
        return sumWarn;
    }

    public void setSumWarn(BigDecimal sumWarn) {
        this.sumWarn = sumWarn;
    }

    public Integer getIsMonthPlan() {
        return isMonthPlan;
    }

    public void setIsMonthPlan(Integer isMonthPlan) {
        this.isMonthPlan = isMonthPlan;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }
}
