package com.ejianc.business.plan.vo;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 执行计划详情
 * 
 * @author generator
 * 
 */
public class ExecPlanDetailVO extends BaseDetailVO {
    private static final long serialVersionUID = 1L;
    
    private Integer taskLine; // 任务条线(手续线、设计线、建造线、招采线)
    private Integer nodeLevel; // 节点级别
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private BigDecimal planNum; // 工程量
    private Integer unit; // 单位(枚举格式012， 包含：㎡、m、m3、kg、t、个)
    private String resourceName; // 资源名称
    private Integer type; // 资源类型(劳动力、材料、机械)
    private Integer typeUnit; // 资源单位(㎡、m、m3、kg、t、个、台班、工日)
    private BigDecimal needNum; // 需求量
    private String percentTask; // 任务百分比
    private Integer planState; // 任务标识 1-总计划、2-年计划、3-月计划、4-周计划
    private Long sourceId; // 来源单据主键
    private Long sourceBid; // 来源单据明细主键
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date planStart; // 计划开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date planFinish; // 计划完成日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date estimateFinish; // 预计完成日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date predictStart; // 预测开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private Date predictFinish; // 预测完成日期
    private BigDecimal finishNum; // 已完成量
    private Integer finishState; // 完成状态，0-未完成，1-已完成，2-进行中
    private Integer lightType; // 亮灯，0-蓝，1-黄，2-红，3-紫灯
    private BigDecimal diffValue; // 偏差值
    private Long diffType; // 偏差原因类型 劳动力、材料、机械、内部原因、甲方原因、政府原因
    private String diffResson; // 偏差原因
    private BigDecimal resourceNum; // 实际资源量
    private BigDecimal diffNum; // 资源偏差
    private String bimIds; // 关联ID集合
//    private String bimDetailIds; // 关联明细主键集合
    private Integer state; // 是否关联进度 0-未关联，1-已关联
    private String content;// 逾期任务提示
    private String structName;// 结构名称
    private Integer predictDuration;// 预测工期
    private String projectName; // 项目名称
    private Long totalPlanId; // 总计划主键

    private List<ExecPlanDetailVO> children = new ArrayList<>();// 子任务


    public List<ExecPlanDetailVO> getChildren() {
        return children;
    }

    public void setChildren(List<ExecPlanDetailVO> children) {
        this.children = children;
    }
    

    public Integer getTaskLine() {
        return taskLine;
    }

    public void setTaskLine(Integer taskLine) {
        this.taskLine = taskLine;
    }
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }
    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }
    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }
    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }
    public Integer getTypeUnit() {
        return typeUnit;
    }

    public void setTypeUnit(Integer typeUnit) {
        this.typeUnit = typeUnit;
    }
    public BigDecimal getNeedNum() {
        return needNum;
    }

    public void setNeedNum(BigDecimal needNum) {
        this.needNum = needNum;
    }
    public String getPercentTask() {
        return percentTask;
    }

    public void setPercentTask(String percentTask) {
        this.percentTask = percentTask;
    }
    public Integer getPlanState() {
        return planState;
    }

    public void setPlanState(Integer planState) {
        this.planState = planState;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceBid() {
        return sourceBid;
    }

    public void setSourceBid(Long sourceBid) {
        this.sourceBid = sourceBid;
    }
    public Date getPlanStart() {
        return planStart;
    }

    public void setPlanStart(Date planStart) {
        this.planStart = planStart;
    }
    public Date getPlanFinish() {
        return planFinish;
    }

    public void setPlanFinish(Date planFinish) {
        this.planFinish = planFinish;
    }
    public Date getPredictStart() {
        return predictStart;
    }

    public void setPredictStart(Date predictStart) {
        this.predictStart = predictStart;
    }
    public BigDecimal getFinishNum() {
        return finishNum;
    }

    public void setFinishNum(BigDecimal finishNum) {
        this.finishNum = finishNum;
    }
    public Integer getFinishState() {
        return finishState;
    }

    public void setFinishState(Integer finishState) {
        this.finishState = finishState;
    }

    public Integer getLightType() {
        return lightType;
    }

    public void setLightType(Integer lightType) {
        this.lightType = lightType;
    }

    public Date getPredictFinish() {
        return predictFinish;
    }

    public void setPredictFinish(Date predictFinish) {
        this.predictFinish = predictFinish;
    }
    public BigDecimal getDiffValue() {
        return diffValue;
    }

    public void setDiffValue(BigDecimal diffValue) {
        this.diffValue = diffValue;
    }

    public Date getEstimateFinish() {
        return estimateFinish;
    }

    public void setEstimateFinish(Date estimateFinish) {
        this.estimateFinish = estimateFinish;
    }

    public Long getDiffType() {
        return diffType;
    }

    public void setDiffType(Long diffType) {
        this.diffType = diffType;
    }

    public String getDiffResson() {
        return diffResson;
    }

    public void setDiffResson(String diffResson) {
        this.diffResson = diffResson;
    }

    public BigDecimal getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(BigDecimal resourceNum) {
        this.resourceNum = resourceNum;
    }

    public BigDecimal getDiffNum() {
        return diffNum;
    }

    public void setDiffNum(BigDecimal diffNum) {
        this.diffNum = diffNum;
    }

    public String getBimIds() {
        return bimIds;
    }

    public void setBimIds(String bimIds) {
        this.bimIds = bimIds;
    }

//    public String getBimDetailIds() {
//        return bimDetailIds;
//    }
//
//    public void setBimDetailIds(String bimDetailIds) {
//        this.bimDetailIds = bimDetailIds;
//    }

    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getStructName() {
        return structName;
    }

    public void setStructName(String structName) {
        this.structName = structName;
    }

    public Integer getPredictDuration() {
        return predictDuration;
    }

    public void setPredictDuration(Integer predictDuration) {
        this.predictDuration = predictDuration;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getTotalPlanId() {
        return totalPlanId;
    }

    public void setTotalPlanId(Long totalPlanId) {
        this.totalPlanId = totalPlanId;
    }
}
