package com.ejianc.business.progress.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 风险纠偏
 * 
 * @author generator
 * 
 */
public class RiskCorrectionVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long yearId; // 年计划主键
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 所属组织
    private String parentOrgCode; // 所属组织编码
    private String parentOrgName; // 所属组织名称
    private Long corpId; // 区域公司
    private String corpCode; // 区域公司编码
    private String corpName; // 区域公司名称
    private String planYear; // 计划年度
    private Long yearBid; // 节点主键
    private Long employeeId; // 负责人主键
    private String employeeName; // 负责人名称
    private java.math.BigDecimal diffValue; // 偏差值
    private String yearBname; // 节点名称
    private Integer nodeLevel; // 节点次级
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date correctionDate; // 纠偏日期
    private String lagReasons; // 滞后原因说明
    private String correctionMeasures; // 纠偏措施
    private String supplement; // 补充说明
    private Integer billState; // 单据状态
    private Integer correctionType; // 纠偏方式(0-项目自行解决，1-二级单位处理，2-工程局处理)
    private String handleStatus; // 处理状态：0-待受理，1-待纠偏，2-纠偏中，3-已完成
    private Long topOrgId; // 二级单位id
    private String topOrgName; // 二级单位名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastUpdateTime; // 最近更新时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime; // 纠偏开始时间（审批通过时间）
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date finishTime; // 完成时间
    private Long acceptUserId; // 受理人id
    private String acceptUserName; // 受理人名称
    private Long drawUserId; // 提请人id
    private String drawUserName; // 提请人名称
    private String drawExplain; // 提请说明
    private String returnExplain; // 退回说明
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date minTime; // 未完成最小时间
    private Integer surplusDay; // 纠偏剩余时间/天
    private Integer take; // 纠偏历时
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date acceptTime; // 受理时间
    private Long finishUserId; // 完成人id
    private String finishUserName; // 完成人名称
    private Long drawOrgId; // 提请组织id
    private String drawOrgName; // 提请组织名称
    private String lagReasonId; // 滞后原因,自定义档案
    private Long projectControlLevel;

    private List<RiskCorrectionDetailVO> detailList = new ArrayList<>(); // 风险纠偏清单实体

    private List<RiskCorrectionHistoryVO> historyList = new ArrayList<>(); // 风险纠偏历史

    @ReferSerialTransfer(referCode = "support-defdoc")
    public String getLagReasonId() {
        return lagReasonId;
    }
    @ReferDeserialTransfer
    public void setLagReasonId(String lagReasonId) {
        this.lagReasonId = lagReasonId;
    }

    /**
     * 年计划主键
     */
    @ReferSerialTransfer(referCode="exec-plan")
    public Long getYearId() {
        return yearId;
    }

    /**
     * 年计划主键
     */
    @ReferDeserialTransfer
    public void setYearId(Long yearId) {
        this.yearId = yearId;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 计划年度
     */
    public String getPlanYear() {
        return planYear;
    }

    /**
     * 计划年度
     */
    public void setPlanYear(String planYear) {
        this.planYear = planYear;
    }
    /**
     * 节点主键
     */
    @ReferSerialTransfer(referCode="exec-paln-detail")
    public Long getYearBid() {
        return yearBid;
    }

    /**
     * 节点主键
     */
    @ReferDeserialTransfer
    public void setYearBid(Long yearBid) {
        this.yearBid = yearBid;
    }
    /**
     * 负责人主键
     */
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 负责人主键
     */
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 负责人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 负责人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 偏差值
     */
    public java.math.BigDecimal getDiffValue() {
        return diffValue;
    }

    /**
     * 偏差值
     */
    public void setDiffValue(java.math.BigDecimal diffValue) {
        this.diffValue = diffValue;
    }
    /**
     * 节点名称
     */
    public String getYearBname() {
        return yearBname;
    }

    /**
     * 节点名称
     */
    public void setYearBname(String yearBname) {
        this.yearBname = yearBname;
    }

    /**
     * 节点次级
     */
    public Integer getNodeLevel() {
        return nodeLevel;
    }

    /**
     * 节点次级
     */
    public void setNodeLevel(Integer nodeLevel) {
        this.nodeLevel = nodeLevel;
    }

    /**
     * 纠偏日期
     */
    public Date getCorrectionDate() {
        return correctionDate;
    }

    /**
     * 纠偏日期
     */
    public void setCorrectionDate(Date correctionDate) {
        this.correctionDate = correctionDate;
    }
    /**
     * 滞后原因说明
     */
    public String getLagReasons() {
        return lagReasons;
    }

    /**
     * 滞后原因说明
     */
    public void setLagReasons(String lagReasons) {
        this.lagReasons = lagReasons;
    }
    /**
     * 纠偏措施
     */
    public String getCorrectionMeasures() {
        return correctionMeasures;
    }

    /**
     * 纠偏措施
     */
    public void setCorrectionMeasures(String correctionMeasures) {
        this.correctionMeasures = correctionMeasures;
    }
    /**
     * 补充说明
     */
    public String getSupplement() {
        return supplement;
    }

    /**
     * 补充说明
     */
    public void setSupplement(String supplement) {
        this.supplement = supplement;
    }
    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getCorrectionType() {
        return correctionType;
    }

    public void setCorrectionType(Integer correctionType) {
        this.correctionType = correctionType;
    }

    public String getHandleStatus() {
        return handleStatus;
    }

    public void setHandleStatus(String handleStatus) {
        this.handleStatus = handleStatus;
    }

    public Long getTopOrgId() {
        return topOrgId;
    }

    public void setTopOrgId(Long topOrgId) {
        this.topOrgId = topOrgId;
    }

    public String getTopOrgName() {
        return topOrgName;
    }

    public void setTopOrgName(String topOrgName) {
        this.topOrgName = topOrgName;
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public Long getAcceptUserId() {
        return acceptUserId;
    }

    public void setAcceptUserId(Long acceptUserId) {
        this.acceptUserId = acceptUserId;
    }

    public String getAcceptUserName() {
        return acceptUserName;
    }

    public void setAcceptUserName(String acceptUserName) {
        this.acceptUserName = acceptUserName;
    }

    public Long getDrawUserId() {
        return drawUserId;
    }

    public void setDrawUserId(Long drawUserId) {
        this.drawUserId = drawUserId;
    }

    public String getDrawUserName() {
        return drawUserName;
    }

    public void setDrawUserName(String drawUserName) {
        this.drawUserName = drawUserName;
    }

    public String getDrawExplain() {
        return drawExplain;
    }

    public void setDrawExplain(String drawExplain) {
        this.drawExplain = drawExplain;
    }

    public String getReturnExplain() {
        return returnExplain;
    }

    public void setReturnExplain(String returnExplain) {
        this.returnExplain = returnExplain;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Date getMinTime() {
        return minTime;
    }

    public void setMinTime(Date minTime) {
        this.minTime = minTime;
    }

    public Integer getSurplusDay() {
        return surplusDay;
    }

    public void setSurplusDay(Integer surplusDay) {
        this.surplusDay = surplusDay;
    }

    public Integer getTake() {
        return take;
    }

    public void setTake(Integer take) {
        this.take = take;
    }

    public Date getAcceptTime() {
        return acceptTime;
    }

    public void setAcceptTime(Date acceptTime) {
        this.acceptTime = acceptTime;
    }

    /**
     * 完成人id
     */
    public Long getFinishUserId() {
        return finishUserId;
    }

    /**
     * 完成人id
     */
    public void setFinishUserId(Long finishUserId) {
        this.finishUserId = finishUserId;
    }

    /**
     * 完成人名称
     */
    public String getFinishUserName() {
        return finishUserName;
    }

    /**
     * 完成人名称
     */
    public void setFinishUserName(String finishUserName) {
        this.finishUserName = finishUserName;
    }

    /**
     * 提请组织id
     */
    public Long getDrawOrgId() {
        return drawOrgId;
    }

    /**
     * 提请组织id
     */
    public void setDrawOrgId(Long drawOrgId) {
        this.drawOrgId = drawOrgId;
    }

    /**
     * 提请组织名称
     */
    public String getDrawOrgName() {
        return drawOrgName;
    }

    /**
     * 提请组织名称
     */
    public void setDrawOrgName(String drawOrgName) {
        this.drawOrgName = drawOrgName;
    }

    public List<RiskCorrectionDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<RiskCorrectionDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<RiskCorrectionHistoryVO> getHistoryList() {
        return historyList;
    }

    public void setHistoryList(List<RiskCorrectionHistoryVO> historyList) {
        this.historyList = historyList;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getCorpId() {
        return corpId;
    }

    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }

    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }
    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }
}
