package com.ejianc.business.plan.cons;

import java.util.HashMap;
import java.util.Map;

public class PlanConstant {

    /**
     * 布尔是否
     */
    public static final Integer INTEGER_NO = 0;
    public static final Integer INTEGER_YES = 1;
    public static final String STRING_NO = "0";
    public static final String STRING_YES = "1";
    /**
     * 变更状态(1-未变更 2-变更中 3-已变更)
     */
    public static final Integer CHANGE_NO = 1;
    public static final Integer CHANGE_ING = 2;
    public static final Integer CHANGE_OVER = 3;
    public static final Map<Integer, String> CHANGE_STATUS = new HashMap();

    static {
        CHANGE_STATUS.put(CHANGE_NO, "未变更");
        CHANGE_STATUS.put(CHANGE_ING, "变更中");
        CHANGE_STATUS.put(CHANGE_OVER, "已变更");
    }

    /**
     * 变更原因(1-业主方原因，2-材料供应，3-劳动力短缺，4-天气原因，5-外部环境)
     */
    public static final Integer REASON_OWENR = 1;
    public static final Integer REASON_MATERIAL_SUPPLY = 2;
    public static final Integer REASON_LABOR_SHORTAGE = 3;
    public static final Integer REASON_WEATHER = 4;
    public static final Integer REASON_EXTERNAL_ENVIRONMENT = 5;
    public static final Map<Integer, String> CHANGE_REASON = new HashMap();

    static {
        CHANGE_REASON.put(REASON_OWENR, "业主方原因");
        CHANGE_REASON.put(REASON_MATERIAL_SUPPLY, "材料供应");
        CHANGE_REASON.put(REASON_LABOR_SHORTAGE, "劳动力短缺");
        CHANGE_REASON.put(REASON_WEATHER, "天气原因");
        CHANGE_REASON.put(REASON_EXTERNAL_ENVIRONMENT, "外部环境");
    }

    /**
     * 任务模式， 0：自动 ， 1： 手动
     */
    public static final Integer AUTOMATIC = 0;
    public static final Integer MANUAL_CONTROL = 1;
    public static final Map<Integer, String> MANUAL = new HashMap();

    static {
        MANUAL.put(AUTOMATIC, "自动");
        MANUAL.put(MANUAL_CONTROL, "手动");
    }
    /**
     * 任务限制类型
     */
    /**
     * 重要级别
     */

    /**
     * 任务条线(手续线、设计线、建造线、招采线)
     */
    public static final Integer LINE_FORMALITIES = 0;
    public static final Integer LINE_DESIGN = 1;
    public static final Integer LINE_BUILD = 2;
    public static final Integer LINE_RECRUIT = 3;
    public static final Map<Integer, String> TASK_LINE = new HashMap();

    static {
        TASK_LINE.put(LINE_FORMALITIES, "手续线");
        TASK_LINE.put(LINE_DESIGN, "设计线");
        TASK_LINE.put(LINE_BUILD, "建造线");
        TASK_LINE.put(LINE_RECRUIT, "招采线");
    }

    /**
     * 节点级别(一级节点、二级节点、三级节点、合同节点)
     */
    public static final Integer LEVEL_FIRST = 1;
    public static final Integer LEVEL_SECOND = 2;
    public static final Integer LEVEL_THIRD = 3;
    public static final Integer LEVEL_CONTRACT = 4;
    public static final Map<Integer, String> NODE_LEVEL = new HashMap();

    static {
        NODE_LEVEL.put(LEVEL_FIRST, "一级节点");
        NODE_LEVEL.put(LEVEL_SECOND, "二级节点");
        NODE_LEVEL.put(LEVEL_THIRD, "三级节点");
        NODE_LEVEL.put(LEVEL_CONTRACT, "合同节点");
    }

    /**
     * 单位(枚举格式， 包含：㎡、m、m3、kg、t、个)
     */
    public static final Integer UNIT_SQUARE_METER = 0;
    public static final Integer UNIT_METER = 1;
    public static final Integer UNIT_CUBIC_METER = 2;
    public static final Integer UNIT_KG = 3;
    public static final Integer UNIT_TON = 4;
    public static final Integer UNIT_PIECE = 5;
    public static final Map<Integer, String> UNIT = new HashMap();

    static {
        UNIT.put(UNIT_SQUARE_METER, "m2");
        UNIT.put(UNIT_METER, "m");
        UNIT.put(UNIT_CUBIC_METER, "m3");
        UNIT.put(UNIT_KG, "kg");
        UNIT.put(UNIT_TON, "t");
        UNIT.put(UNIT_PIECE, "个");
    }

    /**
     * 资源类型(劳动力、材料、机械)
     */
    public static final Integer RESOURCE_LABOR_FORCE = 0;
    public static final Integer RESOURCE_MATERIAL = 1;
    public static final Integer RESOURCE_MECHANICAL = 2;
    public static final Map<Integer, String> RESOURCE_TYPE = new HashMap();

    static {
        RESOURCE_TYPE.put(RESOURCE_LABOR_FORCE, "劳动力");
        RESOURCE_TYPE.put(RESOURCE_MATERIAL, "材料");
        RESOURCE_TYPE.put(RESOURCE_MECHANICAL, "机械");
    }

    /**
     * 资源单位(㎡、m、m3、kg、t、个、台班、工日)
     */
    public static final Integer RESOURCE_UNIT_SQUARE_METER = 0;
    public static final Integer RESOURCE_UNIT_METER = 1;
    public static final Integer RESOURCE_UNIT_CUBIC_METER = 2;
    public static final Integer RESOURCE_UNIT_KG = 3;
    public static final Integer RESOURCE_UNIT_TON = 4;
    public static final Integer RESOURCE_UNIT_PIECE = 5;
    public static final Integer RESOURCE_UNIT_TAIWAN_CLASS = 6;
    public static final Integer RESOURCE_UNIT_WORKING_DAY = 7;
    public static final Map<Integer, String> RESOURCE_UNIT = new HashMap();

    static {
        RESOURCE_UNIT.put(RESOURCE_UNIT_SQUARE_METER, "m2");
        RESOURCE_UNIT.put(RESOURCE_UNIT_METER, "m");
        RESOURCE_UNIT.put(RESOURCE_UNIT_CUBIC_METER, "m3");
        RESOURCE_UNIT.put(RESOURCE_UNIT_KG, "kg");
        RESOURCE_UNIT.put(RESOURCE_UNIT_TON, "t");
        RESOURCE_UNIT.put(RESOURCE_UNIT_PIECE, "个");
        RESOURCE_UNIT.put(RESOURCE_UNIT_TAIWAN_CLASS, "台班");
        RESOURCE_UNIT.put(RESOURCE_UNIT_WORKING_DAY, "工日");
    }

    /**
     * 日进度反馈
     */
    public static final Integer DAY_FILL = 11;

    /**
     * 任务标识(1-总计划、2-年计划、3-月计划、4-周计划)
     */
    public static final Integer TOTAL_PLAN = 1;
    public static final Integer YEAR_PLAN = 2;
    public static final Integer MONTH_PLAN = 3;
    public static final Integer WEEK_PLAN = 4;
    public static final Map<Integer, String> TASK_PLAN = new HashMap();

    static {
        TASK_PLAN.put(TOTAL_PLAN, "total");
        TASK_PLAN.put(YEAR_PLAN, "year");
        TASK_PLAN.put(MONTH_PLAN, "month");
        TASK_PLAN.put(WEEK_PLAN, "week");
    }

    /**
     * 变更类型,0-未变更,1-已变更,2-新增项，3-已删除
     */
    public static final Integer CHANGE_TYPE_NO = 0;
    public static final Integer CHANGE_TYPE_OVER = 1;
    public static final Integer CHANGE_TYPE_ADD = 2;
    public static final Integer CHANGE_TYPE_DEL = 3;
    public static final Map<Integer, String> CHANGE_TYPE = new HashMap();

    static {
        CHANGE_TYPE.put(CHANGE_TYPE_NO, "未变更");
        CHANGE_TYPE.put(CHANGE_TYPE_OVER, "已变更");
        CHANGE_TYPE.put(CHANGE_TYPE_ADD, "新增项");
        CHANGE_TYPE.put(CHANGE_TYPE_DEL, "已删除");
    }

    /**
     * 偏差原因类型,0-劳动力、1-材料、2-机械、3-内部原因、4-甲方原因、5-政府原因
     */
    public static final Integer DIFF_TYPE_LABOR = 0;
    public static final Integer DIFF_TYPE_MATERIAL = 1;
    public static final Integer DIFF_TYPE_MECHANICAL = 2;
    public static final Integer DIFF_TYPE_INSIDE = 3;
    public static final Integer DIFF_TYPE_PARTY_A = 4;
    public static final Integer DIFF_TYPE_GOVERNMENT = 5;
    public static final Map<Integer, String> DIFF_TYPE = new HashMap();

    static {
        DIFF_TYPE.put(DIFF_TYPE_LABOR, "劳动力");
        DIFF_TYPE.put(DIFF_TYPE_MATERIAL, "材料");
        DIFF_TYPE.put(DIFF_TYPE_MECHANICAL, "机械");
        DIFF_TYPE.put(DIFF_TYPE_INSIDE, "内部原因");
        DIFF_TYPE.put(DIFF_TYPE_PARTY_A, "甲方原因");
        DIFF_TYPE.put(DIFF_TYPE_GOVERNMENT, "政府原因");
    }

    /**
     * 亮灯(绿灯、蓝灯、黄灯、红灯、紫灯)
     */
    public static final Integer LIGHT_GREEN = -1;
    public static final Integer LIGHT_BLUE = 0;
    public static final Integer LIGHT_YELLOW = 1;
    public static final Integer LIGHT_RED = 2;
    public static final Integer LIGHT_PURPLE = 3;
    public static final Map<Integer, String> LIGHT_TYPE = new HashMap();

    static {
        LIGHT_TYPE.put(LIGHT_GREEN, "绿灯");
        LIGHT_TYPE.put(LIGHT_BLUE, "蓝灯");
        LIGHT_TYPE.put(LIGHT_YELLOW, "黄灯");
        LIGHT_TYPE.put(LIGHT_RED, "红灯");
        LIGHT_TYPE.put(LIGHT_PURPLE, "紫灯");
    }

    /**
     * 总计划单据类型，附件类型
     */
    public static final String TOTAL_PLAN_BILL_TYPE = "EJCBT202206000012";
    public static final String TOTAL_PLAN_CHANGE_BILL_TYPE = "EJCBT202206000018";
    public static final String TOTAL_PLAN_SOURCE_TYPE = "zjkjTotalPlan";
    public static final String TOTAL_PLAN_CHANGE_SOURCE_TYPE = "zjkjTotalPlanChange";

    /**
     * 年计划单据类型，附件类型
     */
    public static final String YEAR_PLAN_BILL_TYPE = "EJCBT202206000014";
    public static final String YEAR_PLAN_CHANGE_BILL_TYPE = "EJCBT202206000021";
    public static final String YEAR_PLAN_SOURCE_TYPE = "zjkjYearPlan";
    public static final String YEAR_PLAN_CHANGE_SOURCE_TYPE = "zjkjYearPlanChange";

    /**
     * 月计划单据类型，附件类型
     */
    public static final String MONTH_PLAN_BILL_TYPE = "EJCBT202206000019";
    public static final String MONTH_PLAN_CHANGE_BILL_TYPE = "EJCBT202206000020";
    public static final String MONTH_PLAN_SOURCE_TYPE = "zjkjMonthPlan";
    public static final String MONTH_PLAN_CHANGE_SOURCE_TYPE = "zjkjMonthPlanChange";


}
