package com.ejianc.business.progress.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.progress.hystrix.IProgressHystrix;
import com.ejianc.business.progress.vo.ProgressFilterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2023/10/26 15:46
 */
@FeignClient(
        name = "ejc-zjkjprogress-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-zjkjprogress-web",
        fallback = IProgressHystrix.class
)
public interface IProgressApi {

    /**
     * 查询项目
     *
     * @param progressFilterVO
     * @return
     */
    @PostMapping(value = "/api/progress/getProjectProgress")
    CommonResponse<List<JSONObject>> getProjectProgress(@RequestBody ProgressFilterVO progressFilterVO);

}
