package com.ejianc.business.progress.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.JSONArray;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class ProgressDetailVO implements Serializable {

	private static final long serialVersionUID = 1L;

	@JsonProperty(value = "UID")
	private String uid;// 任务主键

	@JsonProperty(value = "Manual")
	private Integer manual;// 任务模式， 0：自动 ， 1： 手动

	@JsonProperty(value = "ActualDuration")
	private Integer actualDuration;// 实际工期

	@JsonProperty(value = "Duration")
	private Integer duration;// 工期

	@JsonProperty(value = "PercentComplete")
	private Integer percentComplete;// 完成百分比

	@JsonProperty(value = "Department")
	private String department;// 所属部门。如"1"。

	@JsonProperty(value = "ProjectUID")
	private Long projectUID;// 项目ID

	@JsonProperty(value = "Milestone")
	private Integer milestone;// 里程碑

	@JsonProperty(value = "Finish")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
	private Date finish;// 完成日期

	@JsonProperty(value = "ConstraintType")
	private Integer constraintType;// 任务限制类型。

	@JsonProperty(value = "Principal")
	private String principal;// 负责人。如"101,220,201"。

	@JsonProperty(value = "ParentTaskUID")
	private String parentTaskUID;// 父任务UID（体现树形结构）

	@JsonProperty(value = "WBS")
	private String wbs;// wbs

	@JsonProperty(value = "Assignments")
	private JSONArray assignments;// 资源名称

	@JsonProperty(value = "Start")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
	private Date start;// 开始日期

	@JsonProperty(value = "OutlineLevel")
	private Integer outlineLevel;// 层级

	@JsonProperty(value = "OutlineNumber")
	private String outlineNumber;// 序列号

	@JsonProperty(value = "Critical")
	private Integer critical;// 关键任务

	@JsonProperty(value = "Note")
	private String note;// 备注

	@JsonProperty(value = "Summary")
	private Integer summary;// 摘要任务

	@JsonProperty(value = "ActualFinish")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
	private Date actualFinish;// 实际完成时间

	@JsonProperty(value = "Name")
	private String name;// 任务名称

	@JsonProperty(value = "ID")
	private Integer id;// 序号

	private String code;// 编码

	private String structCode;// 结构码

	@JsonProperty(value = "Weight")
	private Integer weight;// 权重

	@JsonProperty(value = "FixedDate")
	private Integer fixedDate;// 是否固定日期（摘要任务专用）

	@JsonProperty(value = "Work")
	private Integer work;// 工时

	@JsonProperty(value = "ConstraintDate")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
	private Date constraintDate;// 任务限制日期

	@JsonProperty(value = "PredecessorLink")
	private JSONArray predecessorLink;// 前置任务（JSON字符串）。如"[{PredecessorUID: 2,Type: 1,LinkLag: 0}, ...]"

	@JsonProperty(value = "Priority")
	private Integer priority;// 重要级别

	@JsonProperty(value = "ActualStart")
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss")
	private Date actualStart;// 实际开始时间

	@JsonProperty(value = "_state")
	private String _state;// 行状态 added-新增 modified-编辑

	private List<ProgressDetailVO> children = new ArrayList<ProgressDetailVO>();// 子任务

	public String getUid() {
		return uid;
	}

	public void setUid(String uid) {
		this.uid = uid;
	}

	public Integer getManual() {
		return manual;
	}

	public void setManual(Integer manual) {
		this.manual = manual;
	}

	public Integer getActualDuration() {
		return actualDuration;
	}

	public void setActualDuration(Integer actualDuration) {
		this.actualDuration = actualDuration;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public Integer getPercentComplete() {
		return percentComplete;
	}

	public void setPercentComplete(Integer percentComplete) {
		this.percentComplete = percentComplete;
	}

	public String getDepartment() {
		return department;
	}

	public void setDepartment(String department) {
		this.department = department;
	}

	public Long getProjectUID() {
		return projectUID;
	}

	public void setProjectUID(Long projectUID) {
		this.projectUID = projectUID;
	}

	public Integer getMilestone() {
		return milestone;
	}

	public void setMilestone(Integer milestone) {
		this.milestone = milestone;
	}

	public Date getFinish() {
		return finish;
	}

	public void setFinish(Date finish) {
		this.finish = finish;
	}

	public Integer getConstraintType() {
		return constraintType;
	}

	public void setConstraintType(Integer constraintType) {
		this.constraintType = constraintType;
	}

	public String getPrincipal() {
		return principal;
	}

	public void setPrincipal(String principal) {
		this.principal = principal;
	}

	public String getParentTaskUID() {
		return parentTaskUID;
	}

	public void setParentTaskUID(String parentTaskUID) {
		this.parentTaskUID = parentTaskUID;
	}

	public String getWbs() {
		return wbs;
	}

	public void setWbs(String wbs) {
		this.wbs = wbs;
	}

	public JSONArray getAssignments() {
		return assignments;
	}

	public void setAssignments(JSONArray assignments) {
		this.assignments = assignments;
	}

	public Date getStart() {
		return start;
	}

	public void setStart(Date start) {
		this.start = start;
	}

	public Integer getOutlineLevel() {
		return outlineLevel;
	}

	public void setOutlineLevel(Integer outlineLevel) {
		this.outlineLevel = outlineLevel;
	}

	public String getOutlineNumber() {
		return outlineNumber;
	}

	public void setOutlineNumber(String outlineNumber) {
		this.outlineNumber = outlineNumber;
	}

	public Integer getCritical() {
		return critical;
	}

	public void setCritical(Integer critical) {
		this.critical = critical;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Integer getSummary() {
		return summary;
	}

	public void setSummary(Integer summary) {
		this.summary = summary;
	}

	public Date getActualFinish() {
		return actualFinish;
	}

	public void setActualFinish(Date actualFinish) {
		this.actualFinish = actualFinish;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getStructCode() {
		return structCode;
	}

	public void setStructCode(String structCode) {
		this.structCode = structCode;
	}

	public Integer getWeight() {
		return weight;
	}

	public void setWeight(Integer weight) {
		this.weight = weight;
	}

	public Integer getFixedDate() {
		return fixedDate;
	}

	public void setFixedDate(Integer fixedDate) {
		this.fixedDate = fixedDate;
	}

	public Integer getWork() {
		return work;
	}

	public void setWork(Integer work) {
		this.work = work;
	}

	public Date getConstraintDate() {
		return constraintDate;
	}

	public void setConstraintDate(Date constraintDate) {
		this.constraintDate = constraintDate;
	}

	public JSONArray getPredecessorLink() {
		return predecessorLink;
	}

	public void setPredecessorLink(JSONArray predecessorLink) {
		this.predecessorLink = predecessorLink;
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	public Date getActualStart() {
		return actualStart;
	}

	public void setActualStart(Date actualStart) {
		this.actualStart = actualStart;
	}

	public String get_state() {
		return _state;
	}

	public void set_state(String _state) {
		this._state = _state;
	}

	public List<ProgressDetailVO> getChildren() {
		return children;
	}

	public void setChildren(List<ProgressDetailVO> children) {
		this.children = children;
	}

}
