package com.ejianc.business.progress.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.progress.vo.PushSetReceiveVO;

/**
 * 推送设置层级实体
 * 
 * @author generator
 * 
 */
public class PushSetLevelVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long setId; // 设置主键
    private Integer level; // 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
    private String orgType; // 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
    
    private List<PushSetReceiveVO> receiveList = new ArrayList<>(); // 推送设置接收实体

    /**
     * 设置主键
     */
    public Long getSetId() {
        return setId;
    }

    /**
     * 设置主键
     */
    public void setSetId(Long setId) {
        this.setId = setId;
    }
    /**
     * 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
     */
    public Integer getLevel() {
        return level;
    }

    /**
     * 层级 1-一级节点，2-一级、二级节点，3-所有节点，4-节点纠偏
     */
    public void setLevel(Integer level) {
        this.level = level;
    }
    /**
     * 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
     */
    public String getOrgType() {
        return orgType;
    }

    /**
     * 消息推送组织 5、本组织；1、本集团；2、本分子公司；3、本经理部
     */
    public void setOrgType(String orgType) {
        this.orgType = orgType;
    }
    
     /**
      * 推送设置接收实体
      */
     public List<PushSetReceiveVO> getReceiveList() {
        return receiveList;
     }

     /**
      * 推送设置接收实体
      */
     public void setReceiveList(List<PushSetReceiveVO> receiveList) {
        this.receiveList = receiveList;
     }
}
