package com.ejianc.business.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 执行计划
 * 
 * @author generator
 * 
 */
public class ExecPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long projectId; // 项目
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long corpId; // 区域公司
    private String corpCode; // 区域公司编码
    private String corpName; // 区域公司名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planBeginDate; // 计划开始日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划结束日期
    private Long projectManagerId; // 项目经理主键
    private String projectManagerName; // 项目经理名称
    private Long projectControlLevel; // 项目管控级别(自定义档案)
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate; // 开工时间
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private String calendarUid; // 日历主键
    private String calendars; // 日历
    private Integer fillVersion;// 反馈版本
    private Date fillTime;// 反馈时间

    private List<ExecPlanDetailVO> allList = new ArrayList<ExecPlanDetailVO>();

    private List<ExecPlanDetailVO> progressDetailList = new ArrayList<ExecPlanDetailVO>();

    private List<ExecPlanDetailVO> removedTasks = new ArrayList<>();

    private List<ExecPlanDetailVO> tasks = new ArrayList<>();


    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getCorpId() {
        return corpId;
    }
    @ReferDeserialTransfer
    public void setCorpId(Long corpId) {
        this.corpId = corpId;
    }

    public String getCorpCode() {
        return corpCode;
    }

    public void setCorpCode(String corpCode) {
        this.corpCode = corpCode;
    }
    public String getCorpName() {
        return corpName;
    }

    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }
    public Date getPlanBeginDate() {
        return planBeginDate;
    }

    public void setPlanBeginDate(Date planBeginDate) {
        this.planBeginDate = planBeginDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagerId() {
        return projectManagerId;
    }

    @ReferDeserialTransfer
    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectControlLevel() {
        return projectControlLevel;
    }

    @ReferDeserialTransfer
    public void setProjectControlLevel(Long projectControlLevel) {
        this.projectControlLevel = projectControlLevel;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getCalendarUid() {
        return calendarUid;
    }

    public void setCalendarUid(String calendarUid) {
        this.calendarUid = calendarUid;
    }
    public String getCalendars() {
        return calendars;
    }

    public void setCalendars(String calendars) {
        this.calendars = calendars;
    }
    public Integer getFillVersion() {
        return fillVersion;
    }

    public void setFillVersion(Integer fillVersion) {
        this.fillVersion = fillVersion;
    }

    public Date getFillTime() {
        return fillTime;
    }

    public void setFillTime(Date fillTime) {
        this.fillTime = fillTime;
    }

    public List<ExecPlanDetailVO> getAllList() {
        return allList;
    }

    public void setAllList(List<ExecPlanDetailVO> allList) {
        this.allList = allList;
    }

    public List<ExecPlanDetailVO> getProgressDetailList() {
        return progressDetailList;
    }

    public void setProgressDetailList(List<ExecPlanDetailVO> progressDetailList) {
        this.progressDetailList = progressDetailList;
    }

    public List<ExecPlanDetailVO> getRemovedTasks() {
        return removedTasks;
    }

    public void setRemovedTasks(List<ExecPlanDetailVO> removedTasks) {
        this.removedTasks = removedTasks;
    }

    public List<ExecPlanDetailVO> getTasks() {
        return tasks;
    }

    public void setTasks(List<ExecPlanDetailVO> tasks) {
        this.tasks = tasks;
    }
}
