package com.ejianc.business.bim.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bim.bean.BimDetailEntity;
import com.ejianc.business.bim.bean.BimDetailExecEntity;
import com.ejianc.business.bim.bean.BimEntity;
import com.ejianc.business.bim.helper.CacheHelper;
import com.ejianc.business.bim.helper.TokenHelper;
import com.ejianc.business.bim.service.IBimDetailExecService;
import com.ejianc.business.bim.service.IBimDetailService;
import com.ejianc.business.bim.service.IBimService;
import com.ejianc.business.bim.vo.BimConnectVO;
import com.ejianc.business.bim.vo.BimDetailVO;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * BIM模型
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("bim")
public class BimController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "ZJKJ_BIM_CODE";//此处需要根据实际修改

    @Autowired
    private IBimService service;

    @Autowired
    private IBimDetailService detailService;

    @Autowired
    private IBimDetailExecService bimExecService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BimVO> saveOrUpdate(@RequestBody BimVO saveOrUpdateVO) {
        BimVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BimVO> queryDetail(Long id) {
        BimVO vo = service.syncDetail(id);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryByProjectId 根据项目查询详情
     * @param projectId
     */
    @RequestMapping(value = "/queryByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BimVO> queryByProjectId(Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        BimEntity entity = service.queryList(queryParam).stream().findAny().orElse(null);
        if(entity == null){
            return CommonResponse.error("未查询到该项目下BIM模型！");
        }
        entity = service.selectById(entity.getId());
        BimVO vo = BeanMapper.map(entity, BimVO.class);
        for(BimDetailVO detail : vo.getDetailList()){
            if(detail.getStatus() == 1){
                detail.setViewerToken(service.getViewerToken(detail.getModleId(), detail.getPath()));
            }
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BimVO> vos) {
        Long orgId = InvocationInfoProxy.getOrgId();
        List<Long> ids = vos.stream().map(BimVO::getId).collect(Collectors.toList());
        Collection<BimEntity> list = service.listByIds(ids);
        for(BimEntity entity : list){
            if(!orgId.equals(entity.getOrgId())){
                return CommonResponse.error("没有删除权限！");
            }
        }
        // 同步删除大象云模型列表
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("bimId", new Parameter(QueryParam.IN, ids));
        List<BimDetailEntity> detaiList = detailService.queryList(queryParam);
        service.removeByIds(ids,true);
//        List<String> delPaths = detaiList.stream().map(BimDetailEntity::getPath).collect(Collectors.toList());
//        for(String path : delPaths){
//            TokenHelper.delFile(path);
//        }
        List<String> delPaths = detaiList.stream().filter(x->StringUtils.isNotEmpty(x.getModleId())).map(BimDetailEntity::getModleId).collect(Collectors.toList());
        TokenHelper.delFileBatch(delPaths.toArray(new String[0]));

        // 同步删除bim关联关系
        List<Long> delIds = detaiList.stream().map(BimDetailEntity::getId).collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(delIds)){
            QueryWrapper<BimDetailExecEntity> wrapper = new QueryWrapper<>();
            wrapper.in("bim_detail_id", delIds);
            bimExecService.remove(wrapper);
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BimVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
//        fuzzyFields.add("createUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BimEntity> page = service.queryPage(param,false);
        IPage<BimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BimVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BimEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Bim-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refBimData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BimVO>> refBimData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BimEntity> page = service.queryPage(param,false);
        IPage<BimVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BimVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 获取大象云token
     * @Return void
     */
    @RequestMapping(value = "/getToken", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getToken() {
        Object token = CacheHelper.get(TokenHelper.TOKEN);
        if(token == null){
            TokenHelper.getTokenData();
            token = CacheHelper.get(TokenHelper.TOKEN);
            return CommonResponse.success("查询成功！", String.valueOf(token));
        }
        JSONObject json = TokenHelper.getTokenExpiry(String.valueOf(token));
        if(json != null && json.containsKey("code") && json.getInteger("code") != 0){
            TokenHelper.getTokenData();
            token = CacheHelper.get(TokenHelper.TOKEN);
        }
        return CommonResponse.success("查询成功！", String.valueOf(token));
    }

    /**
     * @Description 获取大象云Viewer Token
     * @Return void
     */
    @RequestMapping(value = "/getViewerToken", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getViewerToken(@RequestParam("fileId") String fileId, @RequestParam("path") String path) {
        return CommonResponse.success("查询成功！", service.getViewerToken(fileId, path));
    }

    /**
     * @Description 获取asm文件子模型列表
     * @Return void
     */
    @RequestMapping(value = "/getViewerModel", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONArray> getViewerModel(@RequestParam("fileId") String fileId, @RequestParam("path") String path) {
        JSONObject json = TokenHelper.getFile(fileId, path);
        return CommonResponse.success("查询成功！", json.getJSONArray("refs"));
    }

    /**
     * @Description 校验模型名称
     * @Return void
     */
    @RequestMapping(value = "/getFileCheck", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getFileCheck(@RequestParam("fileName") String fileName, @RequestParam("parentId") String parentId) {
        JSONObject json = TokenHelper.getFileCheck(fileName, parentId);
        return CommonResponse.success("查询成功！", json.getJSONObject("data"));
    }

    /**
     * @Description 获取大象云图元id对应关系
     * @Return void
     */
    @RequestMapping(value = "/getHiddenItems", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> getHiddenItems(@RequestBody BimQureyVO queryVO) {
        return CommonResponse.success("查询成功！", service.getHiddenItems(queryVO));
    }

    /**
     * @Description connect 关联
     */
    @RequestMapping(value = "/connect", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> connect(@RequestBody BimConnectVO vo) {
        return CommonResponse.success(vo.getState() ? "关联成功！" : "取消关联成功！", service.connect(vo));
    }

    /**
     * @Description connect 一键取消关联
     */
    @RequestMapping(value = "/oneUnConnect", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> oneUnConnect(@RequestParam Long bimDetailId) {
        return CommonResponse.success("取消关联成功！", service.oneUnConnect(bimDetailId));
    }

    /**
     * 批量下載文件
     *
     * @param vos
     * @param response
     */
    @RequestMapping(value = "/batchDownload", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> batchDownload(@RequestBody List<BimDetailVO> vos, HttpServletResponse response) {
        return CommonResponse.success("批量下載文件成功！", service.batchDownload(vos, response));
    }

    /**
     * @Description connect 设置主视图
     */
    @RequestMapping(value = "/setCamera", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> setCamera(@RequestBody JSONObject json) {
        Long projectId = json.getLong("projectId");
        String path = json.getString("path");
        String camera = json.getString("camera");
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<BimEntity> bimList = service.queryList(param);
        if(CollectionUtils.isEmpty(bimList)){
            throw new BusinessException("未查询到该项目下BIM！");
        }
        BimEntity bim = service.selectById(bimList.get(0).getId());
        BimDetailEntity detail = bim.getDetailList().stream().filter(x->x.getPath().equals(path)).findAny().orElse(null);
        if(detail == null){
            throw new BusinessException("未查询到该模型文件！");
        }
        detail.setCamera(camera);
        detailService.saveOrUpdate(detail);
        return CommonResponse.success("设置成功！", true);
    }

    /**
     * @Description connect 设置主视图
     */
    @RequestMapping(value = "/getCamera", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> getCamera(@RequestParam("projectId")Long projectId, @RequestParam("path")String path) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
        List<BimEntity> bimList = service.queryList(param);
        if(CollectionUtils.isEmpty(bimList)){
            throw new BusinessException("未查询到该项目下BIM！");
        }
        BimEntity bim = service.selectById(bimList.get(0).getId());
        BimDetailEntity detail = bim.getDetailList().stream().filter(x->x.getPath().equals(path)).findAny().orElse(null);
        if(detail == null){
            throw new BusinessException("未查询到该模型文件！");
        }
        return CommonResponse.success("查询成功！", StringUtils.isNotEmpty(detail.getCamera()) ? detail.getCamera() : "");
    }

}
