package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.*;

/**
 * @author yqls
 * @date 2022-08-05 09:58:34
 */
public class HttpDelTookit extends HttpTookit {

    public static String deleteParameters(String url, String parameterStr)
            throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return delete(url, parameterStr, "application/x-www-form-urlencoded", charset, connTimeout, readTimeout, null);
    }

    public static String deleteByJson(String url, String parameterStr)
            throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return delete(url, parameterStr, "application/json", charset, connTimeout, readTimeout, null);
    }

    public static String deleteByJson(String url, Map<String, ?> params, Map<String, String> headers)
            throws ConnectTimeoutException, SocketTimeoutException, Exception {
        String parameterStr = JSONObject.toJSONString(params);
        return delete(url, parameterStr, "application/json", charset, connTimeout, readTimeout, headers);
    }

    public static String deleteByJson(String url, Map<String, String> params)
            throws ConnectTimeoutException, SocketTimeoutException, Exception {
        String parameterStr = JSONObject.toJSONString(params);
        return delete(url, parameterStr, "application/json", charset, connTimeout, readTimeout, null);
    }

    public static String deleteParameters(String url, Map<String, String> params)
            throws ConnectTimeoutException, SocketTimeoutException, Exception {
        return deleteForm(url, params, null, null, connTimeout, readTimeout);
    }

    /**
     * 发送一个 Post 请求, 使用指定的字符集编码.
     *
     * @param url
     * @param body
     *            RequestBody
     * @param mimeType
     *            例如 application/xml "application/x-www-form-urlencoded"
     *            a=1&b=2&c=3
     * @param charset
     *            编码
     * @param connTimeout
     *            建立链接超时时间,毫秒.
     * @param readTimeout
     *            响应超时时间,毫秒.
     * @return ResponseBody, 使用指定的字符集编码.
     * @throws ConnectTimeoutException
     *             建立链接超时异常
     * @throws SocketTimeoutException
     *             响应超时
     * @throws Exception
     */
    public static String delete(String url, String body, String mimeType, String charset, Integer connTimeout,
                              Integer readTimeout, Map<String, String> headers) throws ConnectTimeoutException, SocketTimeoutException, Exception {
        CloseableHttpClient client = null;
        HttpDeleteWithBody post = new HttpDeleteWithBody(url);
        HttpServletRequest request = null;
        String result = "";
        try {
            if (StringUtils.isNotBlank(body)) {
                HttpEntity entity = new StringEntity(body, ContentType.create(mimeType, charset));
                post.setEntity(entity);
            }
            // 设置参数
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }
            post.setConfig(customReqConf.build());
            if(null != headers) {
                String key = null;
                for(Iterator<String> it = headers.keySet().iterator(); it.hasNext();) {
                    key = it.next();
                    post.addHeader(key, headers.get(key));
                }
            }

            CloseableHttpResponse res;
            if (url.startsWith("https")) {
                // 执行 Https 请求.
                client = createSSLInsecureClient();
                res = client.execute(post);
            } else {
                // 执行 Http 请求.
                client = getClient();
                res = client.execute(post);
            }
            result = IOUtils.toString(res.getEntity().getContent(), charset);
            res.close();
        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient) client).close();
            }
        }
        return result;
    }

    /**
     * 提交form表单
     *
     * @param url
     * @param params
     * @param connTimeout
     * @param readTimeout
     * @return
     * @throws GeneralSecurityException
     * @throws IOException
     * @throws ClientProtocolException
     * @throws ConnectTimeoutException
     * @throws SocketTimeoutException
     * @throws Exception
     */
    public static String deleteForm(String url, Map<String, String> params, Map<String, String> headers,
                                  String contentType, Integer connTimeout, Integer readTimeout)
            throws GeneralSecurityException, ClientProtocolException, IOException {

        CloseableHttpClient client = null;
        HttpDeleteWithBody post = new HttpDeleteWithBody(url);
        try {
            if (params != null && !params.isEmpty()) {
                List<NameValuePair> formParams = new ArrayList<NameValuePair>();
                Set<Map.Entry<String, String>> entrySet = params.entrySet();
                for (Map.Entry<String, String> entry : entrySet) {
                    formParams.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                if (contentType != null)
                    entity.setContentType(contentType);
                post.setEntity(entity);
            }

            if (headers != null && !headers.isEmpty()) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    post.addHeader(entry.getKey(), entry.getValue());
                }
            }

            // 设置参数
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout);
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout);
            }
            post.setConfig(customReqConf.build());
            CloseableHttpResponse res = null;
            if (url.startsWith("https")) {
                // 执行 Https 请求.
                client = createSSLInsecureClient();
                res = client.execute(post);
            } else {
                // 执行 Http 请求.
                client = getClient();
                res = client.execute(post);
            }
            if (res.getStatusLine().getStatusCode() == 200) {
                return IOUtils.toString(res.getEntity().getContent(), "UTF-8");
            } else if (res.getStatusLine().getStatusCode() == 404) {
                throw new BusinessException("404, 不能连接到目标服务器!");
            }
            res.close();

        } finally {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient) client).close();
            }
        }
        return null;
    }

    private static CloseableHttpClient getClient(){
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        return HttpClients.custom().setConnectionManager(cm).build();
    }
}
