package com.ejianc.business.bim.helper;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @description JSON 处理辅助类
 * @author 宫清
 * @date 2019年7月20日 下午5:35:31
 * @since JDK1.7
 */
public class JSONHelper {

	private static Logger logger = null;

	private JSONHelper() {
	}

	/**
	 * @description 格式化json data数据
	 *
	 * @param json
	 * @return
	 * @throws BusinessException
	 * @author 宫清
	 * @date 2019年7月20日 下午5:34:38
	 */
	@SuppressWarnings("unchecked")
	public static <T> T castDataJson(JSONObject json, Class<T> clz) throws BusinessException {
		if(logger == null){
			logger = LoggerFactory.getLogger(JSONHelper.class);
		}
		logger.info("返回大象云查询结果：{}", json);
		Object obj = json.get("data");
		int code = json.getIntValue("code");
		if (code != 0 && obj == null) {
			logger.error(json.getString("message"));
		}
		JSONObject error = json.getJSONObject("error");
		if (error != null && error.getInteger("code") != 0){
			logger.error(error.getString("message"));
		}
		return (T)obj;
	}

	/**
	 * 去除多余转义符
	 * Content-Type: text/plain; charset=utf-8
	 * @param str
	 * @return
	 */
	public static String toJsonString(String str) {
		str = StringEscapeUtils.unescapeJavaScript(str);
		if(str.startsWith("\"")){
			str = str.substring(1, str.length()-1);
		}
		return str;
	}

	public static JSONObject parseObject(String content) {
		if(StringUtils.isBlank(content)) return null;
		try {
			JSONObject json = JSONObject.parseObject(content);
			return json;
		} catch (Exception e) {
			return null;
		}
	}
}
