package com.ejianc.business.bim.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.bim.vo.BimConnectVO;
import com.ejianc.business.bim.vo.BimDetailVO;
import com.ejianc.business.bim.vo.BimQureyVO;
import com.ejianc.business.bim.vo.BimVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.bim.bean.BimEntity;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * BIM模型
 * 
 * @author generator
 * 
 */
public interface IBimService extends IBaseService<BimEntity> {

    BimVO saveOrUpdate(BimVO saveOrUpdateVO);

    BimVO syncDetail(Long id);

//    Boolean syncState(Long projectId);

    JSONObject getHiddenItems(BimQureyVO queryVO);

    Boolean connect(BimConnectVO vo);

    Boolean oneUnConnect(Long bimDetailId);

    Boolean batchDownload(List<BimDetailVO> vos, HttpServletResponse response);

    String getViewerToken(String fileId, String path);

    Map<Long, String> getBimIdsMap(Long projectId);

    Map<Long, String> getContentMap(Long id);

}
