package com.ejianc.business.fill.controller;

import com.alibaba.fastjson.JSONObject;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.fill.bean.ProjectLightEntity;
import com.ejianc.business.fill.mapper.ProjectLightMapper;
import com.ejianc.business.fill.service.IProjectLightService;
import com.ejianc.business.fill.util.AddressUtil;
import com.ejianc.business.fill.util.IPUtils;
import com.ejianc.business.fill.vo.ProjectDynamicVO;
import com.ejianc.business.fill.vo.ProjectLightExportVO;
import com.ejianc.business.fill.vo.ProjectLightVO;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.business.plan.vo.ExecPlanDetailVO;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.utils.WeatherUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.maxmind.geoip2.DatabaseReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 项目亮灯关联实体
 *
 * @author generator
 */
@Controller
@RequestMapping("projectLight")
public class ProjectLightController implements Serializable {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IProjectLightService service;

    @Autowired
    private IDefdocApi defdocApi;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IProjectPoolApi projectApi;

    @Autowired
    private ProjectLightMapper lightMapper;

    /**
     * 项目看板列表
     *
     * @param param
     * @return
     */
    @RequestMapping(value = "/projectList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> monthPageList(@RequestBody QueryParam param) {
        return CommonResponse.success("查询列表数据成功！", service.projectList(param));
    }

    /**
     *
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {

        param.setPageIndex(1);
        param.setPageSize(-1);

        CommonResponse<JSONObject> commonResponse = this.monthPageList(param);
        List<ProjectLightVO> records = (List<ProjectLightVO>) commonResponse.getData().get("records");
        List<ProjectLightExportVO> list = BeanMapper.mapList(records, ProjectLightExportVO.class);

        if (ListUtil.isNotEmpty(list)) {
            for (ProjectLightExportVO vo : list) {
                if (null != vo.getProjectControlLevel()) {
                    vo.setControlLevelName(this.getDefDocById(vo.getProjectControlLevel()).getName());
                }
                if (null != vo.getContractualModel()) {
                    DefdocDetailVO defdoc = this.getDefDocById(vo.getContractualModel());
                    vo.setContractualModelName(defdoc != null ? defdoc.getName() : null);
                }

                if (LightTypeEnum.绿灯.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("绿灯");
                }else if (LightTypeEnum.蓝灯.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("蓝灯");
                }else if (LightTypeEnum.黄灯.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("黄灯");
                }else if (LightTypeEnum.红灯.getCode().equals(vo.getLightType())) {
                    vo.setLightTypeName("红灯");
                }else {
                    vo.setLightTypeName(null);
                }

                if (vo.getCriticalPath() != null && 1 == vo.getCriticalPath()) {
                    vo.setCriticalPathName("是");
                    Integer diffValue = vo.getDiffValue()!= null ? vo.getDiffValue().intValue() : 0;
                    vo.setProjectIsSet("预测滞后" + diffValue + "天");
                } else {
                    vo.setCriticalPathName("否");
                    vo.setProjectIsSet("预测未滞后");
                }

                if(vo.getSumWarn() != null){
                    vo.setSumWarnName(vo.getSumWarn().intValue() + "次");
                }
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("projectList-export.xlsx", beans, response);
    }

    /**
     * 根据id查询自定义档案
     * @param id
     * @return
     */
    public DefdocDetailVO getDefDocById(Long id){
        if(id == null) return new DefdocDetailVO();
        CommonResponse<DefdocDetailVO> resp = defdocApi.getDefDocById(id);
        if(!resp.isSuccess()){
            throw new BusinessException(resp.getMsg());
        }
        return resp.getData();
    }

    /**
     * 获取项目信息不含亮灯信息
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/getProjectInfoNotLight", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectLightVO> getProjectInfoNotLight(@RequestParam("projectId") Long projectId) {
        return CommonResponse.success("查询成功！", service.getProjectInfoNotLight(projectId));
    }

    /**
     * 获取天气
     *
     * @param request
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/getWeather", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getWeather(HttpServletRequest request) throws Exception {

        ClassPathResource resource = new ClassPathResource("GeoLite2-City_20210420/GeoLite2-City.mmdb");
        // 创建 GeoLite2 数据库
        // 读取数据库内容
        DatabaseReader reader = new DatabaseReader.Builder(resource.getInputStream()).build();
        // 访问IP
        String ip = IPUtils.getIP(request).split(",")[0];
        logger.info("IP:" + ip);
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            //ip = "115.60.179.221"; // 郑州
            ip = "222.240.44.187"; // 长沙

        }
        String p = IPUtils.getProvince(reader, ip);
        String c = IPUtils.getCity(reader, ip);
        // 省市为空，另外一种方案获取
        if(StringUtils.isEmpty(p) || StringUtils.isEmpty(c)){
            JSONObject json = AddressUtil.getAddresses(ip);
            p = json.getString("pro");
            c = json.getString("city");
        }
        JSONObject weather = WeatherUtil.getWeather(request, p, c);
        weather.put("province", p);
        weather.put("city", c);
        return CommonResponse.success("查询天气成功！", weather);
    }

    /**
     * 地图亮灯数量
     *
     * @return
     */
    @RequestMapping(value = "/numMap", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> numMap(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "orgType") Integer orgType) {
        return CommonResponse.success("查询详情数据成功！", service.numMap(orgId, orgType));
    }

    /**
     * 查询重点项目和重点监管项目亮灯状态
     * @param orgId
     * @param orgType
     * @return
     */
    @RequestMapping(value = "/getProjectLightInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectLightInfo(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "orgType") Integer orgType){
        return CommonResponse.success("查询详情数据成功！", service.getProjectLightInfo(orgId, orgType));
    }

    /**
     * 查询二级公司亮灯情况
     * @param orgId
     * @param orgType
     * @return
     */
    @RequestMapping(value = "/getCorpLightSum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Map>> getCorpLightSum(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "orgType") Integer orgType){
        return CommonResponse.success("查询详情数据成功！", service.getCorpLightSum(orgId, orgType));
    }

    /**
     * @Description 二级公司亮灯情况导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExportCorpLight", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportCorpLight(@RequestBody QueryParam param, HttpServletResponse response) {
        Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
        Integer orgType = Integer.valueOf(param.getParams().get("orgType").getValue().toString());
        List<Map> list = service.getCorpLightSum(orgId, orgType);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("corpLightList-export.xlsx", beans, response);
    }

    /**
     * 查询项目亮灯情况
     * @param orgId
     * @param orgType
     * @return
     */
    @RequestMapping(value = "/getProjectLightSum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WarnProjectVO>> getProjectLightSum(@RequestParam(value = "orgId") Long orgId, @RequestParam(value = "orgType") Integer orgType){
        return CommonResponse.success("查询详情数据成功！", service.getProjectLightSum(orgId, orgType));
    }


    @RequestMapping(value = "/getProjectInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getProjectInfo(@RequestParam("orgId") Long orgId){
        return CommonResponse.success("查询详情数据成功！", service.getProjectInfo(orgId));
    }

    /**
     * 查询本月一级节点
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getMonthFirstLevel", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExecPlanDetailVO>> getMonthFirstLevel(@RequestParam("orgId") Long orgId){
        return CommonResponse.success("查询详情数据成功！", service.getMonthFirstLevel(orgId));
    }

    /**
     * 查询该组织下所有项目
     * @param orgId
     * @return
     */
    @RequestMapping(value = "/getMapProjectList", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> getMapProjectList(@RequestParam("orgId") Long orgId, @RequestParam(value = "lightType",required = false) Integer lightType){
        return CommonResponse.success("查询详情数据成功！", service.getMapProjectList(orgId, lightType));
    }

    /**
     * 项目动态
     *
     * @param projectId
     * @return
     */
    @RequestMapping(value = "/projectDynamic", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ProjectDynamicVO>> projectDynamic(@RequestParam(value = "projectId") Long projectId) {
        return CommonResponse.success("查询详情数据成功！", service.projectDynamic(projectId));
    }

    /**
     * @param param
     * @Description queryRegisterReport 查询所有建造师信息
     */
    @RequestMapping(value = "/queryEasyProject", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ProjectLightVO>> queryEasyProject(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        fuzzyFields.add("department_name");
        fuzzyFields.add("org_name");


        /**
         *实现分页
         */
        Page<ProjectLightVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper(param);

        page.setRecords(lightMapper.queryEasyProject(page, wrapper));

        return CommonResponse.success("查询列表数据成功！", page);
    }

}
