package com.ejianc.business.fill.controller;

import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.fill.vo.WarnProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 *  工期预警
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("warn")
public class WarnController implements Serializable {
	private static final long serialVersionUID = 1L;
	
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    @Autowired
    private IWarnService service;

    /**
     * @Description 同步年计划亮灯状态
     */
    @RequestMapping(value = "/light", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse light(HttpServletRequest request) {
        return service.light(request);
    }


    /**
     * @Description 根据推送设置推送消息
     */
    @RequestMapping(value = "/pushNotice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse pushNotice(HttpServletRequest request) {
        return service.pushNotice(request);
    }

    /**
     * 项目进度查询表头
     * @Description queryProject 查询项目
     * @param orgId
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarnProjectVO> queryProject(@RequestParam("orgId") Long orgId) {
        return service.queryProject(orgId);
    }


}
