package com.ejianc.business.fill.service.impl;

import com.alibaba.fastjson.JSONObject;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import com.ejianc.business.fill.bean.DelnyTrendEntity;
import com.ejianc.business.fill.cons.FillConstant;
import com.ejianc.business.fill.emum.LightRuleLevelEnum;
import com.ejianc.business.fill.mapper.DelnyTrendMapper;
import com.ejianc.business.fill.service.IDelnyTrendService;
import com.ejianc.business.fill.service.IWarnService;
import com.ejianc.business.plan.bean.ExecPlanDetailEntity;
import com.ejianc.business.plan.bean.ExecPlanEntity;
import com.ejianc.business.plan.cons.PlanConstant;
import com.ejianc.business.plan.service.IExecPlanDetailService;
import com.ejianc.business.plan.utils.DateUtil;
import com.ejianc.business.progress.bean.LightRuleEntity;
import com.ejianc.business.progress.bean.LightRuleLevelEntity;
import com.ejianc.business.progress.enums.LevelEnum;
import com.ejianc.business.progress.enums.LightTypeEnum;
import com.ejianc.business.progress.utils.DateUtil2;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 延误趋势
 *
 * @author generator
 */
@Service("delnyTrendService")
public class DelnyTrendServiceImpl extends BaseServiceImpl<DelnyTrendMapper, DelnyTrendEntity> implements IDelnyTrendService {

    @Autowired
    private IWarnService warnService;
    @Autowired
    private IExecPlanDetailService execPlanDetailService;

    /**
     * 新增节点延误趋势
     *
     * @param execList
     * @return
     */
    @Override
    public Boolean execPlanDetailTrend(List<ExecPlanEntity> execList,Map<Long, LightRuleEntity> projectLightRuleMap) {

        List<Long> ids = new ArrayList<>();
        for (ExecPlanEntity execPlanEntity : execList) {
            List<ExecPlanDetailEntity> details = execPlanEntity.getAllList();
            for (ExecPlanDetailEntity detailEntity : details) {
                ids.add(detailEntity.getId());
            }
        }

        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());

        List<DelnyTrendEntity> list = ids.size() > 0 ? baseMapper.getNearTorday(ids, today) : new ArrayList<>();// 不包含今天
        List<DelnyTrendEntity> todayList = ids.size() > 0 ? baseMapper.getTodayTorday(ids, today) : new ArrayList<>();// 只有今天
        Map<Long, DelnyTrendEntity> nearMap = new HashMap<>();// 最近的，不包含今天
        for (DelnyTrendEntity entity : list) {
            nearMap.put(entity.getExecBid(), entity);
        }
        Map<Long, DelnyTrendEntity> todayMap = new HashMap<>();// 只包含今天
        if (todayList != null && todayList.size() > 0) {
            for (DelnyTrendEntity entity : todayList) {
                todayMap.put(entity.getExecBid(), entity);
            }
        }

        List<DelnyTrendEntity> saveOrUpdate = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();// 需要删除的
        for (ExecPlanEntity execPlanEntity : execList){

            // 获取亮灯规则
            LightRuleLevelEntity lightRuleLevel = warnService.getLightRuleLevel(projectLightRuleMap,execPlanEntity.getProjectId(), LightRuleLevelEnum.里程碑节点预警.getCode());

            //获取所有里程碑节点任务
            List<ExecPlanDetailEntity> execPlanDetails = execPlanEntity.getAllList().stream().filter(e -> PlanConstant.LEVEL_CONTRACT == e.getNodeLevel()).collect(Collectors.toList());
            for (ExecPlanDetailEntity ypd : execPlanDetails) {

                Integer status = null;
                if (null == ypd.getActualStart() && null == ypd.getActualFinish()){
                    status = FillConstant.NOT_STAR;
                }
                if (null != ypd.getActualStart() && null != ypd.getPredictFinish() && null == ypd.getActualFinish()){
                    status = FillConstant.UNDERWAY;
                }
                if (null != ypd.getActualStart() && null != ypd.getActualFinish()){
                    status = FillConstant.FINISHED;
                }

                // 偏差值
                Integer diffValueInt = DateUtil.getBetweenDays(ypd.getPredictFinish(), ypd.getPlanFinish());
                BigDecimal diffValue = new BigDecimal(diffValueInt);

                // 节点剩余工期
                BigDecimal residueValue = new BigDecimal(DateUtil.getBetweenDays(ypd.getPredictFinish(), new Date()));
                // 偏差日期/节点剩余工期
                BigDecimal finalValue = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(diffValue, residueValue), new BigDecimal(100));
                //获取亮灯状态
                Integer lightType = null;
                if (null != lightRuleLevel){
                    lightType = warnService.getLightType(lightRuleLevel, diffValue, finalValue, true,status);
                }

                // 先看今天有没有数据
                if (todayMap.containsKey(ypd.getId())) {// 如果今天有数据
                    DelnyTrendEntity todayEntity = todayMap.get(ypd.getId());
                    // 查看之前的数据和今天数据的关系
                    if (nearMap.containsKey(ypd.getId())) {// 再之前也有数据
                        //判断现在的数据和之前数据是否相同
                        DelnyTrendEntity nearEntity = nearMap.get(ypd.getId());
                        if (nearEntity.getDiffValue().compareTo(diffValue) == 0 && nearEntity.getCorpLightType() == lightType) { // 相同，则删除
                            delIds.add(todayEntity.getId());
                        } else {// 不同，则更新
                            todayEntity.setDiffValue(diffValue);
                            todayEntity.setCorpLightType(lightType);
                            saveOrUpdate.add(todayEntity);
                        }
                    } else { // 再之前没数据了
                        // 更新
                        todayEntity.setDiffValue(diffValue);
                        todayEntity.setCorpLightType(lightType);
                        saveOrUpdate.add(todayEntity);
                    }
                } else {// 今天没有数据
                    if (nearMap.containsKey(ypd.getId())) {// 之前已经存在数据
                        DelnyTrendEntity nearEntity = nearMap.get(ypd.getId());
                        if (nearEntity.getDiffValue().compareTo(diffValue) != 0 || nearEntity.getCorpLightType() != lightType) { // 不同，则新增
                            DelnyTrendEntity entity = new DelnyTrendEntity();
                            entity.setExecId(ypd.getProgressId());
                            entity.setExecBid(ypd.getId());
                            entity.setUpdateDate(today);
                            entity.setDiffValue(diffValue);
                            entity.setCorpLightType(lightType);
                            saveOrUpdate.add(entity);
                        }
                    } else { // 之前也不存在
                        // 新增
                        DelnyTrendEntity entity = new DelnyTrendEntity();
                        entity.setExecId(ypd.getProgressId());
                        entity.setExecBid(ypd.getId());
                        entity.setUpdateDate(today);
                        entity.setDiffValue(diffValue);
                        entity.setCorpLightType(lightType);
                        saveOrUpdate.add(entity);
                    }
                }

            }
        }

        if(saveOrUpdate.size() > 0) {
            super.saveOrUpdateBatch(saveOrUpdate, saveOrUpdate.size(), false);
        }
        if(delIds.size() > 0) {
            super.removeByIds(delIds,false);
        }
        return true;
    }


    @Override
    public JSONObject monthDelnyTrend(Long id) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        String thisMonth = df.format(new Date());

        List<String> keyList = new ArrayList<>();
        List<BigDecimal> valueList = new ArrayList<>();

        List<DelnyTrendEntity> entityList = baseMapper.monthTrend(id, thisMonth);

        for (DelnyTrendEntity dte : entityList) {
            keyList.add(dte.getUpdateDate());
            valueList.add(dte.getDiffValue());
        }

        keyList.add(thisMonth);
        valueList.add(getTodayDiffValue(id));

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }



    /**
     * 延误趋势折线图
     *
     * @param id
     * @return
     */
    @Override
    public JSONObject weekDelnyTrend(Long id) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String today = df.format(new Date());

        LambdaQueryWrapper<DelnyTrendEntity> lambda = Wrappers.<DelnyTrendEntity>lambdaQuery();
        lambda.eq(DelnyTrendEntity::getDr, 0);
        lambda.eq(DelnyTrendEntity::getExecBid, id);
        lambda.orderByAsc(DelnyTrendEntity::getUpdateDate);
        List<DelnyTrendEntity> entityList = super.list(lambda);

        JSONObject jsonObject = new JSONObject();
        List<String> keyList = new ArrayList<>();
        List<BigDecimal> valueList = new ArrayList<>();
        if (entityList == null || entityList.size() <= 0) {
            keyList.add(today);
            valueList.add(getTodayDiffValue(id));
            jsonObject.put("key", keyList);
            jsonObject.put("value", valueList);
            return jsonObject;
        }
        // 先补充完整
        String startDate = entityList.get(0).getUpdateDate();
        BigDecimal diffValue = entityList.get(0).getDiffValue();
        Map<String, BigDecimal> entityMap = new LinkedHashMap<>();
        Map<String, BigDecimal> fullMap = new LinkedHashMap<>();
        for (DelnyTrendEntity pte : entityList) {
            entityMap.put(pte.getUpdateDate(), pte.getDiffValue());
        }
        while (DateUtil2.compareTime(startDate, today) <= 0) {
            if (entityMap.containsKey(startDate)) {
                diffValue = entityMap.get(startDate);
            }
            fullMap.put(startDate, diffValue);
            startDate = DateUtil2.dateAdd(df, startDate, 1);
        }
        // 近三个月
        // todo 要显示全部
        String start = DateUtil2.getWeekOfMonthStartDate(df, 24);

        Map<String, BigDecimal> weekMap = new LinkedHashMap<>();
        Map<String, BigDecimal> resMap = new LinkedHashMap<>();
        for (int i = 1; DateUtil2.compareTime(start, today) <= 0; i++) {
            if (fullMap.containsKey(start)) {
                BigDecimal bvalue = fullMap.get(start);
                weekMap.put(start, bvalue);
            }
            start = DateUtil2.dateAdd(df, start, 1);
            if (DateUtil2.compareTime(start, today) == 0) {
                resMap.put(today, getTodayDiffValue(id));
            } else {
                if (i == 7) {
                    i = 0;
                    if (weekMap.size() > 0) {
                        resMap = maxWeekMap(weekMap, resMap);
                        weekMap = new LinkedHashMap<>();
                    }
                }
            }
        }


        for (String date : resMap.keySet()) {
            BigDecimal b = resMap.get(date);
            keyList.add(date);
            valueList.add(b);
        }

        jsonObject.put("key", keyList);
        jsonObject.put("value", valueList);
        return jsonObject;
    }

    private Map<String, BigDecimal> maxWeekMap(Map<String, BigDecimal> weekMap, Map<String, BigDecimal> resMap) {
        String d = weekMap.keySet().iterator().next();
        BigDecimal a = weekMap.get(d);
        for (String date : weekMap.keySet()) {
            BigDecimal b = weekMap.get(date);
            if (b.compareTo(a) > 0) {
                a = b;
                d = date;
            }
        }
        resMap.put(d, a);
        return resMap;
    }

    /**
     * 获取今天的偏差值
     *
     * @param id
     * @return
     */
    private BigDecimal getTodayDiffValue(Long id) {

        ExecPlanDetailEntity execPlanDetailEntity = execPlanDetailService.selectById(id);
        // 偏差值
        BigDecimal diffValue = new BigDecimal(DateUtil.getBetweenDays(execPlanDetailEntity.getPredictFinish(), execPlanDetailEntity.getPlanFinish()));

        return diffValue;

    }

}
